/* 
 *  @OPENGROUP_COPYRIGHT@
 *  COPYRIGHT NOTICE
 *  Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
 *  Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
 *  ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
 *  the full copyright text.
 *  
 *  This software is subject to an open license. It may only be
 *  used on, with or for operating systems which are themselves open
 *  source systems. You must contact The Open Group for a license
 *  allowing distribution and sublicensing of this software on, with,
 *  or for operating systems which are not Open Source programs.
 *  
 *  See http://www.opengroup.org/openmotif/license for full
 *  details of the license agreement. Any use, reproduction, or
 *  distribution of the program constitutes recipient's acceptance of
 *  this agreement.
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
 *  PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 *  WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
 *  OR FITNESS FOR A PARTICULAR PURPOSE
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
 *  NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
 *  EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
*/ 
/* (c) Copyright 1992, Integrated Computer Solutions, Inc. */

#ifndef _XmTableLayout_h
#define _XmiTableLayout_h

extern WidgetClass       xmTableLayoutWidgetClass;

#ifndef XmIsTableLayout
#define XmIsTableLayout(w)	XtIsSubclass(w, xmTableLayoutWidgetClass)
#endif /* XmcIsTableLayout */

typedef struct _XmTableLayoutClassRec *XmTableLayoutWidgetClass;
typedef struct _XmTableLayoutRec *XmTableLayoutWidget;

#define	XmTableLayoutIgnoreWidth	1
#define	XmTableLayoutIgnoreHeight	2
#define	XmTableLayoutIgnoreBoth	3

#define	XmTableLayoutFillWidth	1
#define	XmTableLayoutFillHeight	2
#define	XmTableLayoutFillBoth		3

/* The return value.  This is the result of an Ok or Apply callback,
 * (which are usually labeled done and save, respectively)
 *
 */

#define	XmTableLayoutClick		1
#define	XmTableLayoutDoubleClick	2
#define	XmTableLayoutHELP		3
#define	XmTableLayoutDrag		4
#define	XmTableLayoutRelease		5
#define	XmTableLayoutDrawCell	6

typedef struct {
	int		reason;		/* why */
	XEvent		*event;		/* the button press event that did it */
	Widget		eventWidget;	/* the widget that got the event */
	int		count;		/* how many times button was pressed */
	int		row, column;	/* nearest row and column */
} XmTableLayoutClickCallbackStruct;

typedef struct {
	int		reason;		/* why */
	XEvent		*event;		/* the button press event that did it */
	Widget		eventWidget;	/* the widget that got the event */
	int		count;		/* how many times button was pressed */
	int		row, column;	/* nearest row and column */
	int		baseRow;	/* where the drag began */
	int		baseColumn;	/* where the drag began */
} XmTableLayoutDragCallbackStruct;

typedef struct {
	int		reason;		/* why */
	int		row, column;	/* row and column to draw */
	int		x, y;		/* Where to draw on TableLayout Widget */
	Dimension	width, height;
} XmTableLayoutDrawCellCallbackStruct;


#if defined(__cplusplus)
extern "C" {
#endif


int	XmTableLayoutDoLayout(
#if NeedFunctionPrototypes
	Widget	w,
	int	doit
#endif
);

#define	AdjustWrap	1

void	XmTableLayoutRowAdjust(
#if NeedFunctionPrototypes
	Widget	w,
	int	from,
	int	to,
	int	adjust,
#if defined(c_plusplus) || defined(__cplusplus)
	int	wrap = 0
#else
	int	wrap
#endif
#endif
);

extern void	XmTableLayoutInsertColumns(
#if NeedFunctionPrototypes
	Widget	w,
	int	insertPoint,
	int	howMany
#endif
);

void	XmTableLayoutInsertRows(
#if NeedFunctionPrototypes
	Widget	w,
	int	insertPoint,
	int	howMany
#endif
);

void	XmTableLayoutDeleteColumns(
#if NeedFunctionPrototypes
	Widget	w,
	int	deletePoint,
	int	howMany
#endif
);

void	XmTableLayoutDeleteRows(
#if NeedFunctionPrototypes
	Widget	w,
	int	deletePoint,
	int	howMany
#endif
);

int	XmTableLayoutXYToRowColumn(
#if NeedFunctionPrototypes
	Widget	w,
	int	x, 
	int	y,
	int	*row,
	int	*column
#endif
);

Widget	XmTableLayoutRowColumnToWidget(
#if NeedFunctionPrototypes
	Widget	table,
	int	row,
	int	column
#endif
);

#if defined(__cplusplus)
}
#endif

/* DON'T ADD STUFF AFTER THIS #endif */
#endif /* _XmTableLayout_h */
