/* 
 *  @OPENGROUP_COPYRIGHT@
 *  COPYRIGHT NOTICE
 *  Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
 *  Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
 *  ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
 *  the full copyright text.
 *  
 *  This software is subject to an open license. It may only be
 *  used on, with or for operating systems which are themselves open
 *  source systems. You must contact The Open Group for a license
 *  allowing distribution and sublicensing of this software on, with,
 *  or for operating systems which are not Open Source programs.
 *  
 *  See http://www.opengroup.org/openmotif/license for full
 *  details of the license agreement. Any use, reproduction, or
 *  distribution of the program constitutes recipient's acceptance of
 *  this agreement.
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
 *  PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 *  WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
 *  OR FITNESS FOR A PARTICULAR PURPOSE
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
 *  NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
 *  EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
*/ 
/* 
 * HISTORY
*/ 
/* (c) Copyright 1990, Massachusetts Institute of Technology */
/*   Author:  Jim Fulton, MIT X Consortium */
/* (c) Copyright 1992, Integrated Computer Solutions, Inc. */
/*   Author:  Chris D. Peterson */

#ifndef _XmPortholeP_h
#define _XmPortholeP_h

#include <Xm/XmP.h>
#include <Xm/ManagerP.h>
#include <Xm/Porthole.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef Widget (*XmPortholeFindChildProc)(Widget);
typedef unsigned int (*XmPortholeUsableDimensionProc)(Widget);
typedef void (*XmPortholeLayoutProc)(Widget, Widget, XtWidgetGeometry *,
				     Position *, Position *,
				     Dimension *, Dimension *);
typedef void (*XmPortholePlaceChildrenProc)(Widget, Boolean,
					    Position, Position,
					    Dimension, Dimension);

#define XtInheritFindChild 	((XmPortholeFindChildProc)_XtInherit)
#define XtInheritUsable 	((XmPortholeUsableDimensionProc)_XtInherit)
#define XtInheritLayout 	((XmPortholeLayoutProc)_XtInherit)
#define XtInheritPlaceChildren 	((XmPortholePlaceChildrenProc)_XtInherit)

typedef struct _XmPortholeClassPart { /* new fields in widget class */
     XmPortholeFindChildProc 		find_child;
    XmPortholeUsableDimensionProc 	usable_width;
    XmPortholeUsableDimensionProc 	usable_height;
    XmPortholeLayoutProc		layout;
    XmPortholePlaceChildrenProc		place_children;
    XtPointer				extension;
} XmPortholeClassPart;

typedef struct _XmPortholeClassRec {	/* Porthole widget class */
    CoreClassPart 	core_class;
    CompositeClassPart 	composite_class;   
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
    XmPortholeClassPart	porthole_class;
} XmPortholeClassRec;

typedef struct _XmPortholePart {		/* new fields in widget */
    /* resources... */
    XtCallbackList report_callbacks;	/* callback/Callback */
    Boolean force_child_to_fill; /* Force the child to fill all space. */

    Dimension margin_height, margin_width;

    /* private data... */

    Window clip_win;		/* The clip window, so we don't write over
				   the shadows. */

    Widget current_child;	/* The old child that corrosponds to the 
				   preferred width and height. */
    Dimension p_child_width, p_child_height;

    XRectangle clip;		/* The clip window size. */
} XmPortholePart;

typedef struct _XmPortholeRec {
    CorePart 		core;
    CompositePart 	composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    XmPortholePart 	porthole;
} XmPortholeRec;

/*
 * external declarations
 */

extern XmPortholeClassRec xmPortholeClassRec;

#define XmPortholeIndex (XmManagerIndex + 1)

#define XmPorthole_report_callbacks(w) 	(((XmPortholeWidget)(w))->porthole.report_callbacks)
#define XmPorthole_force_child_to_fill(w) (((XmPortholeWidget)(w))->porthole.force_child_to_fill)
#define XmPorthole_margin_height(w) 	(((XmPortholeWidget)(w))->porthole.margin_height)
#define XmPorthole_margin_width(w) 	(((XmPortholeWidget)(w))->porthole.margin_width)
#define XmPorthole_clip_win(w) 		(((XmPortholeWidget)(w))->porthole.clip_win)
#define XmPorthole_current_child(w)	(((XmPortholeWidget)(w))->porthole.current_child)
#define XmPorthole_p_child_width(w) 	(((XmPortholeWidget)(w))->porthole.p_child_width)
#define XmPorthole_p_child_height(w)	(((XmPortholeWidget)(w))->porthole.p_child_height)
#define XmPorthole_clip(w)		(((XmPortholeWidget)(w))->porthole.clip)

#ifdef __cplusplus
}	/* Closes scope of 'extern "C"' declaration */
#endif

#endif /* _XmPortholeP_h */
    