/* Generated from the Telepathy spec

Copyright (C) 2005-2008 Collabora Limited
Copyright (C) 2005-2008 Nokia Corporation


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
*/

#include <glib-object.h>

G_BEGIN_DECLS

GType tp_error_get_type (void);

/**
 * TP_TYPE_ERROR:
 *
 * The GType of the Telepathy error enumeration.
 */
#define TP_TYPE_ERROR (tp_error_get_type())

/**
 * TpError:
 * @TP_ERROR_NETWORK_ERROR: org.freedesktop.Telepathy.Error.NetworkError:
 *     Raised when there is an error reading from or writing to the network.    
 * @TP_ERROR_NOT_IMPLEMENTED: org.freedesktop.Telepathy.Error.NotImplemented:
 *     Raised when the requested method, channel, etc is not available on this connection.    
 * @TP_ERROR_INVALID_ARGUMENT: org.freedesktop.Telepathy.Error.InvalidArgument:
 *     Raised when one of the provided arguments is invalid.    
 * @TP_ERROR_NOT_AVAILABLE: org.freedesktop.Telepathy.Error.NotAvailable:
 *     Raised when the requested functionality is temporarily unavailable.    
 * @TP_ERROR_PERMISSION_DENIED: org.freedesktop.Telepathy.Error.PermissionDenied:
 *     The user is not permitted to perform the requested operation.    
 * @TP_ERROR_DISCONNECTED: org.freedesktop.Telepathy.Error.Disconnected:
 *     The connection is not currently connected and cannot be used.    
 * @TP_ERROR_INVALID_HANDLE: org.freedesktop.Telepathy.Error.InvalidHandle:
 *     The contact name specified is unknown on this channel or connection.    
 * @TP_ERROR_CHANNEL_BANNED: org.freedesktop.Telepathy.Error.Channel.Banned:
 *     You are banned from the channel.    
 * @TP_ERROR_CHANNEL_FULL: org.freedesktop.Telepathy.Error.Channel.Full:
 *     The channel is full.    
 * @TP_ERROR_CHANNEL_INVITE_ONLY: org.freedesktop.Telepathy.Error.Channel.InviteOnly:
 *     The requested channel is invite-only.    
 * @TP_ERROR_NOT_YOURS: org.freedesktop.Telepathy.Error.NotYours:
 *     The requested channel or other resource already exists, and another       client is responsible for it    
 * @TP_ERROR_CANCELLED: org.freedesktop.Telepathy.Error.Cancelled:
 *     Raised by an ongoing request if it is cancelled by user request before       it has completed.    
 *
 * Enumerated type representing the Telepathy D-Bus errors.
 */
typedef enum {
    TP_ERROR_NETWORK_ERROR,
    TP_ERROR_NOT_IMPLEMENTED,
    TP_ERROR_INVALID_ARGUMENT,
    TP_ERROR_NOT_AVAILABLE,
    TP_ERROR_PERMISSION_DENIED,
    TP_ERROR_DISCONNECTED,
    TP_ERROR_INVALID_HANDLE,
    TP_ERROR_CHANNEL_BANNED,
    TP_ERROR_CHANNEL_FULL,
    TP_ERROR_CHANNEL_INVITE_ONLY,
    TP_ERROR_NOT_YOURS,
    TP_ERROR_CANCELLED,
} TpError;

G_END_DECLS
