/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.jgraph.graph.GraphModel;
import org.jgraph.pad.GPGraph;

public class GPConverter {
    static transient Hashtable hash;

    public static BufferedImage toImage(GPGraph gPGraph) {
        Object[] objectArray = gPGraph.getRoots();
        if (objectArray.length > 0) {
            Rectangle rectangle = gPGraph.getCellBounds(objectArray);
            gPGraph.toScreen(rectangle);
            Dimension dimension = rectangle.getSize();
            BufferedImage bufferedImage = new BufferedImage(dimension.width + 10, dimension.height + 10, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(gPGraph.getBackground());
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.translate(-rectangle.x + 5, -rectangle.y + 5);
            Object[] objectArray2 = gPGraph.getSelectionCells();
            boolean bl = gPGraph.isGridVisible();
            gPGraph.setGridVisible(false);
            gPGraph.clearSelection();
            gPGraph.paint(graphics2D);
            gPGraph.setSelectionCells(objectArray2);
            gPGraph.setGridVisible(bl);
            return bufferedImage;
        }
        return null;
    }

    public static String toGXL(GPGraph gPGraph, Object[] objectArray) {
        hash = new Hashtable();
        String string = "<gxl><graph>";
        int n = 0;
        while (n < objectArray.length) {
            if (gPGraph.isVertex(objectArray[n])) {
                hash.put(objectArray[n], new Integer(hash.size()));
            }
            ++n;
        }
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            string = string + GPConverter.vertexGXL(gPGraph, hash.get(k), k);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (gPGraph.isEdge(objectArray[n3])) {
                string = string + GPConverter.edgeGXL(gPGraph, new Integer(n2++), objectArray[n3]);
            }
            ++n3;
        }
        string = string + "\n</graph></gxl>";
        return string;
    }

    public static String vertexGXL(GPGraph gPGraph, Object object, Object object2) {
        String string = gPGraph.convertValueToString(object2);
        return "\n\t<node id=\"node" + object.toString() + "\">" + "\n\t\t<attr name=\"Label\">" + "\n\t\t\t<string>" + string + "</string>" + "\n\t\t</attr>" + "\n\t</node>";
    }

    public static String edgeGXL(GPGraph gPGraph, Object object, Object object2) {
        Object object3;
        String string;
        GraphModel graphModel = gPGraph.getModel();
        String string2 = "";
        if (graphModel.getSource(object2) != null && (string = hash.get(graphModel.getParent(graphModel.getSource(object2)))) != null) {
            string2 = "node" + string.toString();
        }
        string = "";
        if (graphModel.getTarget(object2) != null && (object3 = hash.get(graphModel.getParent(graphModel.getTarget(object2)))) != null) {
            string = "node" + object3.toString();
        }
        if (string2 != null && string != null) {
            object3 = gPGraph.convertValueToString(object2);
            return "\n\t<edge id=\"edge" + object.toString() + "\"" + " from=\"" + string2 + "\"" + " to=\"" + string + "\">" + "\n\t\t<attr name=\"Label\">" + "\n\t\t\t<string>" + (String)object3 + "</string>" + "\n\t\t</attr>" + "\n\t</edge>";
        }
        return "";
    }

    public static String toGraphviz(GPGraph gPGraph, Object[] objectArray) {
        hash = new Hashtable();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        String string = dateFormat.format(new Date());
        StringBuffer stringBuffer = new StringBuffer("/* Graphviz file generated by JGraph - " + string + " */" + "\n\ndigraph G {");
        int n = 0;
        while (n < objectArray.length) {
            if (gPGraph.isVertex(objectArray[n])) {
                hash.put(objectArray[n], new Integer(hash.size()));
            }
            ++n;
        }
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(GPConverter.vertexGraphviz(gPGraph, hash.get(k), k));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (gPGraph.isEdge(objectArray[n3])) {
                stringBuffer.append(GPConverter.edgeGraphviz(gPGraph, new Integer(n2++), objectArray[n3]));
            }
            ++n3;
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private static String vertexGraphviz(GPGraph gPGraph, Object object, Object object2) {
        if (object == null) {
            return "";
        }
        String string = gPGraph.convertValueToString(object2);
        if (string == null) {
            string = "";
        }
        return "\n\t" + object.toString() + " [label=\"" + string + "\", " + "shape=\"box\"];";
    }

    private static String edgeGraphviz(GPGraph gPGraph, Object object, Object object2) {
        GraphModel graphModel = gPGraph.getModel();
        String string = null;
        Object object3 = graphModel.getSource(object2);
        if (object3 != null) {
            Object v;
            Object v2 = hash.get(graphModel.getParent(object3));
            if (v2 != null) {
                string = v2.toString();
            }
            String string2 = null;
            Object object4 = graphModel.getTarget(object2);
            if (object4 != null && (v = hash.get(graphModel.getParent(object4))) != null) {
                string2 = v.toString();
            }
            if (string != null && string2 != null) {
                return "\n\t" + string + " -> " + string2 + ";";
            }
        }
        return "";
    }
}

