<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: AuthorizationFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Core
 */
class AuthorizationFactory extends Factory {
	protected $table = 'authorizations';
	protected $pk_sequence_name = 'authorizations_id_seq'; //PK Sequence name

	protected $obj_handler = NULL;

	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'object_type':
				$retval = array(
										//10 => 'default_schedule',
										//20 => 'schedule_amendment',
										//30 => 'shift_amendment',
										//40 => 'pay_stub_amendment',
										50 => 'request', //request_other
										//52 => 'request_vacation',
										//54 => 'request_missed_punch',
										//56 => 'request_edit_punch',
										//58 => 'request_absence',
										//59 => 'request_schedule',
										90 => 'timesheet',
									);
				break;
		}

		return $retval;
	}

	function isValidParent($user_id = NULL) {
		$user_id = trim($user_id);

		if ( empty($user_id) ) {
			global $current_user;

			if ( is_object($current_user) ) {
				$user_id = $current_user->getID();
			} else {
				return FALSE;
			}
		}

		$this->getObjectHandler()->getByID( $this->getObject() );
		$current_obj = $this->getObjectHandler()->getCurrent();

		$object_user_id = $current_obj->getUser();

		Debug::Text(' Authorizing User ID: '. $user_id , __FILE__, __LINE__, __METHOD__,10);
		Debug::Text(' Object User ID: '. $object_user_id , __FILE__, __LINE__, __METHOD__,10);

		$ulf = new UserListFactory();
		$company_id = $ulf->getById( $object_user_id )->getCurrent()->getCompany();
		Debug::Text(' Company ID: '. $company_id , __FILE__, __LINE__, __METHOD__,10);

		//Find proper hierarchy to use for this object
		$hotlf = new HierarchyObjectTypeListFactory();
		$control_id = $hotlf->getByCompanyIdAndObjectTypeId($company_id, $this->getObjectType() )->getCurrent()->getHierarchyControl();
		Debug::Text(' Control ID: '. $control_id , __FILE__, __LINE__, __METHOD__,10);

		$hlf = new HierarchyListFactory();
		$parent_arr = $hlf->getAllParentLevelIdArrayByHierarchyControlIdAndUserId($control_id, $object_user_id);
		//var_dump($parent_arr);

		if ( in_array($user_id, $parent_arr) ) {
			Debug::Text(' Authorizing User IS a parent of the object owner: ', __FILE__, __LINE__, __METHOD__,10);
			return TRUE;
		}

		Debug::Text(' Authorizing User is not a parent of the object owner: ', __FILE__, __LINE__, __METHOD__,10);

		return FALSE;
	}

	function isFinalAuthorization($user_id = NULL) {
		$user_id = trim($user_id);

		if ( empty($user_id) ) {
			global $current_user;

			if ( is_object($current_user) ) {
				$user_id = $current_user->getID();
			} else {
				return FALSE;
			}
		}

		Debug::Text(' User ID: '. $user_id , __FILE__, __LINE__, __METHOD__,10);

		$ulf = new UserListFactory();
		$company_id = $ulf->getById( $user_id )->getCurrent()->getCompany();
		Debug::Text(' Company ID: '. $company_id , __FILE__, __LINE__, __METHOD__,10);

		//Find proper hierarchy to use for this object
		$hotlf = new HierarchyObjectTypeListFactory();
		$control_id = $hotlf->getByCompanyIdAndObjectTypeId($company_id, $this->getObjectType() )->getCurrent()->getHierarchyControl();
		Debug::Text(' Control ID: '. $control_id , __FILE__, __LINE__, __METHOD__,10);

		$hlf = new HierarchyListFactory();
		$node_data = $hlf->getByHierarchyControlIdAndUserId( $control_id, $user_id );
		$parent_id = $node_data['parent_id'];

		Debug::Text(' Parent ID: (0 == FINAL): '. $parent_id , __FILE__, __LINE__, __METHOD__,10);
		if ( $parent_id == 0 ) {
			return TRUE;
		}

		return FALSE;
	}

	function getObjectHandler() {
		if ( is_object($this->obj_handler) ) {
			return $this->obj_handler;
		} else {

			switch ( $this->getObjectType() ) {
				/*
				case 10:
					$this->obj_handler = new DefaultScheduleControlUserListFactory();
					break;
				case 20:
					$this->obj_handler = new ScheduleAmendmentControlListFactory();
					break;
				case 30:
					$this->obj_handler = new ShiftAmendmentListFactory();
					break;
				*/
				case 50:
				case 52:
				case 54:
				case 56:
				case 58:
				case 59:
					$this->obj_handler = new RequestListFactory();
					break;
				case 90: //TimeSheet
					$this->obj_handler = new PayPeriodTimeSheetVerifyListFactory();
					break;
			}

			return $this->obj_handler;
		}
	}

	function getObjectType() {
		return $this->data['object_type_id'];
	}
	function setObjectType($type) {
		$type = trim($type);

		// i18n: passing 3rd param as false because object_type options do not use gettext
		$key = Option::getByValue($type, $this->getOptions('object_type'), false );
		if ($key !== FALSE) {
			$type = $key;
		}

		if ( $this->Validator->inArrayKey(	'object_type',
											$type,
											TTi18n::gettext('Object Type is invalid'),
											$this->getOptions('object_type')) ) {

			$this->data['object_type_id'] = $type;

			return FALSE;
		}

		return FALSE;
	}

	function getObject() {
		if ( isset($this->data['object_id']) ) {
			return $this->data['object_id'];
		}

		return FALSE;
	}
	function setObject($id) {
		$id = trim($id);

		if (	$this->Validator->isResultSetWithRows(	'object',
														$this->getObjectHandler()->getByID($id),
														TTi18n::gettext('Object ID is invalid')
														) ) {
			$this->data['object_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getAuthorized() {
		return $this->fromBool( $this->data['authorized'] );
	}
	function setAuthorized($bool) {
		$this->data['authorized'] = $this->toBool($bool);

		return true;
	}

	function clearHistory() {
		Debug::text('Clearing Authorization History For Type: '. $this->getObjectType() .' ID: '. $this->getObject(), __FILE__, __LINE__, __METHOD__, 10);

		if ( $this->getObjectType() === FALSE OR $this->getObject() === FALSE ) {
			Debug::text('Clearing Authorization History FAILED!', __FILE__, __LINE__, __METHOD__, 10);
			return FALSE;
		}

		$alf = new AuthorizationListFactory();
		$alf->getByObjectTypeAndObjectId( $this->getObjectType(), $this->getObject() );
		foreach( $alf as $authorization_obj ) {
			$authorization_obj->setDeleted(TRUE);
			$authorization_obj->Save();
		}

		return TRUE;
	}

	function Validate() {
		if ( $this->getDeleted() === FALSE
				AND $this->isFinalAuthorization() === FALSE
				AND $this->isValidParent() === FALSE ) {
			$this->Validator->isTrue(		'parent',
											FALSE,
											TTi18n::gettext('User authorizing this object is not a parent of it'));

			return FALSE;
		}
		return TRUE;
	}

	function preSave() {

		Debug::Text(' Calling preSave!: ', __FILE__, __LINE__, __METHOD__,10);
		$this->StartTransaction();

		return TRUE;
	}

	function postSave() {
		Debug::Text(' Post Save: ', __FILE__, __LINE__, __METHOD__,10);

		$not_valid = 0;

		$is_final_authorization = $this->isFinalAuthorization();
		//Don't even open the object unless this is the final auth level, or auth is declined.
		if ( $is_final_authorization === TRUE OR $this->getAuthorized() === FALSE ) { //For testing put UserID here.

			//Get user_id of object.
			$this->getObjectHandler()->getByID( $this->getObject() );
			$current_obj = $this->getObjectHandler()->getCurrent();

			//var_dump( $this->getObjectType() );

			if ( $this->getAuthorized() === TRUE AND $is_final_authorization === TRUE ) {
				Debug::Text(' Final Authorizing Object: '. $this->getObject() .' - Type: '. $this->getObjectType(), __FILE__, __LINE__, __METHOD__,10);

				switch ( $this->getObjectType() ) {
					case 10:
						Debug::Text(' Case: 10 '. $this->getObjectType(), __FILE__, __LINE__, __METHOD__,10);

						break;
					case 20:
						Debug::Text(' Case: 20: '. $this->getObjectType(), __FILE__, __LINE__, __METHOD__,10);

						break;
					case 30:
						Debug::Text(' Case: 30: '. $this->getObjectType(), __FILE__, __LINE__, __METHOD__,10);

						break;
					case 50:
						Debug::text('  Authorizing Request: ', __FILE__, __LINE__, __METHOD__,10);
						break;
				}

				if ( $not_valid == 0 ) {
					Debug::text('  Approving Authorization...', __FILE__, __LINE__, __METHOD__,10);
					Debug::Text(' Final Authorizing Object: '. $this->getObject() .' - Type: '. $this->getObjectType(), __FILE__, __LINE__, __METHOD__,10);
					$current_obj->setStatus(50); //Active/Authorized
					$current_obj->setAuthorized(TRUE);
				} else {
					Debug::text('  Saving failed, not approving amendment!: '. $not_valid, __FILE__, __LINE__, __METHOD__,10);
				}
			} elseif ( $this->getAuthorized() === FALSE ) {
				Debug::text('  Declining Authorization...', __FILE__, __LINE__, __METHOD__,10);
				$current_obj->setStatus(55); //'AUTHORIZATION DECLINED'
			}

			if ( $not_valid == 0 ) {
				Debug::text('  Object Valid...', __FILE__, __LINE__, __METHOD__,10);

				if ( $current_obj->isValid() ) {
					//Return true if object saved correctly.
					$retval = $current_obj->Save();

					if ( $retval === TRUE ) {
						$this->CommitTransaction();
						return TRUE;
					} else {
						$this->FailTransaction();
						return FALSE;
					}

				}
			}
		} else {
			$this->CommitTransaction();

			return TRUE;
		}

		//$this->CommitTransaction();
		//Always fail the transaction if we get this far.
		//This stops authorization entries from being inserted.
		$this->FailTransaction();

		return TRUE;
	}

	function addLog( $log_action ) {
		if ($this->getAuthorized() === TRUE ) {
			$authorized =  TTi18n::getText('True');
		} else {
			$authorized =  TTi18n::getText('False');
		}
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Authorization Object Type').': '.$this->getObjectType() .' '. TTi18n::getText('Authorized').': '. $authorized, NULL , $this->getTable() );
	}
}
?>
