/* valafloatingtype.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAFLOATINGTYPE_H__
#define __VALA_VALAFLOATINGTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valavaluetype.h>
#include <vala/valastruct.h>
#include <vala/valadatatype.h>

G_BEGIN_DECLS


#define VALA_TYPE_FLOATING_TYPE (vala_floating_type_get_type ())
#define VALA_FLOATING_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FLOATING_TYPE, ValaFloatingType))
#define VALA_FLOATING_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FLOATING_TYPE, ValaFloatingTypeClass))
#define VALA_IS_FLOATING_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FLOATING_TYPE))
#define VALA_IS_FLOATING_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FLOATING_TYPE))
#define VALA_FLOATING_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FLOATING_TYPE, ValaFloatingTypeClass))

typedef struct _ValaFloatingType ValaFloatingType;
typedef struct _ValaFloatingTypeClass ValaFloatingTypeClass;
typedef struct _ValaFloatingTypePrivate ValaFloatingTypePrivate;

/**
 * A floating-point type.
 */
struct _ValaFloatingType {
	ValaValueType parent_instance;
	ValaFloatingTypePrivate * priv;
};

struct _ValaFloatingTypeClass {
	ValaValueTypeClass parent_class;
};


ValaFloatingType* vala_floating_type_construct (GType object_type, ValaStruct* type_symbol);
ValaFloatingType* vala_floating_type_new (ValaStruct* type_symbol);
GType vala_floating_type_get_type (void);


G_END_DECLS

#endif
