##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY Lalo Martins ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
##############################################################################

from DocumentTemplate.DT_String import String
import string, random, Globals, os, glob
from DocumentTemplate import DT_Var, DT_Util
from fortunesetup import *

class FortuneTag:
    """DTML tag to display a line from a fortune cookie file
    (<dtml-fortune file file ...>)
    """

    # this is the minimal amount of meta-data needed by a DTML Tag.
    name='fortune'

    def __init__(self, args):
        if len (args):
            self.files = []
            for file in string.split (args):
                self.files.append (os.path.join (fortunedir, file))
                if not os.path.isfile (self.files[-1]):
                    del self.files[-1]
        else:
            self.files = glob.glob (os.path.join (fortunedir, '*.dat'))
	    for filenum in range (len (self.files)):
		# strip the ".dat", because we can't read the binary format
		self.files[filenum] = self.files[filenum][:-4]


    def render(self, md):
	if len (self.files) == 0:
	    return '<em>Fortune error: fortune cookie jar is empty!</em>'
        thefile = random.choice(self.files)
	cookie_jar = string.split (open (thefile, 'r').read(), '\n%\n')
	if len (cookie_jar) < 2:
	    return '<em>Fortune error: invalid fortune file %s</em>' % thefile
	cookie = None
	while (not cookie) and len (cookie_jar):
	    cookienum = random.randint (0, len (cookie_jar) - 1)
	    cookie = cookie_jar[cookienum]
	    if len (cookie) == 0 or len (cookie) > maxfortune:
		cookie = None
		del cookie_jar[cookienum]
	if cookie:
	    return DT_Var.newline_to_br (DT_Util.html_quote (cookie))
	else:
	    return '<em>Fortune error: no usable fortunes in %s</em>' % thefile


    # They mystery continues.
    # No one knows if this is necessary.

    __call__=render

String.commands['fortune'] = FortuneTag
