/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Target.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef TARGET_H
#define TARGET_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <vector>
#include "Vector3.h"
#include "FileReader.h"
#include "FileWriter.h"

namespace Animorph {

/*!
The format of Target file:
\verbatim
<int>,<float>,<float>,<float>
...
\endverbatim
*/

struct TargetData
{
  int vertex_number;
  Vector3f morph_vector;
};

class Target : public std::vector <TargetData>
{
private:
  //void fromStream (std::ifstream &in_stream);
  void createStream (std::ostringstream &out_stream);

public:

  /*!
   * \param filename the file with Target data to load
   * \return true if file is found
   * \return false if file isn't found
   */
  bool load (const std::string& filename);

  /*!
   * \param filename the file with Target data to save
   * \return true if file is found
   * \return false if file isn't found
   */
  bool save (const std::string& filename);
};

}

#endif	// TARGET_H
