/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSourceType;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectUtils {
    private static final Logger logger = Logger.getLogger(ArchitectUtils.class);
    private static final long startupTimeMillis = System.currentTimeMillis();

    private ArchitectUtils() {
    }

    public static void startup() {
    }

    public static void configureLog4j() {
        String configName = "log4j.properties";
        URL config = ArchitectUtils.class.getClassLoader().getResource(configName);
        if (config == null) {
            System.err.println("Warning: Couldn't find log4j config resource '" + configName + "'");
        } else {
            PropertyConfigurator.configure((URL)config);
            logger.info((Object)"Log4J configured successfully");
        }
    }

    public static void listenToHierarchy(SQLObjectListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Listening to new SQL Object " + source));
        source.addSQLObjectListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            Iterator it = source.getChildren().iterator();
            while (it.hasNext()) {
                ArchitectUtils.listenToHierarchy(listener, (SQLObject)it.next());
            }
        }
    }

    public static void addUndoListenerToHierarchy(UndoCompoundEventListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Undo Listening to new SQL Object " + source));
        source.addUndoEventListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            Iterator it = source.getChildren().iterator();
            while (it.hasNext()) {
                ArchitectUtils.addUndoListenerToHierarchy(listener, (SQLObject)it.next());
            }
        }
    }

    public static void addUndoListenerToHierarchy(UndoCompoundEventListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        for (int i = 0; i < sources.length; ++i) {
            ArchitectUtils.addUndoListenerToHierarchy(listener, sources[i]);
        }
    }

    public static void listenToHierarchy(SQLObjectListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        for (int i = 0; i < sources.length; ++i) {
            ArchitectUtils.listenToHierarchy(listener, sources[i]);
        }
    }

    public static void undoUnlistenToHierarchy(UndoCompoundEventListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Unlistening to SQL Object " + source));
        source.removeUndoEventListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            for (SQLObject ob : source.getChildren()) {
                ArchitectUtils.undoUnlistenToHierarchy(listener, ob);
            }
        }
    }

    public static void undoUnlistenToHierarchy(UndoCompoundEventListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        for (int i = 0; i < sources.length; ++i) {
            ArchitectUtils.undoUnlistenToHierarchy(listener, sources[i]);
        }
    }

    public static void unlistenToHierarchy(SQLObjectListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Removing " + listener + " from listener list of " + source));
        source.removeSQLObjectListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            logger.debug((Object)("        Now removing for children: " + source.getChildren()));
            for (SQLObject ob : source.getChildren()) {
                ArchitectUtils.unlistenToHierarchy(listener, ob);
            }
        }
    }

    public static void unlistenToHierarchy(SQLObjectListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        for (int i = 0; i < sources.length; ++i) {
            ArchitectUtils.unlistenToHierarchy(listener, sources[i]);
        }
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static List findColumnsSourcedFromDatabase(SQLDatabase target, SQLDatabase source) throws ArchitectException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for dependencies on " + source + " in " + target));
        }
        ArrayList<SQLColumn> matches = new ArrayList<SQLColumn>();
        for (SQLObject so : target.getChildren()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("-->Next target item is " + so.getClass().getName() + ": " + so + " (" + so.getChildCount() + " children)"));
            }
            if (!(so instanceof SQLTable)) continue;
            SQLTable t = (SQLTable)so;
            for (SQLColumn next : t.getColumns()) {
                SQLColumn col;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("---->Next item in columns list is a " + next.getClass().getName()));
                }
                if (!source.equals((col = next).getSourceColumn().getParentTable().getParentDatabase())) continue;
                matches.add(col);
            }
        }
        return matches;
    }

    public static boolean pokeDatabase(SQLObject source) throws ArchitectException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HELLO my class is " + source.getClass().getName() + ", my name is + " + source.getName()));
        }
        if (source.allowsChildren()) {
            int childCount;
            int j = 0;
            boolean done = false;
            try {
                childCount = source.getChildCount();
            }
            catch (ArchitectException e) {
                source.addChild(new SQLExceptionNode(e, "Error during initial database probe"));
                childCount = 1;
            }
            while (!done && j < childCount) {
                done = ArchitectUtils.pokeDatabase(source.getChild(j));
                ++j;
            }
            return done;
        }
        return true;
    }

    public static int countTablesSnapshot(SQLObject so) throws ArchitectException {
        if (so instanceof SQLTable) {
            return 1;
        }
        int count = 0;
        Iterator it = so.getChildren().iterator();
        while (it.hasNext()) {
            count += ArchitectUtils.countTablesSnapshot((SQLObject)it.next());
        }
        return count;
    }

    public static List findDescendentsByClass(SQLObject so, Class clazz, List list) throws ArchitectException {
        if (clazz.isAssignableFrom(so.getClass())) {
            list.add(so);
        } else {
            Iterator it = so.getChildren().iterator();
            while (it.hasNext()) {
                ArchitectUtils.findDescendentsByClass((SQLObject)it.next(), clazz, list);
            }
        }
        return list;
    }

    public static String truncateString(String s) {
        if (s == null || s.length() < 28) {
            return s;
        }
        return s.substring(27) + "...";
    }

    public static int countTables(SQLObject so) throws ArchitectException {
        if (so instanceof SQLTable) {
            return 1;
        }
        if (!so.allowsChildren() || !so.isPopulated() || so.getChildren() == null) {
            return 0;
        }
        int myCount = 0;
        Iterator it = so.getChildren().iterator();
        while (it.hasNext()) {
            myCount += ArchitectUtils.countTables((SQLObject)it.next());
        }
        return myCount;
    }

    public static String escapeXML(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(src.length() + 10);
        int n = src.length();
        block7: for (int i = 0; i < n; ++i) {
            char ch = src.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String quoteCSV(Object val) {
        if (val == null) {
            return "";
        }
        if (val instanceof String) {
            return ArchitectUtils.quoteCSVStr((String)val);
        }
        return val.toString();
    }

    public static String quoteCSVStr(String val) {
        CharSequence doubleQuote = "\"".subSequence(0, "\"".length());
        CharSequence doubleDoubleQuote = "\"\"".subSequence(0, "\"\"".length());
        CharSequence newLine = "\n".subSequence(0, "\n".length());
        CharSequence cr = "\r".subSequence(0, "\r".length());
        CharSequence comma = ",".subSequence(0, ",".length());
        if (val.contains(doubleQuote)) {
            StringBuffer sb = new StringBuffer(doubleQuote);
            sb.append(val.replace(doubleQuote, doubleDoubleQuote));
            sb.append(doubleQuote);
            return sb.toString();
        }
        if (val.contains(newLine) || val.contains(cr) || val.contains(comma)) {
            StringBuffer sb = new StringBuffer(doubleQuote);
            sb.append(val);
            sb.append(doubleQuote);
            return sb.toString();
        }
        return val;
    }

    public static List<SQLTable> extractTables(SQLObject start, List addTo) throws ArchitectException {
        if (start.allowsChildren()) {
            for (SQLObject so : start.getChildren()) {
                if (so instanceof SQLTable) {
                    addTo.add(so);
                    continue;
                }
                ArchitectUtils.extractTables(so, addTo);
            }
        }
        return addTo;
    }

    public static long getAppUptime() {
        return System.currentTimeMillis() - startupTimeMillis;
    }

    public static <T extends SQLObject> T getAncestor(SQLObject so, Class<T> ancestorType) {
        while (so != null) {
            if (so.getClass().equals(ancestorType)) {
                return (T)so;
            }
            so = so.getParent();
        }
        return null;
    }

    public static Collection<SQLTable> tablesUnder(SQLObject so) throws ArchitectException {
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
        if (so instanceof SQLTable) {
            tables.add((SQLTable)so);
        } else if (so.allowsChildren()) {
            for (SQLObject child : so.getChildren()) {
                tables.addAll(ArchitectUtils.tablesUnder(child));
            }
        }
        return tables;
    }

    public static SQLObject getTableContainer(SQLDatabase db, String catName, String schemaName) throws ArchitectException {
        db.populate();
        logger.debug((Object)("Looking for catalog=" + catName + ", schema=" + schemaName + " in db " + db));
        if (db.getChildType() == SQLTable.class) {
            if (catName != null || schemaName != null) {
                throw new IllegalArgumentException("Catalog or Schema name was given but neither is necessary.");
            }
            return db;
        }
        if (db.getChildType() == SQLSchema.class) {
            if (catName != null) {
                throw new IllegalArgumentException("Catalog name was given but is not necessary.");
            }
            if (schemaName == null) {
                throw new IllegalArgumentException("Schema name was expected but none was given.");
            }
            return (SQLSchema)db.getChildByNameIgnoreCase(schemaName);
        }
        if (db.getChildType() == SQLCatalog.class) {
            if (catName == null) {
                throw new IllegalArgumentException("Catalog name was expected but none was given.");
            }
            SQLCatalog tempCat = db.getCatalogByName(catName);
            if (tempCat == null) {
                return null;
            }
            tempCat.populate();
            logger.debug((Object)("Found catalog " + catName + ". Child Type=" + tempCat.getChildType()));
            if (tempCat.getChildType() == SQLSchema.class) {
                if (schemaName == null) {
                    throw new IllegalArgumentException("Schema name was expected but none was given.");
                }
                return (SQLSchema)tempCat.getChildByNameIgnoreCase(schemaName);
            }
            if (schemaName != null) {
                throw new IllegalArgumentException("Schema name was given but is not necessary.");
            }
            return tempCat;
        }
        if (db.getChildType() == null) {
            logger.debug((Object)("Database " + db + " has no children"));
            return null;
        }
        throw new IllegalStateException("Unknown database child type: " + db.getChildType());
    }

    public static <T> T getTreeObject(JTree tree, Class<T> type) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            for (Object o : path.getPath()) {
                if (!o.getClass().equals(type)) continue;
                return (T)o;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCompatibleWithHierarchy(SQLDatabase db, String catalog, String schema, String name) throws ArchitectException {
        SQLObject tableContainer;
        SQLObject schemaContainer;
        if (catalog != null) {
            if (!db.isCatalogContainer()) return false;
            schemaContainer = db.getCatalogByName(catalog);
            if (schemaContainer == null) {
                return true;
            }
        } else {
            schemaContainer = db;
        }
        if (schema != null) {
            if (schemaContainer.getChildType() != SQLSchema.class) return schemaContainer.getChildType() == null;
            tableContainer = schemaContainer.getChildByName(schema);
            if (tableContainer == null) {
                return true;
            }
        } else {
            tableContainer = schemaContainer;
        }
        if (name == null) return false;
        return tableContainer.getChildType() == null || tableContainer.getChildType() == SQLTable.class;
    }

    public static SQLTable addSimulatedTable(SQLDatabase db, String catalog, String schema, String name) throws ArchitectException {
        SQLObject tableContainer;
        SQLObject schemaContainer;
        if (db.getTableByName(catalog, schema, name) != null) {
            throw new ArchitectException("The table " + catalog + "." + schema + "." + name + " already exists");
        }
        if (catalog != null) {
            if (!db.isCatalogContainer()) {
                throw new ArchitectException("You tried to add a table with a catalog ancestor to a database that doesn't support catalogs.");
            }
            schemaContainer = db.getCatalogByName(catalog);
            if (schemaContainer == null) {
                schemaContainer = new SQLCatalog(db, catalog, true);
                db.addChild(schemaContainer);
            }
        } else {
            schemaContainer = db;
        }
        if (schema != null) {
            Class<? extends SQLObject> childType = schemaContainer.getChildType();
            if (childType != null && childType != SQLSchema.class) {
                throw new ArchitectException("The schema container (" + schemaContainer + ") can't actually contain children of type SQLSchema.");
            }
            tableContainer = schemaContainer.getChildByName(schema);
            if (tableContainer == null) {
                tableContainer = new SQLSchema(schemaContainer, schema, true);
                schemaContainer.addChild(tableContainer);
            }
        } else {
            tableContainer = schemaContainer;
        }
        SQLTable newTable = new SQLTable(tableContainer, name, null, "TABLE", true);
        tableContainer.addChild(newTable);
        return newTable;
    }

    public static File jarSpecToFile(String jarFileName, ClassLoader classLoader) {
        File listedFile;
        String builtIn = "builtin:";
        if (jarFileName.startsWith(builtIn)) {
            String jarName = jarFileName.substring(builtIn.length());
            URL resource = classLoader.getResource(jarName);
            ArchitectDataSourceType.logger.debug((Object)(resource + " path = " + resource.getPath()));
            try {
                listedFile = new File(URLDecoder.decode(resource.getPath(), "iso8859-1"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("couldn't decode url with iso8859-1", ex);
            }
        } else {
            listedFile = new File(jarFileName);
        }
        return listedFile;
    }
}

