/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.PlDotIni;
import ca.sqlpower.architect.PrintUserSettings;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.ddl.DDLUserSettings;
import ca.sqlpower.architect.etl.ETLUserSettings;
import ca.sqlpower.architect.qfa.QFAUserSettings;
import ca.sqlpower.architect.swingui.SwingUserSettings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUserSettings {
    private static final Logger logger = Logger.getLogger(CoreUserSettings.class);
    private DataSourceCollection plDotIni;
    private String plDotIniPath;
    private PrintUserSettings printUserSettings = new PrintUserSettings();
    private UserSettings swingSettings = new SwingUserSettings();
    private ETLUserSettings etlUserSettings = new ETLUserSettings();
    private DDLUserSettings ddlUserSettings = new DDLUserSettings();
    private QFAUserSettings qfaUserSettings = new QFAUserSettings();

    public void setPrintUserSettings(PrintUserSettings printUserSettings) {
        this.printUserSettings = printUserSettings;
    }

    public PrintUserSettings getPrintUserSettings() {
        return this.printUserSettings;
    }

    public UserSettings getSwingSettings() {
        return this.swingSettings;
    }

    public void setSwingSettings(UserSettings sprefs) {
        this.swingSettings = sprefs;
    }

    public ETLUserSettings getETLUserSettings() {
        return this.etlUserSettings;
    }

    public void setETLUserSettings(ETLUserSettings v) {
        this.etlUserSettings = v;
    }

    public QFAUserSettings getQfaUserSettings() {
        return this.qfaUserSettings;
    }

    public void setQfaUserSettings(QFAUserSettings qfaUserSettings) {
        this.qfaUserSettings = qfaUserSettings;
    }

    public DDLUserSettings getDDLUserSettings() {
        return this.ddlUserSettings;
    }

    public void setDDLUserSettings(DDLUserSettings v) {
        this.ddlUserSettings = v;
    }

    public boolean isPlDotIniPathValid() {
        logger.debug((Object)("Checking pl.ini path: " + this.getPlDotIniPath()));
        String path = this.getPlDotIniPath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.canRead() && f.isFile();
    }

    public DataSourceCollection getPlDotIni() {
        String path = this.getPlDotIniPath();
        if (path == null) {
            return null;
        }
        if (this.plDotIni == null) {
            this.plDotIni = new PlDotIni();
            try {
                logger.debug((Object)"Reading PL.INI defaults");
                this.plDotIni.read(this.getClass().getClassLoader().getResourceAsStream("default_database_types.ini"));
            }
            catch (IOException e) {
                throw new ArchitectRuntimeException(new ArchitectException("Failed to read system resource default_database_types.ini", e));
            }
            try {
                if (this.plDotIni != null) {
                    logger.debug((Object)"Reading new PL.INI instance");
                    this.plDotIni.read(new File(path));
                }
            }
            catch (IOException e) {
                throw new ArchitectRuntimeException(new ArchitectException("Failed to read pl.ini at \"" + this.getPlDotIniPath() + "\"", e));
            }
        }
        return this.plDotIni;
    }

    public void setPlDotIni(DataSourceCollection ini) {
        logger.debug((Object)("got new pl.ini \"" + ini + "\""));
        this.plDotIni = ini;
    }

    public String getPlDotIniPath() {
        return this.plDotIniPath;
    }

    public void setPlDotIniPath(String plDotIniPath) {
        logger.debug((Object)("PlDotIniPath changing from \"" + this.plDotIniPath + "\" to \"" + plDotIniPath + "\""));
        if (this.plDotIniPath != null && this.plDotIniPath.equals(plDotIniPath)) {
            return;
        }
        this.plDotIniPath = plDotIniPath;
        this.plDotIni = null;
    }

    public List<ArchitectDataSource> getConnections() {
        return this.getPlDotIni().getConnections();
    }
}

