/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl.datamover;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.DepthFirstSearch;
import ca.sqlpower.architect.PlDotIni;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMover {
    private static final Logger logger = Logger.getLogger(DataMover.class);
    private String lastSqlString;
    private boolean truncatingDestinationTable;
    private String blobTextEncoding = "iso8859-1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyTable(SQLTable destTable, SQLTable sourceTable) throws SQLException, ArchitectException, UnsupportedEncodingException {
        String destTableName = DDLUtils.toQualifiedName(destTable);
        String sourceTableName = DDLUtils.toQualifiedName(sourceTable);
        Connection srcCon = null;
        Connection dstCon = null;
        Statement srcStmt = null;
        Statement dstStmt = null;
        ResultSet srcRS = null;
        ResultSetMetaData srcRSMD = null;
        long startTime = System.currentTimeMillis();
        int numRows = 0;
        try {
            srcCon = sourceTable.getParentDatabase().getConnection();
            dstCon = destTable.getParentDatabase().getConnection();
            srcStmt = srcCon.createStatement();
            this.lastSqlString = "select * from " + sourceTableName;
            srcRS = srcStmt.executeQuery(this.lastSqlString);
            srcRSMD = srcRS.getMetaData();
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.summarizeResultSetMetaData(srcRSMD));
            }
            if (this.truncatingDestinationTable) {
                Statement delStmt = null;
                try {
                    delStmt = dstCon.createStatement();
                    this.lastSqlString = "DELETE FROM " + destTableName;
                    int count = delStmt.executeUpdate(this.lastSqlString);
                    logger.info((Object)("Deleted " + count + " rows from destination table"));
                }
                finally {
                    if (delStmt != null) {
                        delStmt.close();
                    }
                }
            }
            if (destTable.getColumnByName("rowid") != null) {
                SQLColumn rowidCol = destTable.getColumnByName("rowid");
                destTable.removeColumn(rowidCol);
            }
            this.lastSqlString = this.generateInsertStatement(destTable);
            dstStmt = dstCon.prepareStatement(this.lastSqlString);
            int numberOfColumns = destTable.getColumns().size();
            while (srcRS.next()) {
                logger.debug((Object)("Row " + numRows + " of " + destTableName));
                for (int col = 0; col < numberOfColumns; ++col) {
                    int sourceColIndex;
                    SQLColumn destCol = destTable.getColumn(col);
                    SQLColumn sourceCol = sourceTable.getColumnByName(destCol.getName());
                    int n = sourceColIndex = sourceCol == null ? -1 : srcRS.findColumn(sourceCol.getName());
                    if (logger.isDebugEnabled()) {
                        if (sourceCol == null) {
                            logger.debug((Object)("   Source column " + destCol.getName() + " not found!"));
                        } else {
                            logger.debug((Object)("   " + srcRS.getObject(sourceColIndex) + " (type=" + srcRSMD.getColumnType(sourceColIndex) + ")"));
                        }
                    }
                    if (sourceCol == null) {
                        dstStmt.setObject(col + 1, null, destCol.getType());
                        continue;
                    }
                    if (srcRSMD.getColumnType(sourceColIndex) == 2004 && destCol.getType() == 12) {
                        Blob blob = srcRS.getBlob(sourceColIndex);
                        String text = new String(blob.getBytes(1L, (int)blob.length()), this.blobTextEncoding);
                        dstStmt.setString(col + 1, text);
                        continue;
                    }
                    dstStmt.setObject(col + 1, srcRS.getObject(sourceColIndex), srcRSMD.getColumnType(sourceColIndex));
                }
                dstStmt.executeUpdate();
                ++numRows;
            }
            dstCon.commit();
            logger.info((Object)"Committed transaction");
        }
        catch (SQLException e) {
            dstCon.rollback();
            throw e;
        }
        finally {
            if (srcRS != null) {
                srcRS.close();
            }
            if (srcStmt != null) {
                srcStmt.close();
            }
            if (dstStmt != null) {
                dstStmt.close();
            }
            if (srcCon != null) {
                srcCon.close();
            }
            if (dstCon != null) {
                dstCon.close();
            }
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        logger.info((Object)(numRows + " rows copied in " + elapsedTime + " ms. (" + (double)numRows / (double)elapsedTime * 1000.0 + " rows/sec)"));
        return numRows;
    }

    private String summarizeResultSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        StringBuffer summary = new StringBuffer(200);
        int numberOfColumns = rsmd.getColumnCount();
        summary.append("Table ").append(rsmd.getTableName(1)).append("\n");
        for (int col = 1; col <= numberOfColumns; ++col) {
            summary.append("Column ").append(col).append(": ");
            summary.append(rsmd.getColumnName(col));
            summary.append(" JDBC datatype ").append(rsmd.getColumnType(col));
            summary.append(" (").append(rsmd.getColumnClassName(col)).append(")");
            summary.append(rsmd.isNullable(col) == 1 ? "" : " NOT NULL");
            summary.append("\n");
        }
        return summary.toString();
    }

    private String generateInsertStatement(SQLTable destTable) throws SQLException, ArchitectException {
        StringBuffer sql = new StringBuffer(200);
        sql.append("INSERT INTO ").append(DDLUtils.toQualifiedName(destTable)).append(" (");
        boolean first = true;
        for (SQLColumn col : destTable.getColumns()) {
            if (!first) {
                sql.append(", ");
            }
            sql.append(col.getName());
            first = false;
        }
        sql.append(") VALUES (");
        for (int i = 0; i < destTable.getColumns().size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    public void copyTables(SQLObject destTableContainer, Collection<SQLTable> sourceTables) throws ArchitectException, SQLException, UnsupportedEncodingException {
        HashSet<SQLTable> destTables = new HashSet<SQLTable>();
        HashMap<String, SQLTable> sourceTableMap = new HashMap<String, SQLTable>();
        for (SQLTable sourceTable : sourceTables) {
            SQLTable destTable = (SQLTable)destTableContainer.getChildByNameIgnoreCase(sourceTable.getName());
            if (destTable == null) {
                logger.warn((Object)("Skipping source table " + sourceTable + " because there is no corresponding target table"));
                continue;
            }
            destTables.add(destTable);
            sourceTableMap.put(destTable.getName(), sourceTable);
        }
        List allDestTables = destTableContainer.getChildren();
        DepthFirstSearch dfs = new DepthFirstSearch(allDestTables);
        allDestTables = dfs.getFinishOrder();
        logger.debug((Object)("Safe load order is: " + allDestTables));
        if (this.truncatingDestinationTable) {
            Connection destCon = ArchitectUtils.getAncestor(destTableContainer, SQLDatabase.class).getConnection();
            Statement destStmt = destCon.createStatement();
            ArrayList backwardDestList = new ArrayList(allDestTables);
            backwardDestList.retainAll(destTables);
            Collections.reverse(backwardDestList);
            for (SQLTable t : backwardDestList) {
                String destTableName = DDLUtils.toQualifiedName(t);
                logger.debug((Object)("About to delete from " + destTableName));
                this.lastSqlString = "DELETE FROM " + destTableName;
                destStmt.executeUpdate(this.lastSqlString);
            }
            destCon.close();
        }
        for (SQLTable destTable : allDestTables) {
            if (!destTables.contains(destTable)) continue;
            SQLTable sourceTable = (SQLTable)sourceTableMap.get(destTable.getName());
            this.copyTable(destTable, sourceTable);
        }
    }

    public String getBlobTextEncoding() {
        return this.blobTextEncoding;
    }

    public void setBlobTextEncoding(String blobTextEncoding) {
        this.blobTextEncoding = blobTextEncoding;
    }

    public boolean isTruncatingDestinationTable() {
        return this.truncatingDestinationTable;
    }

    public void setTruncatingDestinationTable(boolean truncatingDestinationTable) {
        this.truncatingDestinationTable = truncatingDestinationTable;
    }

    public String getLastSqlString() {
        return this.lastSqlString;
    }

    public static void main(String[] args) throws Exception {
        DataMover dm = new DataMover();
        DataSourceCollection dataSources = null;
        String sourceConnectionName = null;
        String destConnectionName = null;
        String sourceCat = null;
        String destCat = null;
        String sourceSchema = null;
        String destSchema = null;
        boolean updatingSequences = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("--")) continue;
            Pattern p = Pattern.compile("--(.*)=(.*)");
            Matcher m = p.matcher(arg);
            if (!m.matches()) {
                System.out.println("Malformed parameter: " + arg);
                DataMover.usage();
                return;
            }
            String argName = m.group(1);
            String argVal = m.group(2);
            if (argName.equals("pl-ini")) {
                dataSources = new PlDotIni();
                dataSources.read(new File(argVal));
                continue;
            }
            if (argName.equals("blob-encoding")) {
                dm.setBlobTextEncoding(argVal);
                continue;
            }
            if (argName.equals("truncate-dest")) {
                dm.setTruncatingDestinationTable(argVal.equalsIgnoreCase("true"));
                continue;
            }
            if (argName.equals("update-seq")) {
                updatingSequences = argVal.equalsIgnoreCase("true");
                continue;
            }
            if (argName.equals("source-db")) {
                sourceConnectionName = argVal;
                continue;
            }
            if (argName.equals("target-db")) {
                destConnectionName = argVal;
                continue;
            }
            if (argName.equals("source-cat")) {
                sourceCat = argVal;
                continue;
            }
            if (argName.equals("target-cat")) {
                destCat = argVal;
                continue;
            }
            if (argName.equals("source-schema")) {
                sourceSchema = argVal;
                continue;
            }
            if (argName.equals("target-schema")) {
                destSchema = argVal;
                continue;
            }
            System.out.println("Unknown argument " + argName);
            DataMover.usage();
            return;
        }
        if (dataSources == null) {
            System.out.println("The pl-ini argument is required.");
            return;
        }
        if (sourceConnectionName == null) {
            System.out.println("The source-db argument is required.");
            return;
        }
        ArchitectDataSource sourceConnectionSpec = dataSources.getDataSource(sourceConnectionName);
        if (sourceConnectionSpec == null) {
            System.out.println("Couldn't find connection \"" + sourceConnectionName + "\" in the pl.ini. Available connections:");
            System.out.println(dataSources.getConnections());
            return;
        }
        SQLDatabase source = new SQLDatabase(sourceConnectionSpec);
        if (destConnectionName == null) {
            System.out.println("The target-db argument is required.");
            return;
        }
        ArchitectDataSource destConnectionSpec = dataSources.getDataSource(destConnectionName);
        if (destConnectionSpec == null) {
            System.out.println("Couldn't find connection \"" + destConnectionName + "\" in the pl.ini. Available connections:");
            System.out.println(dataSources.getConnections());
            return;
        }
        SQLDatabase dest = new SQLDatabase(destConnectionSpec);
        SQLObject sourceTableContainer = ArchitectUtils.getTableContainer(source, sourceCat, sourceSchema);
        if (sourceTableContainer == null) {
            System.out.println("Couldn't find database location. db=" + source.getName() + " catalog=" + sourceCat + " schema=" + sourceSchema);
            return;
        }
        List sourceTables = sourceTableContainer.getChildren();
        System.out.println("Found source tables: " + sourceTables);
        SQLObject destTableContainer = ArchitectUtils.getTableContainer(dest, destCat, destSchema);
        dm.copyTables(destTableContainer, sourceTables);
        if (updatingSequences) {
            Connection srcCon = source.getConnection();
            Connection dstCon = dest.getConnection();
            DataMover.updateSequences(srcCon, dstCon);
            srcCon.close();
            dstCon.close();
        }
    }

    private static void usage() {
        System.out.println("DataMover: A utility for synchronizing the data between databases");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("  datamover [args] --source-db=dbName --source-cat=catalog --source-schema=schema --target-db=dbName --target-cat=catalog --target-schema=schema");
        System.out.println("");
        System.out.println("  sourceDbName and targetDbName are pl.ini logical connection names");
        System.out.println("");
        System.out.println("Available Arguments:");
        System.out.println("  --pl-ini=path       Path (relative or absolute) to the PL.INI file to use");
        System.out.println("  --blob-encoding=enc Character encoding to assume for BLOBs that contain text");
        System.out.println("  --truncate-dest=t/f truncate destination table before loading? (true/false)");
        System.out.println("  --update-seq=t/f    update current value of sequences in target database (true/false)");
    }

    private static void updateSequences(Connection srcCon, Connection dstCon) throws SQLException {
        Statement srcStmt = srcCon.createStatement();
        Statement dstStmt = dstCon.createStatement();
        ResultSet rs = srcStmt.executeQuery("SELECT sequence_name, last_number FROM user_sequences");
        while (rs.next()) {
            String sequenceName = rs.getString(1);
            int lastNumber = rs.getInt(2);
            String sql = "ALTER SEQUENCE " + sequenceName + " RESTART WITH " + lastNumber;
            logger.debug((Object)sql);
            try {
                dstStmt.executeUpdate(sql);
            }
            catch (SQLException ex) {
                logger.warn((Object)("Couldn't execute sequence update: " + sql), (Throwable)ex);
            }
        }
        dstStmt.close();
        rs.close();
        srcStmt.close();
    }
}

