/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ConnectionComboBoxModel;
import ca.sqlpower.architect.swingui.DataSourceRenderer;
import ca.sqlpower.architect.swingui.event.CatalogComboBoxListener;
import ca.sqlpower.architect.swingui.event.DatabaseComboBoxListener;
import ca.sqlpower.architect.swingui.event.NewDatabaseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DatabaseSelector {
    private JComboBox connectionsBox;
    private JComboBox schemaBox;
    private JComboBox catalogBox;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JButton newButton;
    private DatabaseComboBoxListener dcl;
    private JPanel parent;

    public DatabaseSelector(JComboBox connectionsBox, JComboBox schemaBox, JComboBox catalogBox, JButton newButton, JProgressBar progressBar, JLabel progressLabel, JPanel parent) {
        this.connectionsBox = connectionsBox;
        this.schemaBox = schemaBox;
        this.catalogBox = catalogBox;
        this.progressBar = progressBar;
        this.progressLabel = progressLabel;
        this.parent = parent;
        this.setup();
    }

    public DatabaseSelector(JProgressBar progressBar, JLabel progressLabel, JPanel parent) {
        this.progressBar = progressBar;
        this.progressLabel = progressLabel;
        this.parent = parent;
        this.newButton = new JButton(" New ");
        this.connectionsBox = new JComboBox();
        this.catalogBox = new JComboBox();
        this.schemaBox = new JComboBox();
        this.setup();
    }

    public void setup() {
        this.connectionsBox.setModel(new ConnectionComboBoxModel());
        this.connectionsBox.setRenderer(new DataSourceRenderer());
        this.newButton.addActionListener(new NewDatabaseListener(ArchitectFrame.getMainInstance(), "New Database", this.connectionsBox));
        this.dcl = new DatabaseComboBoxListener(this.parent, this.connectionsBox, this.catalogBox, this.schemaBox, this.progressBar);
        this.connectionsBox.addActionListener(this.dcl);
        this.catalogBox.addActionListener(new CatalogComboBoxListener(this.parent, this.connectionsBox, this.catalogBox, this.schemaBox));
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public void setNewButton(JButton newButton) {
        this.newButton = newButton;
    }

    public JPanel getParent() {
        return this.parent;
    }

    public void setParent(JPanel parent) {
        this.parent = parent;
    }

    public JComboBox getCatalogBox() {
        return this.catalogBox;
    }

    public void setCatalogBox(JComboBox catalogBox) {
        this.catalogBox = catalogBox;
    }

    public JComboBox getConnectionsBox() {
        return this.connectionsBox;
    }

    public void setConnectionsBox(JComboBox connectionsBox) {
        this.connectionsBox = connectionsBox;
    }

    public JLabel getProgressLabel() {
        return this.progressLabel;
    }

    public void setProgressLabel(JLabel label) {
        this.progressLabel = label;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public JComboBox getSchemaBox() {
        return this.schemaBox;
    }

    public void setSchemaBox(JComboBox schemaBox) {
        this.schemaBox = schemaBox;
    }
}

