/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.event;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CatalogComboBoxListener
implements ActionListener {
    private JPanel panel;
    private JComboBox databaseDropdown;
    private JComboBox catalogDropdown;
    private JComboBox schemaDropdown;

    public CatalogComboBoxListener(JPanel panel, JComboBox databaseDropdown, JComboBox catalogDropdown, JComboBox schemaDropdown) {
        this.panel = panel;
        this.databaseDropdown = databaseDropdown;
        this.catalogDropdown = catalogDropdown;
        this.schemaDropdown = schemaDropdown;
    }

    public void actionPerformed(ActionEvent e) {
        this.schemaDropdown.removeAllItems();
        this.schemaDropdown.setEnabled(false);
        if (this.databaseDropdown.getSelectedItem() == null) {
            this.catalogDropdown.setEnabled(false);
            return;
        }
        SQLDatabase database = new SQLDatabase((ArchitectDataSource)this.databaseDropdown.getSelectedItem());
        if (database == null || this.catalogDropdown.getSelectedItem() == null) {
            Object catalog = null;
            return;
        }
        SQLCatalog catalog = (SQLCatalog)this.catalogDropdown.getSelectedItem();
        try {
            catalog.populate();
            if (catalog.getChildType() != SQLSchema.class) {
                return;
            }
            for (SQLObject o : catalog.getChildren()) {
                this.schemaDropdown.addItem(o);
            }
            this.schemaDropdown.setEnabled(true);
        }
        catch (ArchitectException ex) {
            JOptionPane.showMessageDialog(this.panel, "Database Connection Erorr", "Error", 0);
        }
    }
}

