/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.StringTokenizer;

public class ByteColonFormat
extends Format {
    protected boolean usingColons = true;

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        byte[] inputBytes = (byte[])obj;
        char[] hexDigits = new char[2];
        int i = 0;
        while (true) {
            toAppendTo.append(ByteColonFormat.byteToChars(inputBytes[i], hexDigits));
            if (i == inputBytes.length - 1) break;
            if (this.usingColons) {
                toAppendTo.append(':');
            }
            ++i;
        }
        return toAppendTo;
    }

    public byte[] parse(String source) {
        return (byte[])this.parseObject(source, new ParsePosition(0));
    }

    public Object parseObject(String source, ParsePosition pos) {
        String subsource = source.substring(pos.getIndex());
        StringTokenizer st = new StringTokenizer(subsource, ":");
        byte[] outputBytes = new byte[st.countTokens()];
        try {
            for (int i = 0; i < outputBytes.length; ++i) {
                String thisToken = st.nextToken();
                outputBytes[i] = ByteColonFormat.stringToByte(thisToken);
            }
            pos.setIndex(source.length());
        }
        catch (ParseException e) {
            // empty catch block
        }
        return outputBytes;
    }

    static char[] byteToChars(byte in, char[] out) {
        String hexDigits = "0123456789abcdef";
        out[0] = "0123456789abcdef".charAt((in & 0xF0) / 16);
        out[1] = "0123456789abcdef".charAt(in & 0xF);
        return out;
    }

    static byte stringToByte(String in) throws ParseException {
        String hexDigits = "0123456789abcdef";
        byte out = 0;
        if (in.length() == 1) {
            out = (byte)"0123456789abcdef".indexOf(in.charAt(0));
        } else if (in.length() == 2) {
            out = (byte)(out | (byte)("0123456789abcdef".indexOf(in.charAt(0)) * 16));
            out = (byte)(out | (byte)"0123456789abcdef".indexOf(in.charAt(1)));
        } else {
            throw new ParseException("Encountered a hex string that was not of length 1 or 2", 0);
        }
        return out;
    }

    public boolean isUsingColons() {
        return this.usingColons;
    }

    public void setUsingColons(boolean argUsingColons) {
        this.usingColons = argUsingColons;
    }
}

