/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.html;

import com.darwinsys.html.SimpleTagValidator;
import junit.framework.TestCase;

public class SimpleTagValidatorTest
extends TestCase {
    SimpleTagValidator val = new SimpleTagValidator();

    public void testValidate() {
        System.out.println("Valid tags: '" + this.val.getTagsAsString(false) + "'");
        try {
            this.val.validate(null);
        }
        catch (NullPointerException ex) {
            System.out.println(" caught expected NPE");
        }
        SimpleTagValidatorTest.assertTrue((String)"empty string", (boolean)this.val.validate(""));
        SimpleTagValidatorTest.assertTrue((String)"leading space", (boolean)this.val.validate("< a href='#foo'>Foo</a>"));
        SimpleTagValidatorTest.assertTrue((String)"variety of tags", (boolean)this.val.validate("<p><a href='foo'>Link</a><i></p>?"));
    }

    public void testTagsAsStrings() {
        String[] myTags = new String[]{"br", "i", "img"};
        SimpleTagValidatorTest.assertEquals((String)"tagsAsStrings", (String)"br, i, img", (String)new SimpleTagValidator(myTags).getTagsAsString(true));
        SimpleTagValidatorTest.assertEquals((String)"tagsAsStrings", (String)"br i img", (String)new SimpleTagValidator(myTags).getTagsAsString(false));
    }

    public void testValidateFailures() {
        SimpleTagValidatorTest.assertFalse((String)"imgtag", (boolean)this.val.validate("<img size=0>"));
        SimpleTagValidatorTest.assertEquals((String)"get bad tag info", (String)"img", (String)this.val.getFailedTag());
    }
}

