/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Visitor;

public class DontCatchIllegalMonitorStateException
extends PreorderVisitor
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"dcimse.debug");
    BugReporter bugReporter;
    Set<String> msgs = null;
    ClassContext classContext;

    public DontCatchIllegalMonitorStateException(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            this.msgs = new HashSet<String>();
        }
    }

    public void visit(ExceptionTable obj) {
        if (DEBUG) {
            String[] names;
            String[] arr$ = names = obj.getExceptionNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name = arr$[i$];
                if (!name.equals("java.lang.Exception") && !name.equals("java.lang.Throwable")) continue;
                System.out.println(name + " thrown by " + this.getFullyQualifiedMethodName());
            }
        }
    }

    public void visit(CodeException obj) {
        String msg;
        int type = obj.getCatchType();
        if (type == 0) {
            return;
        }
        String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
        if (DEBUG && this.msgs.add(msg = "Catching " + name + " in " + this.getFullyQualifiedMethodName())) {
            System.out.println(msg);
        }
        if (name.equals("java.lang.IllegalMonitorStateException")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IMSE_DONT_CATCH_IMSE", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine(this.classContext, (PreorderVisitor)this, obj.getHandlerPC()));
        }
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }
}

