/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.generic.ObjectType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObligationFactory {
    private Map<String, Obligation> classNameToObligationMap = new HashMap<String, Obligation>();

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public ObligationFactory() {
    }

    public int getMaxObligationTypes() {
        return this.classNameToObligationMap.size();
    }

    public Iterator<Obligation> obligationIterator() {
        return this.classNameToObligationMap.values().iterator();
    }

    public Obligation getObligationByType(ObjectType type) throws ClassNotFoundException {
        Iterator<Obligation> i = this.obligationIterator();
        while (i.hasNext()) {
            Obligation obligation = i.next();
            if (!Hierarchy.isSubtype(type, obligation.getType())) continue;
            return obligation;
        }
        return null;
    }

    public Obligation addObligation(String className) {
        int nextId = this.classNameToObligationMap.size();
        Obligation obligation = new Obligation(className, nextId);
        if (this.classNameToObligationMap.put(className, obligation) != null) {
            throw new IllegalStateException(new StringBuffer().append("Obligation ").append(className).append(" added multiple times").toString());
        }
        return obligation;
    }

    public Obligation getObligationById(int id) {
        for (Obligation obligation : this.classNameToObligationMap.values()) {
            if (obligation.getId() != id) continue;
            return obligation;
        }
        return null;
    }

    public ObligationSet createObligationSet() {
        return new ObligationSet(this.getMaxObligationTypes(), this);
    }
}

