/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.AbstractToggleLinkingAction;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.TogglePresentationAction;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.StatusBarUpdater;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyElementSorter;
import org.rubypeople.rdt.ui.actions.CustomFiltersActionGroup;
import org.rubypeople.rdt.ui.actions.MemberFilterActionGroup;

public class RubyOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider {
    static Object[] NO_CHILDREN = new Object[0];
    private boolean fTopLevelTypeOnly;
    private IRubyElement fInput;
    private String fContextMenuID;
    private Menu fMenu;
    private RubyOutlineViewer fOutlineViewer;
    private RubyAbstractEditor fEditor;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private ListenerList fPostSelectionChangedListeners = new ListenerList();
    private Hashtable fActions = new Hashtable();
    private TogglePresentationAction fTogglePresentation;
    private ToggleLinkingAction fToggleLinkingAction;
    private IPropertyChangeListener fPropertyChangeListener;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RubyOutlinePage(String string, RubyAbstractEditor rubyAbstractEditor) {
        Assert.isNotNull((Object)((Object)rubyAbstractEditor));
        this.fContextMenuID = string;
        this.fEditor = rubyAbstractEditor;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)rubyAbstractEditor);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RubyOutlinePage.this.doPropertyChange(propertyChangeEvent);
            }
        };
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected IType getMainType(IRubyScript iRubyScript) {
        IType iType;
        if (iRubyScript == null) {
            return null;
        }
        String string = iRubyScript.getElementName();
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return (iType = iRubyScript.getType(string)).exists() ? iType : null;
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
    }

    private void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fOutlineViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(propertyChangeEvent.getProperty())) {
            this.fOutlineViewer.refresh(false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(iSelectionChangedListener);
        } else {
            this.fSelectionChangedListeners.add((Object)iSelectionChangedListener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(iSelectionChangedListener);
        } else {
            this.fSelectionChangedListeners.remove((Object)iSelectionChangedListener);
        }
    }

    public void setSelection(ISelection iSelection) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setSelection(iSelection);
        }
    }

    public ISelection getSelection() {
        if (this.fOutlineViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fOutlineViewer.getSelection();
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addPostSelectionChangedListener(iSelectionChangedListener);
        } else {
            this.fPostSelectionChangedListeners.add((Object)iSelectionChangedListener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removePostSelectionChangedListener(iSelectionChangedListener);
        } else {
            this.fPostSelectionChangedListeners.remove((Object)iSelectionChangedListener);
        }
    }

    private void registerToolbarActions(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        if (iToolBarManager != null) {
            iToolBarManager.add((IAction)new LexicalSortingAction());
            this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, "org.rubypeople.rdt.ui.RubyOutlinePage");
            this.fMemberFilterActionGroup.contributeToToolBar(iToolBarManager);
            this.fCustomFiltersActionGroup.fillActionBars(iActionBars);
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            iMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
            this.fToggleLinkingAction = new ToggleLinkingAction(this);
            iMenuManager.add((IAction)new ClassOnlyAction());
            iMenuManager.add((IAction)this.fToggleLinkingAction);
        }
    }

    public void createControl(Composite composite) {
        Tree tree = new Tree(composite, 2);
        AppearanceAwareLabelProvider appearanceAwareLabelProvider = new AppearanceAwareLabelProvider(0x210000000002L, 1);
        this.fOutlineViewer = new RubyOutlineViewer(tree);
        this.fOutlineViewer.setContentProvider((IContentProvider)new ChildrenProvider());
        this.fOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingRubyLabelProvider(appearanceAwareLabelProvider));
        Object[] objectArray = this.fSelectionChangedListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            this.fSelectionChangedListeners.remove(objectArray[n]);
            this.fOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)objectArray[n]);
            ++n;
        }
        objectArray = this.fPostSelectionChangedListeners.getListeners();
        n = 0;
        while (n < objectArray.length) {
            this.fPostSelectionChangedListeners.remove(objectArray[n]);
            this.fOutlineViewer.addPostSelectionChangedListener((ISelectionChangedListener)objectArray[n]);
            ++n;
        }
        MenuManager menuManager = new MenuManager(this.fContextMenuID, this.fContextMenuID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                RubyOutlinePage.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        this.fMenu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(this.fMenu);
        IPageSite iPageSite = this.getSite();
        iPageSite.registerContextMenu(String.valueOf(RubyPlugin.getPluginId()) + ".outline", menuManager, (ISelectionProvider)this.fOutlineViewer);
        this.updateSelectionProvider(iPageSite);
        IActionBars iActionBars = iPageSite.getActionBars();
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.fEditor.getAction(ITextEditorActionConstants.UNDO));
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.fEditor.getAction(ITextEditorActionConstants.REDO));
        IAction iAction = this.fEditor.getAction("next");
        iActionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", iAction);
        iActionBars.setGlobalActionHandler("next", iAction);
        iAction = this.fEditor.getAction("previous");
        iActionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", iAction);
        iActionBars.setGlobalActionHandler("previous", iAction);
        iActionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
        if (iStatusLineManager != null) {
            StatusBarUpdater statusBarUpdater = new StatusBarUpdater(iStatusLineManager);
            this.fOutlineViewer.addPostSelectionChangedListener(statusBarUpdater);
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.rubypeople.rdt.ui.RubyOutlinePage", (StructuredViewer)this.fOutlineViewer);
        this.registerToolbarActions(iActionBars);
        this.fOutlineViewer.setInput(this.fInput);
    }

    private void updateSelectionProvider(IPageSite iPageSite) {
        IRubyScript iRubyScript;
        Object object = this.fOutlineViewer;
        if (this.fInput != null && (iRubyScript = (IRubyScript)this.fInput.getAncestor(2)) != null && !RubyModelUtil.isPrimary(iRubyScript)) {
            object = new EmptySelectionProvider();
        }
        iPageSite.setSelectionProvider((ISelectionProvider)object);
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        this.fPostSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            RubyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        this.fTogglePresentation.setEditor(null);
        this.fOutlineViewer = null;
        super.dispose();
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    public void setInput(IRubyElement iRubyElement) {
        this.fInput = iRubyElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput(this.fInput);
            this.updateSelectionProvider(this.getSite());
        }
    }

    public void select(ISourceReference iSourceReference) {
        IStructuredSelection iStructuredSelection;
        List list;
        ISelection iSelection;
        if (this.fOutlineViewer != null && (iSelection = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(list = (iStructuredSelection = (IStructuredSelection)iSelection).toList()).contains(iSourceReference)) {
            iSelection = iSourceReference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)iSourceReference);
            this.fOutlineViewer.setSelection(iSelection, true);
        }
    }

    public void setAction(String string, IAction iAction) {
        Assert.isNotNull((Object)string);
        if (iAction == null) {
            this.fActions.remove(string);
        } else {
            this.fActions.put(string, iAction);
        }
    }

    public IAction getAction(String string) {
        Assert.isNotNull((Object)string);
        return (IAction)this.fActions.get(string);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.ViewRubyResources"};
                }
            };
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return this.getShowInTarget();
        }
        return null;
    }

    protected void addAction(IMenuManager iMenuManager, String string, String string2) {
        IAction iAction = this.getAction(string2);
        if (iAction != null) {
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            if (iAction.isEnabled()) {
                IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath(string);
                if (iMenuManager2 != null) {
                    iMenuManager2.add(iAction);
                } else {
                    iMenuManager.appendToGroup(string, iAction);
                }
            }
        }
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        RubyPlugin.createStandardGroups(iMenuManager);
    }

    public void setFocus() {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.getControl().setFocus();
        }
    }

    private boolean isInnerType(IRubyElement iRubyElement) {
        block3: {
            if (iRubyElement != null && iRubyElement.getElementType() == 3) {
                IType iType = (IType)iRubyElement;
                try {
                    return iType.isMember();
                }
                catch (RubyModelException rubyModelException) {
                    IRubyElement iRubyElement2 = iType.getParent();
                    if (iRubyElement2 == null) break block3;
                    int n = iRubyElement2.getElementType();
                    return n != 2;
                }
            }
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, RubyOutlinePage.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext showInContext) {
                ISelection iSelection = showInContext.getSelection();
                if (iSelection instanceof ITextSelection) {
                    ITextSelection iTextSelection = (ITextSelection)iSelection;
                    int n = iTextSelection.getOffset();
                    IRubyElement iRubyElement = RubyOutlinePage.this.fEditor.getElementAt(n);
                    if (iRubyElement != null) {
                        RubyOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)iRubyElement));
                        return true;
                    }
                }
                return false;
            }
        };
    }

    class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            if (RubyOutlinePage.this.getControl() == null) {
                return;
            }
            Display display = RubyOutlinePage.this.getControl().getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(this, elementChangedEvent){
                    final /* synthetic */ ElementChangedListener this$1;
                    private final /* synthetic */ ElementChangedEvent val$e;
                    {
                        this.this$1 = elementChangedListener;
                        this.val$e = elementChangedEvent;
                    }

                    public void run() {
                        IRubyScript iRubyScript;
                        IRubyScript iRubyScript2 = iRubyScript = (IRubyScript)RubyOutlinePage.access$0(ElementChangedListener.access$0(this.this$1));
                        if (RubyOutlinePage.access$1(ElementChangedListener.access$0(this.this$1)) && (iRubyScript2 = ElementChangedListener.access$0(this.this$1).getMainType(iRubyScript)) == null) {
                            if (RubyOutlinePage.access$2(ElementChangedListener.access$0(this.this$1)) != null) {
                                RubyOutlinePage.access$2(ElementChangedListener.access$0(this.this$1)).refresh(true);
                            }
                            return;
                        }
                        IRubyElementDelta iRubyElementDelta = this.this$1.findElement((IRubyElement)iRubyScript2, this.val$e.getDelta());
                        if (iRubyElementDelta != null && RubyOutlinePage.access$2(ElementChangedListener.access$0(this.this$1)) != null) {
                            RubyOutlinePage.access$2(ElementChangedListener.access$0(this.this$1)).reconcile(iRubyElementDelta);
                        }
                    }
                });
            }
        }

        private boolean isPossibleStructuralChange(IRubyElementDelta iRubyElementDelta) {
            if (iRubyElementDelta.getKind() != 4) {
                return true;
            }
            int n = iRubyElementDelta.getFlags();
            if ((n & 8) != 0) {
                return true;
            }
            return (n & 0x4001) == 1;
        }

        protected IRubyElementDelta findElement(IRubyElement iRubyElement, IRubyElementDelta iRubyElementDelta) {
            if (iRubyElementDelta == null || iRubyElement == null) {
                return null;
            }
            IRubyElement iRubyElement2 = iRubyElementDelta.getElement();
            if (iRubyElement.equals(iRubyElement2)) {
                if (this.isPossibleStructuralChange(iRubyElementDelta)) {
                    return iRubyElementDelta;
                }
                return null;
            }
            IRubyElementDelta[] iRubyElementDeltaArray = iRubyElementDelta.getAffectedChildren();
            if (iRubyElementDeltaArray == null || iRubyElementDeltaArray.length == 0) {
                return null;
            }
            int n = 0;
            while (n < iRubyElementDeltaArray.length) {
                IRubyElementDelta iRubyElementDelta2 = this.findElement(iRubyElement, iRubyElementDeltaArray[n]);
                if (iRubyElementDelta2 != null) {
                    return iRubyElementDelta2;
                }
                ++n;
            }
            return null;
        }

        static /* synthetic */ RubyOutlinePage access$0(ElementChangedListener elementChangedListener) {
            return elementChangedListener.RubyOutlinePage.this;
        }
    }

    static class NoClassElement
    extends WorkbenchAdapter
    implements IAdaptable {
        static /* synthetic */ Class class$0;

        NoClassElement() {
        }

        public String toString() {
            return RubyEditorMessages.RubyOutlinePage_error_NoTopLevelType;
        }

        public Object getAdapter(Class clazz) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return this;
            }
            return null;
        }
    }

    class ChildrenProvider
    implements ITreeContentProvider {
        private Object[] NO_CLASS = new Object[]{new NoClassElement()};
        private ElementChangedListener fListener;

        ChildrenProvider() {
        }

        protected boolean matches(IRubyElement iRubyElement) {
            if (iRubyElement.getElementType() == 4) {
                String string = iRubyElement.getElementName();
                return string != null && string.indexOf(60) >= 0;
            }
            return false;
        }

        protected IRubyElement[] filter(IRubyElement[] iRubyElementArray) {
            boolean bl = false;
            int n = 0;
            while (n < iRubyElementArray.length) {
                if (this.matches(iRubyElementArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return iRubyElementArray;
            }
            Vector<IRubyElement> vector = new Vector<IRubyElement>();
            int n2 = 0;
            while (n2 < iRubyElementArray.length) {
                if (!this.matches(iRubyElementArray[n2])) {
                    vector.addElement(iRubyElementArray[n2]);
                }
                ++n2;
            }
            Object[] objectArray = new IRubyElement[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public Object[] getChildren(Object object) {
            block3: {
                if (object instanceof IParent) {
                    IParent iParent = (IParent)object;
                    try {
                        return this.filter(iParent.getChildren());
                    }
                    catch (RubyModelException rubyModelException) {
                        if (!RubyPlugin.isDebug() && rubyModelException.isDoesNotExist()) break block3;
                        RubyPlugin.log(rubyModelException);
                    }
                }
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object object) {
            if (RubyOutlinePage.this.fTopLevelTypeOnly && object instanceof IRubyScript) {
                try {
                    IType iType = RubyOutlinePage.this.getMainType((IRubyScript)object);
                    return iType != null ? iType.getChildren() : this.NO_CLASS;
                }
                catch (RubyModelException rubyModelException) {
                    RubyPlugin.log(rubyModelException);
                }
            }
            return this.getChildren(object);
        }

        public Object getParent(Object object) {
            if (object instanceof IRubyElement) {
                IRubyElement iRubyElement = (IRubyElement)object;
                return iRubyElement.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            block3: {
                if (object instanceof IParent) {
                    IParent iParent = (IParent)object;
                    try {
                        IRubyElement[] iRubyElementArray = this.filter(iParent.getChildren());
                        return iRubyElementArray != null && iRubyElementArray.length > 0;
                    }
                    catch (RubyModelException rubyModelException) {
                        if (!RubyPlugin.isDebug() && rubyModelException.isDoesNotExist()) break block3;
                        RubyPlugin.log(rubyModelException);
                    }
                }
            }
            return false;
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void dispose() {
            if (this.fListener != null) {
                RubyCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            boolean bl = object2 instanceof IRubyScript;
            if (bl && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                RubyCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!bl && this.fListener != null) {
                RubyCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }
    }

    class RubyOutlineViewer
    extends TreeViewer {
        private Item fReusedExpandedItem;
        private boolean fReorderedMembers;
        private boolean fForceFireSelectionChanged;

        public RubyOutlineViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
            this.setUseHashlookup(true);
        }

        public void reconcile(IRubyElementDelta iRubyElementDelta) {
            this.fReorderedMembers = false;
            this.fForceFireSelectionChanged = false;
            if (this.getSorter() == null) {
                if (RubyOutlinePage.this.fTopLevelTypeOnly && iRubyElementDelta.getElement() instanceof IType && (iRubyElementDelta.getKind() & 1) != 0) {
                    this.refresh(true);
                } else {
                    Widget widget = this.findItem(RubyOutlinePage.this.fInput);
                    if (widget != null && !widget.isDisposed()) {
                        this.update(widget, iRubyElementDelta);
                    }
                    if (this.fForceFireSelectionChanged) {
                        this.fireSelectionChanged(new SelectionChangedEvent(RubyOutlinePage.this.getSite().getSelectionProvider(), this.getSelection()));
                    }
                    if (this.fReorderedMembers) {
                        this.refresh(false);
                        this.fReorderedMembers = false;
                    }
                }
            } else {
                this.refresh(true);
            }
        }

        protected void internalExpandToLevel(Widget widget, int n) {
            IRubyElement iRubyElement;
            Item item;
            if (widget instanceof Item && (item = (Item)widget).getData() instanceof IRubyElement && ((iRubyElement = (IRubyElement)item.getData()).getElementType() == 14 || RubyOutlinePage.this.isInnerType(iRubyElement)) && item != this.fReusedExpandedItem) {
                this.setExpanded(item, false);
                return;
            }
            super.internalExpandToLevel(widget, n);
        }

        protected void reuseTreeItem(Item item, Object object) {
            Item[] itemArray = this.getChildren((Widget)item);
            if (itemArray != null && itemArray.length > 0) {
                if (this.getExpanded(item)) {
                    this.fReusedExpandedItem = item;
                }
                int n = 0;
                while (n < itemArray.length) {
                    if (itemArray[n].getData() != null) {
                        this.disassociate(itemArray[n]);
                    }
                    itemArray[n].dispose();
                    ++n;
                }
            }
            this.updateItem((Widget)item, object);
            this.updatePlus(item, object);
            this.internalExpandToLevel((Widget)item, -1);
            this.fReusedExpandedItem = null;
            this.fForceFireSelectionChanged = true;
        }

        protected boolean mustUpdateParent(IRubyElementDelta iRubyElementDelta, IRubyElement iRubyElement) {
            return false;
        }

        public boolean isExpandable(Object object) {
            if (this.hasFilters()) {
                return this.getFilteredChildren(object).length > 0;
            }
            return super.isExpandable(object);
        }

        protected ISourceRange getSourceRange(IRubyElement iRubyElement) throws RubyModelException {
            if (iRubyElement instanceof ISourceReference) {
                return ((ISourceReference)iRubyElement).getSourceRange();
            }
            if (iRubyElement instanceof IMember) {
                return ((IMember)iRubyElement).getNameRange();
            }
            return null;
        }

        protected boolean overlaps(ISourceRange iSourceRange, int n, int n2) {
            return n <= iSourceRange.getOffset() + iSourceRange.getLength() - 1 && iSourceRange.getOffset() <= n2;
        }

        protected boolean filtered(IRubyElement iRubyElement, IRubyElement iRubyElement2) {
            Object[] objectArray = new Object[]{iRubyElement2};
            ViewerFilter[] viewerFilterArray = this.getFilters();
            int n = 0;
            while (n < viewerFilterArray.length) {
                if ((objectArray = viewerFilterArray[n].filter((Viewer)this, (Object)iRubyElement, objectArray)).length == 0) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        protected void update(Widget widget, IRubyElementDelta iRubyElementDelta) {
            int n;
            Item item;
            int n2;
            IRubyElement iRubyElement;
            IRubyElementDelta[] iRubyElementDeltaArray;
            IRubyElement iRubyElement2 = iRubyElementDelta.getElement();
            IRubyElementDelta[] iRubyElementDeltaArray2 = iRubyElementDelta.getAffectedChildren();
            Item[] itemArray = this.getChildren(widget);
            boolean bl = false;
            boolean bl2 = false;
            Vector<Item> vector = new Vector<Item>();
            Vector<IRubyElementDelta[]> vector2 = new Vector<IRubyElementDelta[]>();
            int n3 = 0;
            while (n3 < iRubyElementDeltaArray2.length) {
                iRubyElementDeltaArray = iRubyElementDeltaArray2[n3];
                iRubyElement = iRubyElementDeltaArray.getElement();
                int n4 = iRubyElementDeltaArray2[n3].getKind();
                n2 = 0;
                while (n2 < itemArray.length) {
                    if (iRubyElement.equals(itemArray[n2].getData())) break;
                    ++n2;
                }
                if (n2 == itemArray.length) {
                    if ((n4 & 2) != 0) {
                        bl2 = true;
                    } else if ((n4 & 4) != 0 && (iRubyElementDeltaArray.getFlags() & 2) != 0 && !this.filtered(iRubyElement2, iRubyElement)) {
                        vector2.addElement(iRubyElementDeltaArray);
                    }
                } else {
                    item = itemArray[n2];
                    if ((n4 & 2) != 0) {
                        vector.addElement(item);
                        bl = bl || this.mustUpdateParent((IRubyElementDelta)iRubyElementDeltaArray, iRubyElement);
                    } else if ((n4 & 4) != 0) {
                        n = iRubyElementDeltaArray.getFlags();
                        boolean bl3 = bl = bl || this.mustUpdateParent((IRubyElementDelta)iRubyElementDeltaArray, iRubyElement);
                        if ((n & 2) != 0) {
                            if (this.filtered(iRubyElement2, iRubyElement)) {
                                vector.addElement(item);
                            } else {
                                this.updateItem((Widget)item, iRubyElement);
                            }
                        }
                        if ((n & 1) != 0) {
                            this.updateItem((Widget)item, iRubyElement);
                        }
                        if ((n & 8) != 0) {
                            this.update((Widget)item, (IRubyElementDelta)iRubyElementDeltaArray);
                        }
                        if ((n & 0x100) != 0) {
                            this.fReorderedMembers = true;
                        }
                    }
                }
                ++n3;
            }
            IRubyElementDelta[] iRubyElementDeltaArray3 = iRubyElementDelta.getAddedChildren();
            if (vector2.size() > 0) {
                iRubyElementDeltaArray = new IRubyElementDelta[iRubyElementDeltaArray3.length + vector2.size()];
                System.arraycopy(iRubyElementDeltaArray3, 0, iRubyElementDeltaArray, 0, iRubyElementDeltaArray3.length);
                int n5 = 0;
                while (n5 < vector2.size()) {
                    iRubyElementDeltaArray[n5 + iRubyElementDeltaArray3.length] = (IRubyElementDelta)vector2.elementAt(n5);
                    ++n5;
                }
                iRubyElementDeltaArray3 = iRubyElementDeltaArray;
            }
            int n6 = 0;
            while (n6 < iRubyElementDeltaArray3.length) {
                block34: {
                    try {
                        ISourceRange iSourceRange;
                        iRubyElement = iRubyElementDeltaArray3[n6].getElement();
                        if (this.filtered(iRubyElement2, iRubyElement)) break block34;
                        bl = bl || this.mustUpdateParent(iRubyElementDeltaArray3[n6], iRubyElement);
                        ISourceRange iSourceRange2 = this.getSourceRange(iRubyElement);
                        n2 = iSourceRange2.getOffset();
                        n = n2 + iSourceRange2.getLength() - 1;
                        int n7 = Integer.MAX_VALUE;
                        if (iRubyElement instanceof IField && (iSourceRange = ((IField)iRubyElement).getNameRange()) != null) {
                            n7 = iSourceRange.getOffset();
                        }
                        iSourceRange = null;
                        item = null;
                        itemArray = this.getChildren(widget);
                        int n8 = 0;
                        while (n8 < itemArray.length) {
                            block35: {
                                item = itemArray[n8];
                                IRubyElement iRubyElement3 = (IRubyElement)item.getData();
                                if (iRubyElement3 == null) break block34;
                                try {
                                    ISourceRange iSourceRange3;
                                    iSourceRange2 = this.getSourceRange(iRubyElement3);
                                    boolean bl4 = iRubyElement3.getElementType() == 13 && iRubyElement.getElementType() == 13 && iSourceRange2.getOffset() == n2;
                                    boolean bl5 = false;
                                    if (bl4 && iRubyElement3 instanceof IField && (iSourceRange3 = ((IField)iRubyElement3).getNameRange()) != null && iSourceRange3.getOffset() > n7) {
                                        bl5 = true;
                                    }
                                    if (!bl4 && this.overlaps(iSourceRange2, n2, n)) {
                                        this.reuseTreeItem(item, iRubyElement);
                                        break block34;
                                    }
                                    if (!bl5 && iSourceRange2.getOffset() <= n2) break block35;
                                    if (iSourceRange != null && vector.contains(iSourceRange)) {
                                        vector.removeElement(iSourceRange);
                                        this.reuseTreeItem((Item)iSourceRange, iRubyElement);
                                    } else {
                                        this.createTreeItem(widget, iRubyElement, n8);
                                    }
                                    break block34;
                                }
                                catch (RubyModelException rubyModelException) {}
                            }
                            iSourceRange = item;
                            ++n8;
                        }
                        if (iSourceRange != null && vector.contains(iSourceRange)) {
                            vector.removeElement(iSourceRange);
                            this.reuseTreeItem((Item)iSourceRange, iRubyElement);
                        } else {
                            this.createTreeItem(widget, iRubyElement, -1);
                        }
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                ++n6;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                item = (Item)enumeration.nextElement();
                this.disassociate(item);
                item.dispose();
            }
            if (bl) {
                this.updateItem(widget, iRubyElementDelta.getElement());
            }
            if (!bl && bl2 && widget instanceof Item) {
                this.updatePlus((Item)widget, iRubyElementDelta.getElement());
            }
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            IResource iResource;
            this.getInput();
            Object[] objectArray = labelProviderChangedEvent.getElements();
            if (objectArray != null && (iResource = this.getUnderlyingResource()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null && objectArray[n].equals(iResource)) {
                        labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)labelProviderChangedEvent.getSource());
                        break;
                    }
                    ++n;
                }
            }
            super.handleLabelProviderChanged(labelProviderChangedEvent);
        }

        private IResource getUnderlyingResource() {
            Object object = this.getInput();
            if (object instanceof IRubyScript) {
                IRubyScript iRubyScript = (IRubyScript)object;
                iRubyScript = RubyModelUtil.toOriginal(iRubyScript);
                return iRubyScript.getResource();
            }
            return null;
        }
    }

    class LexicalSortingAction
    extends Action {
        private RubyElementSorter fSorter = new RubyElementSorter();

        public LexicalSortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.lexical_sorting_outline_action");
            this.setText(RubyEditorMessages.RubyOutlinePage_Sort_label);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.setToolTipText(RubyEditorMessages.RubyOutlinePage_Sort_tooltip);
            this.setDescription(RubyEditorMessages.RubyOutlinePage_Sort_description);
            boolean bl = RubyPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(bl, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            this.setChecked(bl);
            BusyIndicator.showWhile((Display)RubyOutlinePage.this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(this, bl){
                final /* synthetic */ LexicalSortingAction this$1;
                private final /* synthetic */ boolean val$on;
                {
                    this.this$1 = lexicalSortingAction;
                    this.val$on = bl;
                }

                public void run() {
                    RubyOutlinePage.access$2(LexicalSortingAction.access$1(this.this$1)).setSorter(this.val$on ? LexicalSortingAction.access$0(this.this$1) : null);
                }
            });
            if (bl2) {
                RubyPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", bl);
            }
        }

        static /* synthetic */ RubyElementSorter access$0(LexicalSortingAction lexicalSortingAction) {
            return lexicalSortingAction.fSorter;
        }

        static /* synthetic */ RubyOutlinePage access$1(LexicalSortingAction lexicalSortingAction) {
            return lexicalSortingAction.RubyOutlinePage.this;
        }
    }

    class ClassOnlyAction
    extends Action {
        public ClassOnlyAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.go_into_top_level_type_action");
            this.setText(RubyEditorMessages.RubyOutlinePage_GoIntoTopLevelType_label);
            this.setToolTipText(RubyEditorMessages.RubyOutlinePage_GoIntoTopLevelType_tooltip);
            this.setDescription(RubyEditorMessages.RubyOutlinePage_GoIntoTopLevelType_description);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "gointo_toplevel_type.gif");
            IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
            boolean bl = iPreferenceStore.getBoolean("GoIntoTopLevelTypeAction.isChecked");
            this.setTopLevelTypeOnly(bl);
        }

        public void run() {
            this.setTopLevelTypeOnly(!RubyOutlinePage.this.fTopLevelTypeOnly);
        }

        private void setTopLevelTypeOnly(boolean bl) {
            RubyOutlinePage.this.fTopLevelTypeOnly = bl;
            this.setChecked(bl);
            RubyOutlinePage.this.fOutlineViewer.refresh(false);
            IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.setValue("GoIntoTopLevelTypeAction.isChecked", bl);
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        RubyOutlinePage fRubyOutlinePage;

        public ToggleLinkingAction(RubyOutlinePage rubyOutlinePage2) {
            boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("RubyEditor.SyncOutlineOnCursorMove");
            this.setChecked(bl);
            this.fRubyOutlinePage = rubyOutlinePage2;
        }

        public void run() {
            PreferenceConstants.getPreferenceStore().setValue("RubyEditor.SyncOutlineOnCursorMove", this.isChecked());
            if (this.isChecked() && RubyOutlinePage.this.fEditor != null) {
                RubyOutlinePage.this.fEditor.synchronizeOutlinePage(RubyOutlinePage.this.fEditor.computeHighlightRangeSourceReference(), false);
            }
        }
    }

    private static final class EmptySelectionProvider
    implements ISelectionProvider {
        EmptySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        }

        public void setSelection(ISelection iSelection) {
        }
    }
}

