/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.SimpleRubySourceViewerConfiguration;

public class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
DisposeListener {
    private static final int BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;

    public SourceViewerInformationControl(Shell shell, int n, int n2) {
        this(shell, n, n2, null);
    }

    public SourceViewerInformationControl(Shell shell, int n, int n2, String string) {
        int n3;
        this.fShell = new Shell(shell, 0x84000 | n);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        Shell shell2 = this.fShell;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = n3 = (n & 8) == 0 ? 0 : 1;
        gridLayout.marginWidth = n3;
        shell2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        shell2.setLayoutData((Object)gridData);
        if (string != null) {
            shell2 = new Composite((Composite)shell2, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            shell2.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            shell2.setLayoutData((Object)gridData);
            shell2.setForeground(display.getSystemColor(28));
            shell2.setBackground(display.getSystemColor(29));
        }
        IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getCombinedPreferenceStore();
        this.fViewer = new RubySourceViewer((Composite)shell2, null, null, false, n2, iPreferenceStore);
        this.fViewer.configure((SourceViewerConfiguration)new SimpleRubySourceViewerConfiguration(RubyPlugin.getDefault().getRubyTextTools().getColorManager(), iPreferenceStore, null, null, false));
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gridData = new GridData(1809);
        this.fText.setLayoutData((Object)gridData);
        this.fText.setForeground(shell.getDisplay().getSystemColor(28));
        this.fText.setBackground(shell.getDisplay().getSystemColor(29));
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        if (string != null) {
            this.fSeparator = new Label((Composite)shell2, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)shell2, 131072);
            this.fStatusField.setText(string);
            Font font = this.fStatusField.getFont();
            FontData[] fontDataArray = font.getFontData();
            int n4 = 0;
            while (n4 < fontDataArray.length) {
                fontDataArray[n4].setHeight(fontDataArray[n4].getHeight() * 9 / 10);
                ++n4;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDataArray);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gridData2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gridData2);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
    }

    public SourceViewerInformationControl(Shell shell, int n) {
        this(shell, 12, n);
    }

    public SourceViewerInformationControl(Shell shell, int n, String string) {
        this(shell, 12, n, string);
    }

    public SourceViewerInformationControl(Shell shell) {
        this(shell, 0);
    }

    public SourceViewerInformationControl(Shell shell, String string) {
        this(shell, 0, string);
    }

    public void setInput(Object object) {
        if (object instanceof String) {
            this.setInformation((String)object);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String string) {
        if (string == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document document = new Document(string);
        RubyPlugin.getDefault().getRubyTextTools().setupRubyDocumentPartitioner((IDocument)document);
        this.fViewer.setInput((Object)document);
    }

    public void setVisible(boolean bl) {
        this.fShell.setVisible(bl);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void setSize(int n, int n2) {
        if (this.fStatusField != null) {
            GridData gridData = (GridData)this.fViewer.getTextWidget().getLayoutData();
            Point point = this.fStatusField.computeSize(-1, -1, true);
            Point point2 = this.fSeparator.computeSize(-1, -1, true);
            gridData.heightHint = n2 - point.y - point2.y;
        }
        this.fShell.setSize(n, n2);
        if (this.fStatusField != null) {
            this.fShell.pack(true);
        }
    }

    public void setLocation(Point point) {
        Rectangle rectangle = this.fShell.computeTrim(0, 0, 0, 0);
        Point point2 = this.fText.getLocation();
        point.x += rectangle.x - point2.x;
        point.y += rectangle.y - point2.y;
        this.fShell.setLocation(point);
    }

    public void setSizeConstraints(int n, int n2) {
        n = n2;
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.fText.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.fText.setBackground(color);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fText.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fText.removeFocusListener(focusListener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }
}

