/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.dialogfields;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;

public class StringDialogField
extends DialogField {
    private String fText = "";
    private Text fTextControl;
    private ModifyListener fModifyListener;

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringDialogField.gridDataForText(n - 1));
        return new Control[]{label, text};
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForText(int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(Composite composite) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(composite);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    StringDialogField.this.doModifyText(modifyEvent);
                }
            };
            this.fTextControl = new Text(composite, 2052);
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(composite.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
        }
        return this.fTextControl;
    }

    private void doModifyText(ModifyEvent modifyEvent) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(string);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(string);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }
}

