/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class RuntimeTypeTreeContentProvider
extends AbstractTreeContentProvider {
    public static final byte STYLE_VENDOR = 1;
    public static final byte STYLE_VERSION = 2;
    public static final byte STYLE_MODULE_TYPE = 3;
    protected boolean creation;
    protected String type;
    protected String version;
    protected String runtimeTypeId;

    public RuntimeTypeTreeContentProvider(byte style, boolean creation) {
        super(style);
        this.creation = creation;
    }

    public RuntimeTypeTreeContentProvider(byte style, boolean creation, String type, String version, String runtimeTypeId) {
        super(style, false);
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.creation = creation;
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        if (this.style != 0) {
            IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes((String)this.type, (String)this.version, (String)this.runtimeTypeId);
            if (runtimeTypes != null) {
                int size = runtimeTypes.length;
                int i = 0;
                while (i < size) {
                    IRuntimeType runtimeType = runtimeTypes[i];
                    if (!this.creation || runtimeType.canCreate()) {
                        IModuleType[] moduleTypes;
                        AbstractTreeContentProvider.TreeElement ele = null;
                        if (this.style == 1) {
                            ele = this.getOrCreate(list, runtimeType.getVendor());
                            ele.contents.add(runtimeType);
                            this.elementToParentMap.put(runtimeType, ele);
                        } else if (this.style == 2) {
                            ele = this.getOrCreate(list, runtimeType.getVersion());
                            ele.contents.add(runtimeType);
                            this.elementToParentMap.put(runtimeType, ele);
                        } else if (this.style == 3 && (moduleTypes = runtimeType.getModuleTypes()) != null) {
                            int size2 = moduleTypes.length;
                            int j = 0;
                            while (j < size2) {
                                IModuleType mb = moduleTypes[j];
                                if (mb != null) {
                                    ele = this.getOrCreate(list, mb.getName());
                                    AbstractTreeContentProvider.TreeElement ele2 = this.getOrCreate(ele.contents, String.valueOf(mb.getName()) + "/" + mb.getVersion(), mb.getVersion());
                                    ele2.contents.add(runtimeType);
                                    this.elementToParentMap.put(runtimeType, ele2);
                                    this.elementToParentMap.put(ele2, ele);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        } else {
            IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes((String)this.type, (String)this.version, (String)this.runtimeTypeId);
            if (runtimeTypes != null) {
                int size = runtimeTypes.length;
                int i = 0;
                while (i < size) {
                    IRuntimeType runtimeType = runtimeTypes[i];
                    if (!this.creation || runtimeType.canCreate()) {
                        list.add(runtimeType);
                    }
                    ++i;
                }
            }
        }
        this.elements = list.toArray();
    }
}

