/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroupType;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerDescriptionHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AbstractHandlersWidgetDefaultingCmd;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class ServiceHandlersWidgetDefaultingCommand
extends AbstractHandlersWidgetDefaultingCmd {
    private WsddResource[] wsddResource_ = null;
    private IProject project_;
    private String descriptionName_ = null;
    private String errorStatusMsg_ = null;
    private boolean isMultipleSelection_;
    private HandlerDescriptionHolder[] handlerDescriptionHolder_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        IStructuredSelection selection = this.getInitialSelection();
        if (selection == null) {
            status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED);
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (selection.size() > 1) {
            status = this.processMultipleHandlers(env);
            return status;
        }
        status = this.processHandlers(env);
        return status;
    }

    public IStatus processHandlers(IEnvironment env) {
        try {
            WebServicesManager webServicesManager = new WebServicesManager();
            List allWSDLServices = webServicesManager.getAllWSDLServices();
            int servicesSize = allWSDLServices.size();
            this.wsddResource_ = new WsddResource[servicesSize];
            this.wsddResource_[0] = this.getWsddResourceFromSelection();
            if (this.wsddResource_[0] == null) {
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_WSDD_NOT_FOUND);
            }
            int x = 0;
            while (x < servicesSize) {
                Service service = (Service)allWSDLServices.get(x);
                WsddResource wsddRes = webServicesManager.getWsddResource((EObject)service);
                boolean isUniqueWsdd = true;
                int w = 0;
                while (w < this.wsddResource_.length) {
                    if (wsddRes.equals(this.wsddResource_[w])) {
                        isUniqueWsdd = false;
                        break;
                    }
                    ++w;
                }
                if (isUniqueWsdd) {
                    this.wsddResource_[x] = wsddRes;
                }
                ++x;
            }
            this.handlerDescriptionHolder_ = new HandlerDescriptionHolder[this.getNumberofServices(this.wsddResource_)];
            int descCounter = 0;
            int y = 0;
            while (y < this.wsddResource_.length) {
                WebServices webServices;
                if (this.wsddResource_[y] != null && (webServices = this.wsddResource_[y].getWebServices()) != null) {
                    EList wsDescriptions = webServices.getWebServiceDescriptions();
                    int i = 0;
                    while (i < wsDescriptions.size()) {
                        WebServiceDescription wsDescription = (WebServiceDescription)wsDescriptions.get(i);
                        Vector<HandlerTableItem> handlers = new Vector<HandlerTableItem>();
                        EList wsPortComponents = wsDescription.getPortComponents();
                        int j = 0;
                        while (j < wsPortComponents.size()) {
                            PortComponent wsPort = (PortComponent)wsPortComponents.get(j);
                            String portName = wsPort.getPortComponentName();
                            EList wsHandlers = wsPort.getHandlers();
                            int k = 0;
                            while (k < wsHandlers.size()) {
                                Handler wsHandler = (Handler)wsHandlers.get(k);
                                HandlerTableItem handlerItem = new HandlerTableItem();
                                handlerItem.setHandler(wsHandler);
                                handlerItem.setHandlerName(wsHandler.getHandlerName());
                                handlerItem.setHandlerClassName(wsHandler.getHandlerClass());
                                handlerItem.setPort(wsPort);
                                handlerItem.setPortName(portName);
                                handlerItem.setWsDescRef(wsDescription);
                                handlers.add(handlerItem);
                                ++k;
                            }
                            ++j;
                        }
                        String wsDescName = wsDescription.getWebServiceDescriptionName();
                        this.handlerDescriptionHolder_[descCounter] = new HandlerDescriptionHolder();
                        this.handlerDescriptionHolder_[descCounter].setHandlerList(handlers);
                        this.handlerDescriptionHolder_[descCounter].setDescriptionObject(wsDescription);
                        this.handlerDescriptionHolder_[descCounter].setDescriptionName(wsDescName);
                        ++descCounter;
                        ++i;
                    }
                }
                ++y;
            }
            if (this.handlerDescriptionHolder_ == null) {
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_WEB_SERVICES_NOT_FOUND);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private IStatus processMultipleHandlers(IEnvironment env) {
        Service[] services = this.getSelectedServices();
        if (this.errorStatusMsg_ != null) {
            return StatusUtils.errorStatus((String)this.errorStatusMsg_);
        }
        this.isMultipleSelection_ = true;
        this.handlerDescriptionHolder_ = new HandlerDescriptionHolder[services.length];
        Vector handlers = new Vector();
        int i = 0;
        while (i < services.length) {
            String descName = services[i].getQName().getLocalPart();
            WebServiceDescription wsDescription = this.getServiceDescription(services[i], descName);
            this.handlerDescriptionHolder_[i] = new HandlerDescriptionHolder();
            this.handlerDescriptionHolder_[i].setHandlerList(handlers);
            this.handlerDescriptionHolder_[i].setDescriptionName(descName);
            this.handlerDescriptionHolder_[i].setDescriptionObject(wsDescription);
            ++i;
        }
        return Status.OK_STATUS;
    }

    private WebServiceDescription getServiceDescription(Service service, String serviceName) {
        WebServices services;
        WebServicesManager webServicesManager = new WebServicesManager();
        WsddResource wsddResource = webServicesManager.getWsddResource((EObject)service);
        if (wsddResource != null && (services = wsddResource.getWebServices()) != null) {
            EList descriptions = services.getWebServiceDescriptions();
            int i = 0;
            while (i < descriptions.size()) {
                WebServiceDescription wsd = (WebServiceDescription)descriptions.get(i);
                if (wsd != null && wsd.getWebServiceDescriptionName().equals(serviceName)) {
                    return wsd;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean getIsMultipleSelection() {
        return this.isMultipleSelection_;
    }

    public boolean getGenSkeletonEnabled() {
        return !this.isMultipleSelection_;
    }

    public IPath[] getSourceOutputLocation() {
        IPath[] locations = null;
        IProject project = this.getProject();
        if (project != null) {
            locations = ResourceUtils.getAllJavaSourceLocations((IProject)project);
        } else {
            project = this.project_;
            if (project != null) {
                locations = ResourceUtils.getAllJavaSourceLocations((IProject)project);
            }
        }
        return locations;
    }

    public WsddResource[] getWsddResource() {
        return this.wsddResource_;
    }

    private WsddResource getWsddResourceFromSelection() {
        WebServicesManager webServicesManager = new WebServicesManager();
        IStructuredSelection initSel = this.getInitialSelection();
        if (initSel != null && initSel.size() == 1) {
            Object obj = initSel.getFirstElement();
            if (obj instanceof ServiceImpl) {
                Service service = (Service)obj;
                this.descriptionName_ = service.getQName().getLocalPart();
                this.project_ = ProjectUtilities.getProject((EObject)service);
                return webServicesManager.getWsddResource((EObject)service);
            }
            if (obj instanceof WSDLResourceImpl) {
                WSDLResourceImpl res = (WSDLResourceImpl)obj;
                this.project_ = ProjectUtilities.getProject((Resource)res);
                List wsdlResources = webServicesManager.getWSDLServices((Resource)res);
                return webServicesManager.getWsddResource((EObject)((Service)wsdlResources.get(0)));
            }
            if (obj instanceof WebServiceNavigatorGroupType) {
                WebServiceNavigatorGroupType wsngt = (WebServiceNavigatorGroupType)obj;
                Service service = (Service)wsngt.getWsdlService();
                this.descriptionName_ = service.getQName().getLocalPart();
                this.project_ = ProjectUtilities.getProject((EObject)service);
                return webServicesManager.getWsddResource((EObject)service);
            }
            if (obj instanceof IFile) {
                EList wsDescriptions;
                Resource res = WorkbenchResourceHelperBase.getResource((IFile)((IFile)obj), (boolean)true);
                WsddResource wsddRes = (WsddResource)res;
                WebServices webServices = wsddRes.getWebServices();
                if (webServices != null && (wsDescriptions = webServices.getWebServiceDescriptions()) != null) {
                    WebServiceDescription wsd = (WebServiceDescription)wsDescriptions.get(0);
                    this.descriptionName_ = wsd.getWebServiceDescriptionName();
                }
                this.project_ = ProjectUtilities.getProject((Resource)res);
                return wsddRes;
            }
        }
        return null;
    }

    private int getNumberofServices(WsddResource[] wsddRes) {
        int num = 0;
        int i = 0;
        while (i < wsddRes.length) {
            WebServices ws;
            if (wsddRes[i] != null && (ws = wsddRes[i].getWebServices()) != null) {
                num += ws.getWebServiceDescriptions().size();
            }
            ++i;
        }
        return num;
    }

    private Service[] getSelectedServices() {
        WebServicesManager wsManager = new WebServicesManager();
        IStructuredSelection initSel = this.getInitialSelection();
        Service[] services = new Service[initSel.size()];
        this.wsddResource_ = new WsddResource[initSel.size()];
        Iterator iter = initSel.iterator();
        int i = 0;
        while (i < initSel.size()) {
            Object obj = iter.next();
            if (!(obj instanceof Service)) {
                this.errorStatusMsg_ = ConsumptionUIMessages.MSG_ERROR_INVALID_MULTIPLE_SERVICE_SELECT;
                return null;
            }
            services[i] = (Service)obj;
            this.wsddResource_[i] = wsManager.getWsddResource((EObject)services[i]);
            ++i;
        }
        return services;
    }

    public String getDescriptionName() {
        return this.descriptionName_;
    }

    public HandlerDescriptionHolder[] getHandlerDescriptionHolders() {
        return this.handlerDescriptionHolder_;
    }
}

