/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.commandline;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.wst.command.internal.env.common.StringUtils;

public class CommandLine {
    public static final String REQUIRED = "required";
    public static final String OPTIONAL = "optional";
    public static final String DUPS_OK = "dups_ok";
    public static final String NO_DUPS = "no_dups";
    public static final String POSITIONAL = "";
    public static final String NO_PARM = "";
    private static final int FLAG_COL = 0;
    private static final int NAME_COL = 1;
    private static final int DUP_COL = 2;
    private static final int REQUIRED_COL = 3;
    private static final int HELP_COL = 4;
    private static final int POSITIONAL_ROW = 0;
    private static final int HELP_LINE_LEN = 75;
    private String[][] flags_info;
    private String help_flag;
    private String tool_name;
    private Vector[] flags_specified;
    private int required_positionals;
    private boolean optional_positionals_allowed;
    private int optional_list_index;
    private int max_flag_size;
    private int max_name_size;
    protected ResourceBundle messages;
    private ResourceBundle flagMessages;

    public CommandLine(String[][] flags_info, String help_flag, String tool_name, ResourceBundle flagMessages) throws InternalErrorExc {
        this.flags_info = flags_info;
        this.help_flag = help_flag;
        this.tool_name = tool_name;
        this.flagMessages = flagMessages;
        this.messages = ResourceBundle.getBundle("org.eclipse.wst.command.internal.env.commandline.commandline");
        this.verify_flags_info();
    }

    public void check_flags(String[] args) throws Flag_error {
        this.flags_specified = new Vector[this.flags_info.length];
        int index = 0;
        while (index < args.length) {
            boolean processed_the_next_arg = this.process_arg(args, index);
            if (processed_the_next_arg) {
                ++index;
            }
            ++index;
        }
        if (!this.flag_specified(this.help_flag)) {
            this.check_rules();
            this.more_processing();
        }
    }

    protected void more_processing() throws Flag_error, InternalErrorExc {
    }

    public String[] get_flag_parms(String flag) {
        int row = 0;
        boolean flag_found = false;
        while (!flag_found && row < this.flags_info.length) {
            if (this.flags_info[row][0].equals(flag)) {
                flag_found = true;
                continue;
            }
            ++row;
        }
        if (flag_found) {
            Vector parms = this.flags_specified[row];
            return parms == null ? null : parms.toArray(new String[0]);
        }
        return null;
    }

    public String[] get_positionals() {
        return this.flags_specified[0].toArray(new String[0]);
    }

    public boolean flag_specified(String flag) {
        return this.get_flag_parms(flag) != null;
    }

    public String get_help_text() {
        StringBuffer help_text = new StringBuffer(400);
        int help_width = 72 - this.max_flag_size - 1 - this.max_name_size - 1;
        help_text.append(String.valueOf(this.messages.getString("PARSER_SYNTAX")) + ": " + this.tool_name + " ");
        int index = 0;
        while (index < this.required_positionals) {
            help_text.append(String.valueOf(this.flagMessages.getString(this.flags_info[index][1])) + " ");
            ++index;
        }
        help_text.append("[" + this.messages.getString("PARSER_FLAGS") + "] ");
        if (this.optional_positionals_allowed) {
            help_text.append(this.flagMessages.getString(this.flags_info[this.optional_list_index][1]));
        }
        help_text.append("\n  " + this.messages.getString("PARSER_WHERE") + "\n");
        int row = 0;
        while (row < this.flags_info.length) {
            String columnId = this.flags_info[row][1];
            String columnName = columnId == "" ? "" : this.flagMessages.getString(columnId);
            String flagId = this.flags_info[row][0];
            String flagName = flagId == "" ? "" : this.flagMessages.getString(flagId);
            int flag_padding = this.max_flag_size - flagName.length();
            int name_padding = this.max_name_size - columnName.length();
            if (this.flags_info[row][0] != "" || this.flags_info[row][1] != "") {
                if (flagName == "") {
                    help_text.append(this.getBlanks(3));
                } else {
                    help_text.append("  -" + flagName);
                }
                help_text.append(this.getBlanks(flag_padding + 1));
                help_text.append(columnName);
                help_text.append(this.getBlanks(name_padding + 1));
                String columnHelp = this.flagMessages.getString(this.flags_info[row][4]);
                String[] split_help_text = StringUtils.splitter(columnHelp, help_width);
                if (split_help_text.length > 0) {
                    help_text.append(String.valueOf(split_help_text[0]) + "\n");
                } else {
                    help_text.append("\n");
                }
                int index2 = 1;
                while (index2 < split_help_text.length) {
                    help_text.append(this.getBlanks(75 - help_width));
                    help_text.append(String.valueOf(split_help_text[index2]) + "\n");
                    ++index2;
                }
                help_text.append("\n");
            }
            ++row;
        }
        return "" + help_text;
    }

    private String getBlanks(int count) {
        char[] blanks = new char[count];
        Arrays.fill(blanks, 0, count, ' ');
        return new String(blanks);
    }

    private boolean process_arg(String[] args, int arg_index) throws Flag_error {
        boolean processed_next_arg = false;
        if (args[arg_index].charAt(0) == '-') {
            int flag_index = 1;
            int info_index = this.get_info_index(args[arg_index], flag_index);
            int max_index = this.get_max_index(args[arg_index], flag_index, info_index);
            if (this.flags_info[info_index][1] != "") {
                if (max_index < args[arg_index].length()) {
                    this.add_flag_parm(info_index, args[arg_index].substring(max_index, args[arg_index].length()));
                } else if (arg_index + 1 < args.length && args[arg_index + 1].charAt(0) != '-') {
                    this.add_flag_parm(info_index, args[arg_index + 1]);
                    processed_next_arg = true;
                } else {
                    this.add_flag_parm(info_index, null);
                }
            } else {
                this.add_flag_parm(info_index, null);
                if (max_index < args[arg_index].length()) {
                    this.add_positional(args[arg_index].substring(max_index, args[arg_index].length()));
                }
            }
        } else {
            this.add_positional(args[arg_index]);
        }
        return processed_next_arg;
    }

    private int get_info_index(String flag_str, int start_index) throws Flag_error {
        int found_count = 0;
        int info_col_index = 0;
        int last_info_index = 0;
        BitSet flags_rejected = new BitSet();
        int flag_col_index = start_index;
        while (flag_col_index < flag_str.length()) {
            int info_index = 0;
            while (info_index < this.flags_info.length) {
                String flagName;
                String flagId = this.flags_info[info_index][0];
                String string = flagName = flagId == "" ? "" : this.flagMessages.getString(flagId);
                if (!flags_rejected.get(info_index) && info_col_index < flagName.length() && Character.toLowerCase(flag_str.charAt(flag_col_index)) == flagName.charAt(info_col_index)) {
                    ++found_count;
                    last_info_index = info_index;
                } else {
                    flags_rejected.set(info_index);
                }
                ++info_index;
            }
            if (found_count == 1) {
                return last_info_index;
            }
            if (found_count == 0) {
                throw new Flag_error(this.messages.getString("PARSER_ERROR_FLAG_NOT_FOUND"), flag_str.substring(start_index));
            }
            ++info_col_index;
            found_count = 0;
            ++flag_col_index;
        }
        throw new Flag_error(this.messages.getString("PARSER_ERROR_AMBIGUOUS_FLAG"), flag_str.substring(start_index));
    }

    private int get_max_index(String flag_str, int flag_start, int info_index) {
        int flag_col_index = flag_start;
        int info_col_index = 0;
        String info_str = this.flagMessages.getString(this.flags_info[info_index][0]);
        while (flag_col_index < flag_str.length() && info_col_index < info_str.length()) {
            if (Character.toLowerCase(flag_str.charAt(flag_col_index)) != info_str.charAt(info_col_index)) break;
            ++flag_col_index;
            ++info_col_index;
        }
        return flag_col_index;
    }

    private void add_positional(String positional_parm) {
        if (this.flags_specified[0] == null) {
            this.flags_specified[0] = new Vector(3);
        }
        this.flags_specified[0].add(positional_parm);
    }

    private void add_flag_parm(int flag_index, String flag_parm) throws Flag_error {
        if (this.flags_info[flag_index][2] == NO_DUPS && this.flags_specified[flag_index] != null) {
            throw new Flag_error(this.messages.getString("PARSER_ERROR_DUPLICATE_FLAGS_NOT_ALLOWED"), this.flagMessages.getString(this.flags_info[flag_index][0]));
        }
        if (this.flags_specified[flag_index] == null) {
            this.flags_specified[flag_index] = new Vector(3);
        }
        this.flags_specified[flag_index].add(flag_parm);
    }

    private void check_rules() throws Flag_error {
        int positional_count = 0;
        if (this.flags_specified[0] != null) {
            positional_count = this.flags_specified[0].size();
        }
        if (this.required_positionals > positional_count) {
            throw new Flag_error(this.messages.getString("PARSER_ERROR_MISSING_POSITIONAL"), this.flagMessages.getString(this.flags_info[this.required_positionals - 1][1]));
        }
        if (this.required_positionals < positional_count && !this.optional_positionals_allowed) {
            throw new Flag_error(this.messages.getString("PARSER_ERROR_TOO_MANY_POSITIONALS"));
        }
        int row = 0;
        while (row < this.flags_info.length) {
            if (this.flags_info[row][0] != "") {
                if (this.flags_specified[row] == null && this.flags_info[row][3] == REQUIRED) {
                    throw new Flag_error(this.messages.getString("PARSER_ERROR_MISSING_REQUIRED_FLAG"), this.flagMessages.getString(this.flags_info[row][0]));
                }
                int parm_count = 0;
                if (this.flags_specified[row] != null) {
                    parm_count = this.flags_specified[row].size();
                }
                if (this.flags_info[row][2] == NO_DUPS && parm_count > 1) {
                    throw new Flag_error(this.messages.getString("PARSER_ERROR_DUPLICATE_FLAGS_NOT_ALLOWED"), this.flagMessages.getString(this.flags_info[row][0]));
                }
                if (parm_count > 0 && this.flags_info[row][1] != "") {
                    int index = 0;
                    while (index < this.flags_specified[row].size()) {
                        if (this.flags_specified[row].elementAt(index) == null) {
                            throw new Flag_error(this.messages.getString("PARSER_ERROR_MISSING_FLAG_PARAMETER"), new String[]{this.flagMessages.getString(this.flags_info[row][0]), this.flagMessages.getString(this.flags_info[row][1])});
                        }
                        ++index;
                    }
                }
            }
            ++row;
        }
    }

    private void verify_flags_info() throws InternalErrorExc {
        boolean done_positionals = false;
        boolean help_specified = false;
        this.required_positionals = 0;
        this.optional_positionals_allowed = false;
        this.optional_list_index = -1;
        this.max_flag_size = 0;
        this.max_name_size = 0;
        if (this.flags_info == null || this.flags_info.length == 0) {
            throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_NO_FLAGS_DATA_SPECIFIED"));
        }
        if (this.flags_info[0] != null && this.flags_info[0].length > 0 && this.flags_info[0][0] != "") {
            throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_FIRST_FLAG_NOT_POSITIONAL"));
        }
        int row = 0;
        while (row < this.flags_info.length) {
            String name_col;
            if (this.flags_info[row] == null) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_NULL_FLAG_ROW"));
            }
            if (this.flags_info[row].length != 5) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_INCORRECT_ROW_SIZE"));
            }
            if (this.flags_info[row][0] == null || this.flags_info[row][1] == null || this.flags_info[row][4] == null) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_NULL_IN_ROW"));
            }
            if (this.flags_info[row][0].equals(this.help_flag)) {
                help_specified = true;
            }
            String flagId = this.flags_info[row][0];
            String nameId = this.flags_info[row][1];
            String flag_col = flagId == "" ? "" : this.flagMessages.getString(flagId);
            String string = name_col = nameId == "" ? "" : this.flagMessages.getString(nameId);
            if (flag_col.length() > this.max_flag_size) {
                this.max_flag_size = flag_col.length();
            }
            if (name_col != "" && name_col.length() > this.max_name_size) {
                this.max_name_size = name_col.length();
            }
            if (!flag_col.equals(flag_col.toLowerCase())) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_FLAG_NOT_LOWERCASE"), flag_col);
            }
            if (this.flags_info[row][2] == null || this.flags_info[row][2] != NO_DUPS && this.flags_info[row][2] != DUPS_OK) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_INCORRECT_DUP_STRING"), this.flags_info[row][2]);
            }
            if (this.flags_info[row][3] == null || this.flags_info[row][3] != REQUIRED && this.flags_info[row][3] != OPTIONAL) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_INCORRECT_REQUIRED_STRING"), this.flags_info[row][3]);
            }
            if (this.flags_info[row][0] == "") {
                if (this.flags_info[row][3] == REQUIRED) {
                    if (this.flags_info[row][1] == "") {
                        throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_REQUIRED_POSITIONAL_NEEDS_NAME"));
                    }
                    ++this.required_positionals;
                } else if (this.flags_info[row][1] != "") {
                    this.optional_positionals_allowed = true;
                    this.optional_list_index = row;
                }
            }
            if (this.flags_info[row][0] != "" || !done_positionals && this.flags_info[row][0] == "" && this.flags_info[row][3] == OPTIONAL) {
                done_positionals = true;
            } else if (done_positionals) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_POSITIONAL_NOT_AT_BEGINNING"));
            }
            ++row;
        }
        if (!help_specified) {
            throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_HELP_FLAG_NOT_SPECIFIED"));
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        int row = 0;
        while (row < this.flags_info.length) {
            b.append("\n");
            if (this.flags_info[row][0] == "") {
                b.append("Positional:");
            } else {
                b.append(String.valueOf(this.flagMessages.getString(this.flags_info[row][0])) + ":");
            }
            if (this.flags_specified[row] == null) {
                b.append("no parameters");
            } else {
                int parm_index = 0;
                while (parm_index < this.flags_specified[row].size()) {
                    String parm = (String)this.flags_specified[row].elementAt(parm_index);
                    b.append(String.valueOf(parm) + ":");
                    ++parm_index;
                }
            }
            b.append("\n");
            ++row;
        }
        return "" + b;
    }

    public static class ErrorExc
    extends Exception {
        private static final long serialVersionUID = 3257567317259793720L;

        public ErrorExc(String message, String[] args) {
            super(MessageFormat.format(message, args));
        }
    }

    public static class Flag_error
    extends ErrorExc {
        private static final long serialVersionUID = 3832621776877663537L;

        public Flag_error(String message, String[] args) {
            super(message, args);
        }

        public Flag_error(String message, String arg) {
            super(message, new String[]{arg});
        }

        public Flag_error(String message) {
            super(message, (String[])null);
        }
    }

    public static class InternalErrorExc
    extends IllegalArgumentException {
        private static final long serialVersionUID = 3258410621136614450L;

        public InternalErrorExc(String message, String[] args) {
            super(MessageFormat.format(message, args));
        }

        public InternalErrorExc(String message) {
            this(message, (String[])null);
        }

        public InternalErrorExc(String message, String arg) {
            this(message, new String[]{arg});
        }
    }
}

