/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.internal.jca.providers;



import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jst.j2ee.jca.internal.util.JcaAdapterFactory;


/**
 * This is the factory that is used to provide the interfaces needed to support
 * {@link org.eclipse.jface.viewers.Viewer}s. The adapters generated by this factory convert EMF
 * adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support property sheets, see {@link org.eclipse.ui.views.properties}. Note that most of the
 * adapters are shared among multiple instances.
 */
public class JcaItemProviderAdapterFactory extends JcaAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement IChangeNotifier.
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by isFactoryForType
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 */
	public JcaItemProviderAdapterFactory() {
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(ITableItemLabelProvider.class);
	}// JcaItemProviderAdapterFactory

	/**
	 * This keeps track of the one adapter used for all Connector instances.
	 */
	protected ConnectorItemProvider connectorItemProvider;

	/**
	 * This creates an adapter for a Connector.
	 * 
	 * @return Adapter
	 */
	public Adapter createConnectorAdapter() {
		if (connectorItemProvider == null) {
			connectorItemProvider = new ConnectorItemProvider(this);
		}// if

		return connectorItemProvider;
	}// createConnectorAdapter

	/**
	 * This keeps track of the one adapter used for all License instances.
	 */
	protected LicenseItemProvider licenseItemProvider;

	/**
	 * This creates an adapter for a License.
	 * 
	 * @return Adapter
	 */
	public Adapter createLicenseAdapter() {
		if (licenseItemProvider == null) {
			licenseItemProvider = new LicenseItemProvider(this);
		}// if

		return licenseItemProvider;
	}// createLicenseAdapter

	/**
	 * This keeps track of the one adapter used for all
	 * {@link com.ibm.etools.jca.InboundResourceAdapter}instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected InboundResourceAdapterItemProvider inboundResourceAdapterItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.InboundResourceAdapter}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createInboundResourceAdapterAdapter() {
		if (inboundResourceAdapterItemProvider == null) {
			inboundResourceAdapterItemProvider = new InboundResourceAdapterItemProvider(this);
		}

		return inboundResourceAdapterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link com.ibm.etools.jca.OutboundResourceAdapter}instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected OutboundResourceAdapterItemProvider outboundResourceAdapterItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.OutboundResourceAdapter}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createOutboundResourceAdapterAdapter() {
		if (outboundResourceAdapterItemProvider == null) {
			outboundResourceAdapterItemProvider = new OutboundResourceAdapterItemProvider(this);
		}

		return outboundResourceAdapterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.ibm.etools.jca.MessageAdapter}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessageAdapterItemProvider messageAdapterItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.MessageAdapter}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createMessageAdapterAdapter() {
		if (messageAdapterItemProvider == null) {
			messageAdapterItemProvider = new MessageAdapterItemProvider(this);
		}

		return messageAdapterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link com.ibm.etools.jca.ConnectionDefinition}instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ConnectionDefinitionItemProvider connectionDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.ConnectionDefinition}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createConnectionDefinitionAdapter() {
		if (connectionDefinitionItemProvider == null) {
			connectionDefinitionItemProvider = new ConnectionDefinitionItemProvider(this);
		}

		return connectionDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.ibm.etools.jca.AdminObject}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AdminObjectItemProvider adminObjectItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.AdminObject}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createAdminObjectAdapter() {
		if (adminObjectItemProvider == null) {
			adminObjectItemProvider = new AdminObjectItemProvider(this);
		}

		return adminObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.ibm.etools.jca.MessageListener}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessageListenerItemProvider messageListenerItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.MessageListener}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createMessageListenerAdapter() {
		if (messageListenerItemProvider == null) {
			messageListenerItemProvider = new MessageListenerItemProvider(this);
		}

		return messageListenerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.ibm.etools.jca.ActivationSpec}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivationSpecItemProvider activationSpecItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.ActivationSpec}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createActivationSpecAdapter() {
		if (activationSpecItemProvider == null) {
			activationSpecItemProvider = new ActivationSpecItemProvider(this);
		}

		return activationSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link com.ibm.etools.jca.RequiredConfigPropertyType}instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected RequiredConfigPropertyTypeItemProvider requiredConfigPropertyTypeItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.RequiredConfigPropertyType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Adapter createRequiredConfigPropertyTypeAdapter() {
		if (requiredConfigPropertyTypeItemProvider == null) {
			requiredConfigPropertyTypeItemProvider = new RequiredConfigPropertyTypeItemProvider(this);
		}

		return requiredConfigPropertyTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all ResourceAdapter instances.
	 */
	protected ResourceAdapterItemProvider resourceAdapterItemProvider;

	/**
	 * This creates an adapter for a ResourceAdapter.
	 * 
	 * @return Adapter
	 */
	public Adapter createResourceAdapterAdapter() {
		if (resourceAdapterItemProvider == null) {
			resourceAdapterItemProvider = new ResourceAdapterItemProvider(this);
		}// if

		return resourceAdapterItemProvider;
	}// createResourceAdapterAdapter

	/**
	 * This keeps track of the one adapter used for all SecurityPermission instances.
	 */
	protected SecurityPermissionItemProvider securityPermissionItemProvider;

	/**
	 * This creates an adapter for a SecurityPermission.
	 * 
	 * @return Adapter
	 */
	public Adapter createSecurityPermissionAdapter() {
		if (securityPermissionItemProvider == null) {
			securityPermissionItemProvider = new SecurityPermissionItemProvider(this);
		}// if

		return securityPermissionItemProvider;
	}// createSecurityPermissionAdapter

	/**
	 * This keeps track of the one adapter used for all AuthenticationMechanism instances
	 */
	protected AuthenticationMechanismItemProvider authenticationMechanismItemProvider;

	/**
	 * This creates an adapter for a AuthenticationMechanism.
	 * 
	 * @return Adapter
	 */
	public Adapter createAuthenticationMechanismAdapter() {
		if (authenticationMechanismItemProvider == null) {
			authenticationMechanismItemProvider = new AuthenticationMechanismItemProvider(this);
		}// if

		return authenticationMechanismItemProvider;
	}// createAuthenticationMechanismAdapter

	/**
	 * This keeps track of the one adapter used for all ConfigProperty instances.
	 */
	protected ConfigPropertyItemProvider configPropertyItemProvider;

	/**
	 * This creates an adapter for a {@link com.ibm.etools.jca.ConfigProperty}.
	 */
	public Adapter createConfigPropertyAdapter() {
		if (configPropertyItemProvider == null) {
			configPropertyItemProvider = new ConfigPropertyItemProvider(this);
		}// if

		return configPropertyItemProvider;
	}// createConfigPropertyAdapter

	/**
	 * This returns the root adapter factory that contains this factory.
	 * 
	 * @return ComposeableAdapterFactory
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}// getRootAdapterFactory

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * 
	 * @return ComposedAdapterFactory
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}// setParentAdapterFactory

	/**
	 * Checks if it is a factory type
	 * 
	 * @param Object
	 *            type - The given type
	 * @return boolean
	 */
	public boolean isFactoryForType(Object type) {
		return super.isFactoryForType(type) || supportedTypes.contains(type);
	}// isFactoryForType

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * 
	 * @param Notifier
	 *            notifier - The given notifer.
	 * @param Object
	 *            type - The given type
	 * @return Adapter
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}// adapt

	/**
	 * Does adapting.
	 * 
	 * @param Object
	 *            object - The given object.
	 * @param Oject
	 *            type - The given type.
	 * @return Object
	 */
	public Object adapt(Object object, Object type) {
		// This is a kludge to deal with enumerators, which crash the doSwitch.
		//
		if (object instanceof EObject && ((EObject) object).eClass() == null) {
			return null;
		}// if

		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class) type).isInstance(adapter))) {
				return adapter;
			}// if
		}// if

		return null;
	}// adapt

	/**
	 * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * 
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}// removeListener

	/**
	 * This delegates to change Notifier and to parent AdapterFactory.
	 * 
	 * @param Object
	 *            object - The given object.
	 * @param int
	 *            eventType - The given type of event.
	 * @param Object
	 *            feature - The given feature.
	 * @param Object
	 *            oldValue - The old value of the event.
	 * @param Object
	 *            nreValue - The new value of the event.
	 * @param int
	 *            index - The current index
	 */
	public void fireNotifyChanged(Notification msg) {
		changeNotifier.fireNotifyChanged(msg);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(msg);
		}// if
	}// fireNotifyChanged

}// JcaItemProviderAdapterFactory
