/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.sqleditor.internal.sql;


import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources;

/**
 * This class implements the hover popup text service for SQL code.
 */
public class SQLTextHover implements ITextHover {

	/**
     * Returns the information which should be presented when a hover popup is shown
     * for the specified hover region.  The hover region has the same semantics
     * as the region returned by <code>getHoverRegion</code>. If the returned
     * information is <code>null</code> or empty no hover popup will be shown.
     * 
	 * @see org.eclipse.jface.text.ITextHover#getHoverInfo(org.eclipse.jface.text.ITextViewer, org.eclipse.jface.text.IRegion)
	 */
	public String getHoverInfo( ITextViewer textViewer, IRegion hoverRegion ) {
        // TODO: make this do something useful
		if (hoverRegion != null) {
			try {
				if (hoverRegion.getLength() > -1)
					return textViewer.getDocument().get( hoverRegion.getOffset(), hoverRegion.getLength() );
			} catch (BadLocationException x) {
			}
		}
		return SQLEditorResources.getString( "SQLEditor.textHover.emptySelection" ); //$NON-NLS-1$
	}
	
	/**
	 * Returns the text region which should serve as the source of information 
     * to compute the hover popup display information. The popup has been requested
     * for the given offset.
     * 
     * @see org.eclipse.jface.text.ITextHover#getHoverRegion(org.eclipse.jface.text.ITextViewer, int)
	 */
	public IRegion getHoverRegion( ITextViewer textViewer, int offset ) {
		Point selection = textViewer.getSelectedRange();
		if (selection.x <= offset && offset < selection.x + selection.y)
			return new Region( selection.x, selection.y );
		return new Region( offset, 0 );
	}
}
