/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorAction;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class SortViewAction
extends ResourceNavigatorAction {
    private int sortCriteria;

    public SortViewAction(IResourceNavigator navigator, boolean sortByType) {
        super(navigator, sortByType ? ResourceNavigatorMessages.SortView_byType : ResourceNavigatorMessages.SortView_byName);
        if (sortByType) {
            this.setToolTipText(ResourceNavigatorMessages.SortView_toolTipByType);
        } else {
            this.setToolTipText(ResourceNavigatorMessages.SortView_toolTipByName);
        }
        this.setEnabled(true);
        this.sortCriteria = sortByType ? 2 : 1;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.sort_view_action_context");
    }

    public void run() {
        IResourceNavigator navigator = this.getNavigator();
        ResourceSorter sorter = navigator.getSorter();
        if (sorter == null) {
            navigator.setSorter(new ResourceSorter(this.sortCriteria));
        } else {
            sorter.setCriteria(this.sortCriteria);
            navigator.setSorter(sorter);
        }
    }
}

