/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class JavaTypeExtender
extends PropertyTester {
    private static final String PROPERTY_IS_Test = "isTest";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IJavaElement javaElement = null;
        if (receiver instanceof IAdaptable) {
            javaElement = (IJavaElement)((IAdaptable)receiver).getAdapter(IJavaElement.class);
        }
        if (javaElement != null && !javaElement.exists()) {
            return false;
        }
        if (javaElement != null && PROPERTY_IS_Test.equals(method)) {
            return this.isTest(javaElement);
        }
        return false;
    }

    private boolean isTest(IJavaElement element) {
        try {
            IType testType = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                testType = cu.getType(Signature.getQualifier((String)cu.getElementName()));
            } else if (element instanceof IClassFile) {
                testType = ((IClassFile)element).getType();
            } else if (element instanceof IType) {
                testType = (IType)element;
            } else if (element instanceof IMember) {
                testType = ((IMember)element).getDeclaringType();
            }
            if (testType != null && testType.exists() && TestSearchEngine.isTestOrTestSuite(testType)) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

