/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;

public class WorkbenchControlAnimator
extends ControlAnimator {
    private static final int CLOSED = 0;
    private static final int OPENING = 1;
    private static final int OPEN = 2;
    private static final int CLOSING = 3;
    private UIJob slideJob;
    private int endY;
    private boolean finished;
    private boolean inTransition = false;
    private boolean animated = false;
    private int state = 0;
    private int LONG_DELAY = 300;
    private int SHORT_DELAY = 25;

    public WorkbenchControlAnimator(Control control) {
        super(control);
    }

    public void setVisible(boolean visible) {
        if (this.animated) {
            super.setVisible(visible);
            return;
        }
        this.setAnimationState(visible ? 1 : 3);
        this.finished = false;
        this.control.setVisible(true);
        Rectangle parentBounds = this.control.getParent().getBounds();
        int bottom = parentBounds.height;
        if (bottom <= 0) {
            this.setAnimationState(2);
            return;
        }
        int n = this.endY = visible ? bottom - this.control.getBounds().height : bottom;
        if (this.slideJob != null) {
            this.slideJob.cancel();
        }
        this.slideJob = this.getSlideJob();
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbenchControlAnimator.this.slideJob = null;
            }
        });
        if (this.getAnimationState() == 1 && !this.inTransition) {
            this.slideJob.schedule(this.LONG_DELAY);
        } else {
            this.slideJob.schedule(this.SHORT_DELAY);
        }
    }

    private UIJob getSlideJob() {
        UIJob newSlideJob = new UIJob("Sliding Message"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled() && !WorkbenchControlAnimator.this.control.isDisposed()) {
                    Point loc = WorkbenchControlAnimator.this.control.getLocation();
                    switch (WorkbenchControlAnimator.this.getAnimationState()) {
                        case 1: {
                            WorkbenchControlAnimator.this.animated = true;
                            --loc.y;
                            if (loc.y >= WorkbenchControlAnimator.this.endY) {
                                WorkbenchControlAnimator.this.control.setLocation(loc);
                                break;
                            }
                            WorkbenchControlAnimator.this.finished = true;
                            WorkbenchControlAnimator.this.setAnimationState(2);
                            break;
                        }
                        case 3: {
                            ++loc.y;
                            if (loc.y <= WorkbenchControlAnimator.this.endY) {
                                WorkbenchControlAnimator.this.control.setLocation(loc);
                                break;
                            }
                            WorkbenchControlAnimator.this.finished = true;
                            WorkbenchControlAnimator.this.setAnimationState(0);
                            WorkbenchControlAnimator.this.control.setVisible(false);
                            break;
                        }
                    }
                    if (!WorkbenchControlAnimator.this.finished) {
                        WorkbenchControlAnimator.this.inTransition = true;
                        WorkbenchControlAnimator.this.slideJob.schedule(5L);
                    } else {
                        WorkbenchControlAnimator.this.inTransition = false;
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        newSlideJob.setSystem(true);
        return newSlideJob;
    }

    private void setAnimationState(int state) {
        this.state = state;
    }

    private int getAnimationState() {
        return this.state;
    }
}

