/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;

public class ExcludeOperation
extends ClasspathModifierOperation {
    public ExcludeOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip, 2);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List javaElements = this.getSelectedElements();
            IJavaProject project = this.fInformationProvider.getJavaProject();
            result = this.exclude(javaElements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        if (elements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            int type = types[i];
            if (type != 3 && type != 11 && !(element instanceof ICompilationUnit)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getDescription(int type) {
        IJavaElement elem = (IJavaElement)this.getSelectedElements().get(0);
        String name = ExcludeOperation.escapeSpecialChars(elem.getElementName());
        if (type == 3) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, name);
        }
        if (type == 11) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, name);
        }
        if (type == 4) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, name);
        }
        if (type == 10) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, name);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Exclude;
    }
}

