/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitDescriptorChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class InlineTempRefactoring
extends ScriptableRefactoring {
    private static final String ID_INLINE_TEMP = "org.eclipse.jdt.ui.inline.temp";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private VariableDeclaration fTempDeclaration;
    private CompilationUnit fCompilationUnitNode;
    private int[] fReferenceOffsets;

    public InlineTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
    }

    public RefactoringStatus checkIfTempSelected(CompilationUnit node) {
        Assert.isNotNull((Object)node);
        this.fCompilationUnitNode = node;
        this.fTempDeclaration = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
        if (this.fTempDeclaration == null) {
            String message = RefactoringCoreMessages.InlineTempRefactoring_select_temp;
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
        }
        if (this.fTempDeclaration.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_fieldsCannotBeInlined);
        }
        return new RefactoringStatus();
    }

    public String getName() {
        return RefactoringCoreMessages.InlineTempRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (!this.fCu.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_syntax_errors);
                return refactoringStatus;
            }
            result.merge(this.checkSelection());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkInitializer());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkInitializer() {
        if (this.fTempDeclaration.getInitializer().getNodeType() == 33) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_nulLiteralsCannotBeInlined);
        }
        return null;
    }

    private RefactoringStatus checkSelection() {
        if (this.fTempDeclaration.getParent() instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_method_parameter);
        }
        if (this.fTempDeclaration.getParent() instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_exceptions_declared);
        }
        if (ASTNodes.getParent((ASTNode)this.fTempDeclaration, 24) != null) {
            ForStatement forStmt = (ForStatement)ASTNodes.getParent((ASTNode)this.fTempDeclaration, 24);
            Iterator iter = forStmt.initializers().iterator();
            while (iter.hasNext()) {
                if (!ASTNodes.isParent((ASTNode)this.fTempDeclaration, (ASTNode)((Expression)iter.next()))) continue;
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_for_initializers);
            }
        }
        if (this.fTempDeclaration.getInitializer() == null) {
            String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_not_initialized, this.fTempDeclaration.getName().getIdentifier());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return this.checkAssignments();
    }

    private RefactoringStatus checkAssignments() {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclaration);
        this.fCompilationUnitNode.accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        int start = assignmentFinder.getFirstAssignment().getStartPosition();
        int length = assignmentFinder.getFirstAssignment().getLength();
        SourceRange range = new SourceRange(start, length);
        RefactoringStatusContext context = JavaStatusContext.create(this.fCu, (ISourceRange)range);
        String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_assigned_more_once, this.fTempDeclaration.getName().getIdentifier());
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineTempRefactoring_preview, 2);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            IVariableBinding binding = this.fTempDeclaration.resolveBinding();
            String text = null;
            IMethodBinding method = binding.getDeclaringMethod();
            text = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
            String description = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description_short, binding.getName());
            String header = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), text});
            JavaRefactoringDescriptorComment comment = new JavaRefactoringDescriptorComment(this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineTempRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_INLINE_TEMP, project, description, comment.asString(), arguments, 0);
            arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fCu));
            arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            CompilationUnitDescriptorChange result = new CompilationUnitDescriptorChange(descriptor, RefactoringCoreMessages.InlineTempRefactoring_inline, this.fCu);
            this.inlineTemp((TextChange)result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.removeTemp((TextChange)result);
            CompilationUnitDescriptorChange compilationUnitDescriptorChange = result;
            return compilationUnitDescriptorChange;
        }
        finally {
            pm.done();
        }
    }

    private void inlineTemp(TextChange change, IProgressMonitor pm) throws JavaModelException {
        int[] offsets = this.getReferenceOffsets();
        pm.beginTask("", offsets.length);
        String changeName = RefactoringCoreMessages.InlineTempRefactoring_inline_edit_name;
        int length = this.fTempDeclaration.getName().getIdentifier().length();
        int i = 0;
        while (i < offsets.length) {
            int offset = offsets[i];
            String sourceToInline = this.getInitializerSource(this.needsBrackets(offset), this.isArrayInitializer());
            TextChangeCompatibility.addTextEdit(change, changeName, (TextEdit)new ReplaceEdit(offset, length, sourceToInline));
            pm.worked(1);
            ++i;
        }
    }

    private boolean needsBrackets(int offset) {
        Expression initializer = this.fTempDeclaration.getInitializer();
        if (initializer instanceof Assignment) {
            return true;
        }
        SimpleName inlineSite = this.getReferenceAtOffset(offset);
        if (inlineSite == null) {
            return true;
        }
        return ASTNodes.substituteMustBeParenthesized(initializer, (Expression)inlineSite);
    }

    private boolean isArrayInitializer() {
        return this.fTempDeclaration.getInitializer().getNodeType() == 4;
    }

    private SimpleName getReferenceAtOffset(int offset) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(offset, this.fTempDeclaration.getName().getIdentifier().length()), true);
        this.fCompilationUnitNode.accept((ASTVisitor)analyzer);
        ASTNode reference = analyzer.getFirstSelectedNode();
        if (!this.isReference(reference)) {
            return null;
        }
        return (SimpleName)reference;
    }

    private boolean isReference(ASTNode node) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        return ((SimpleName)node).getIdentifier().equals(this.fTempDeclaration.getName().getIdentifier());
    }

    private void removeTemp(TextChange change) throws JavaModelException {
        if (this.fTempDeclaration.getParent() instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)this.fTempDeclaration.getParent();
            if (vds.fragments().size() == 1) {
                this.removeDeclaration(change, vds.getStartPosition(), vds.getLength());
                return;
            }
            return;
        }
        this.removeDeclaration(change, this.fTempDeclaration.getStartPosition(), this.fTempDeclaration.getLength());
    }

    private void removeDeclaration(TextChange change, int offset, int length) throws JavaModelException {
        ISourceRange range = SourceRangeComputer.computeSourceRange(new SourceRange(offset, length), this.fCu.getSource());
        String changeName = RefactoringCoreMessages.InlineTempRefactoring_remove_edit_name;
        TextChangeCompatibility.addTextEdit(change, changeName, (TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
    }

    private String getInitializerSource(boolean brackets, boolean isArrayInitializer) throws JavaModelException {
        if (brackets) {
            return String.valueOf('(') + this.getModifiedInitializerSource(isArrayInitializer) + ')';
        }
        return this.getModifiedInitializerSource(isArrayInitializer);
    }

    private String getModifiedInitializerSource(boolean isArrayInitializer) throws JavaModelException {
        if (isArrayInitializer) {
            return "new " + this.getTypeNameWithExtraArrayDimensions() + this.getRawInitializerSource();
        }
        return this.getRawInitializerSource();
    }

    private String getTypeNameWithExtraArrayDimensions() throws JavaModelException {
        if (this.fTempDeclaration instanceof SingleVariableDeclaration) {
            return this.getRawTypeName(((SingleVariableDeclaration)this.fTempDeclaration).getType());
        }
        if (this.fTempDeclaration instanceof VariableDeclarationFragment) {
            String name = this.getRawTypeName(((VariableDeclarationStatement)this.fTempDeclaration.getParent()).getType());
            int i = 0;
            while (i < ((VariableDeclarationFragment)this.fTempDeclaration).getExtraDimensions()) {
                name = String.valueOf(name) + "[]";
                ++i;
            }
            return name;
        }
        Assert.isTrue((boolean)false, (String)"Must be either SingleVariableDeclaration or VariableDeclarationFragment");
        return null;
    }

    private String getRawTypeName(Type selection) throws JavaModelException {
        int start = selection.getStartPosition();
        int end = start + selection.getLength();
        return this.fCu.getSource().substring(start, end);
    }

    private String getRawInitializerSource() throws JavaModelException {
        int start = this.fTempDeclaration.getInitializer().getStartPosition();
        int length = this.fTempDeclaration.getInitializer().getLength();
        int end = start + length;
        return this.fCu.getSource().substring(start, end);
    }

    public int[] getReferenceOffsets() {
        if (this.fReferenceOffsets == null) {
            TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.fTempDeclaration, false);
            analyzer.perform();
            this.fReferenceOffsets = analyzer.getReferenceOffsets();
        }
        return this.fReferenceOffsets;
    }

    public VariableDeclaration getTempDeclaration() {
        return this.fTempDeclaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String selection = extended.getAttribute("selection");
        if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        int offset = -1;
        int length = -1;
        StringTokenizer tokenizer = new StringTokenizer(selection);
        if (tokenizer.hasMoreTokens()) {
            offset = Integer.valueOf(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            length = Integer.valueOf(tokenizer.nextToken());
        }
        if (offset < 0 || length < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return this.createInputFatalStatus(element, ID_INLINE_TEMP);
        }
        this.fCu = (ICompilationUnit)element;
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(this.fCu);
        if (!this.checkIfTempSelected((CompilationUnit)parser.createAST(null)).hasFatalError()) return new RefactoringStatus();
        return this.createInputFatalStatus(element, ID_INLINE_TEMP);
    }
}

