/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jface.dialogs.IDialogSettings;

public abstract class AbstractCleanUp
implements ICleanUp {
    private static final String SETTINGS_FLAG_NAME = "flag";
    private int fFlags;

    protected static IDialogSettings getSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected AbstractCleanUp(IDialogSettings settings, int defaultFlag) {
        if (settings.get(SETTINGS_FLAG_NAME) == null) {
            settings.put(SETTINGS_FLAG_NAME, defaultFlag);
        }
        this.fFlags = settings.getInt(SETTINGS_FLAG_NAME);
    }

    protected AbstractCleanUp(int flag) {
        this.fFlags = flag;
    }

    public void saveSettings(IDialogSettings settings) {
        settings.put(SETTINGS_FLAG_NAME, this.fFlags);
    }

    public void setFlag(int flag, boolean b) {
        if (!this.isFlag(flag) && b) {
            this.fFlags |= flag;
        } else if (this.isFlag(flag) && !b) {
            this.fFlags &= ~flag;
        }
    }

    public boolean isFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    protected int getNumberOfProblems(IProblem[] problems, int problemId) {
        int result = 0;
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getID() == problemId) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void beginCleanUp(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.done();
        }
    }

    public void endCleanUp() throws CoreException {
    }
}

