/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class NewDefiningMethodProposal
extends AbstractMethodCompletionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private final IMethodBinding fMethod;
    private final String[] fParamNames;

    public NewDefiningMethodProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, IMethodBinding method, String[] paramNames, int relevance) {
        super(label, targetCU, invocationNode, binding, relevance, null);
        this.fMethod = method;
        this.fParamNames = paramNames;
        ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(binding.isInterface() || binding.isAnnotation(), method.getModifiers());
        this.setImage(JavaPlugin.getImageDescriptorRegistry().get(desc));
    }

    protected boolean isConstructor() {
        return this.fMethod.isConstructor();
    }

    protected void addNewParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getParameterTypes();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] paramNames = StubUtility.suggestArgumentNames(project, this.fParamNames);
        int i = 0;
        while (i < bindings.length) {
            ITypeBinding curr = bindings[i];
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setType(importRewrite.addImport(curr, ast));
            newParam.setName(ast.newSimpleName(paramNames[i]));
            params.add(newParam);
            this.addLinkedPosition(rewrite.track((ASTNode)newParam.getType()), false, "arg_type_" + i);
            this.addLinkedPosition(rewrite.track((ASTNode)newParam.getName()), false, "arg_name_" + i);
            ++i;
        }
    }

    protected SimpleName getNewName(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleName nameNode = ast.newSimpleName(this.fMethod.getName());
        this.addLinkedPosition(rewrite.track((ASTNode)nameNode), false, KEY_NAME);
        return nameNode;
    }

    protected int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.getSenderBinding().isInterface()) {
            return 0;
        }
        int modifiers = this.fMethod.getModifiers();
        if (Modifier.isPrivate((int)modifiers)) {
            modifiers |= 4;
        }
        return modifiers & 0xC05;
    }

    protected Type getNewMethodType(ASTRewrite rewrite) throws CoreException {
        Type newTypeNode = this.getImportRewrite().addImport(this.fMethod.getReturnType(), rewrite.getAST());
        this.addLinkedPosition(rewrite.track((ASTNode)newTypeNode), false, KEY_TYPE);
        return newTypeNode;
    }

    protected void addNewExceptions(ASTRewrite rewrite, List exceptions) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getExceptionTypes();
        int i = 0;
        while (i < bindings.length) {
            String typeName = importRewrite.addImport(bindings[i]);
            Name newNode = ASTNodeFactory.newName(ast, typeName);
            exceptions.add(newNode);
            this.addLinkedPosition(rewrite.track((ASTNode)newNode), false, "exc_type_" + i);
            ++i;
        }
    }

    protected void addNewTypeParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
    }
}

