/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.core.BackgroundEventHandler;

public class DeferredResourceChangeHandler
extends BackgroundEventHandler {
    private static final int IGNORE_FILE_CHANGED = 1;
    private static final int RECREATED_CVS_RESOURCE = 2;
    private static final int CONFLICTING_DELETION = 3;
    private Set changedIgnoreFiles = new HashSet();
    private Set recreatedResources = new HashSet();
    private Set conflictingDeletion = new HashSet();

    public DeferredResourceChangeHandler() {
        super(CVSMessages.DeferredResourceChangeHandler_0, CVSMessages.DeferredResourceChangeHandler_1);
    }

    protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws TeamException {
        int type = event.getType();
        switch (type) {
            case 1: {
                this.changedIgnoreFiles.add(event.getResource());
                break;
            }
            case 2: {
                this.recreatedResources.add(event.getResource());
                break;
            }
            case 3: {
                this.conflictingDeletion.add(event.getResource());
            }
        }
    }

    private IContainer[] getParents(Set files) {
        HashSet<IContainer> parents = new HashSet<IContainer>();
        for (IFile file : files) {
            parents.add(file.getParent());
        }
        return parents.toArray(new IContainer[parents.size()]);
    }

    public void ignoreFileChanged(IFile file) {
        if (this.isSharedWithCVS((IResource)file)) {
            this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent((IResource)file, 1, 0), false);
        }
    }

    public void recreated(IResource resource) {
        if (this.isSharedWithCVS(resource)) {
            this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent(resource, 2, 0), false);
        }
    }

    protected boolean doDispatchEvents(IProgressMonitor monitor) {
        boolean workDone = !this.changedIgnoreFiles.isEmpty() || !this.recreatedResources.isEmpty();
        try {
            EclipseSynchronizer.getInstance().ignoreFilesChanged(this.getParents(this.changedIgnoreFiles));
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        this.changedIgnoreFiles.clear();
        Map recreations = this.getResourcesByProject(this.recreatedResources.toArray(new IResource[this.recreatedResources.size()]));
        this.recreatedResources.clear();
        for (List resources : recreations.values()) {
            try {
                EclipseSynchronizer.getInstance().resourcesRecreated(resources.toArray(new IResource[resources.size()]), monitor);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        IResource[] deletions = this.conflictingDeletion.toArray(new IResource[this.conflictingDeletion.size()]);
        this.conflictingDeletion.clear();
        int i = 0;
        while (i < deletions.length) {
            IResource resource = deletions[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            try {
                if (!cvsResource.isFolder() && cvsResource.isManaged()) {
                    cvsResource.unmanage(monitor);
                }
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
            ++i;
        }
        return workDone;
    }

    private Map getResourcesByProject(IResource[] resources) {
        HashMap<IProject, ArrayList<IResource>> result = new HashMap<IProject, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            IProject project = resource.getProject();
            ArrayList<IResource> projectResources = (ArrayList<IResource>)result.get(project);
            if (projectResources == null) {
                projectResources = new ArrayList<IResource>();
                result.put(project, projectResources);
            }
            projectResources.add(resource);
            ++i;
        }
        return result;
    }

    public void handleConflictingDeletion(IResource local) {
        if (this.isSharedWithCVS(local)) {
            this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent(local, 3, 0), false);
        }
    }

    private boolean isSharedWithCVS(IResource resource) {
        return CVSTeamProvider.isSharedWithCVS(resource.getProject());
    }

    protected Object getJobFamiliy() {
        return this;
    }
}

