/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocation;
import org.osgi.framework.Version;

public class SourceLocationManager
implements ICoreConstants {
    private SourceLocation[] fExtensionLocations = null;

    public SourceLocation[] getUserLocations() {
        ArrayList userLocations = new ArrayList();
        String pref = PDECore.getDefault().getPluginPreferences().getString("source_locations");
        if (pref.length() > 0) {
            this.parseSavedSourceLocations(pref, userLocations);
        }
        return userLocations.toArray(new SourceLocation[userLocations.size()]);
    }

    public SourceLocation[] getExtensionLocations() {
        if (this.fExtensionLocations == null) {
            ArrayList list = new ArrayList();
            ModelEntry[] entries = PDECore.getDefault().getModelManager().getEntries();
            int i = 0;
            while (i < entries.length) {
                IPluginModelBase model = entries[i].getExternalModel();
                if (model != null) {
                    SourceLocationManager.processExtensions(model, list);
                }
                ++i;
            }
            this.fExtensionLocations = list.toArray(new SourceLocation[list.size()]);
        }
        return this.fExtensionLocations;
    }

    public void setExtensionLocations(SourceLocation[] locations) {
        this.fExtensionLocations = locations;
    }

    public File findSourceFile(IPluginBase pluginBase, IPath sourcePath) {
        IPath relativePath = this.getRelativePath(pluginBase, sourcePath);
        SearchResult result = this.findSourceLocation(pluginBase, relativePath);
        return result != null ? result.file : null;
    }

    public IPath findSourcePath(IPluginBase pluginBase, IPath sourcePath) {
        IPath relativePath = this.getRelativePath(pluginBase, sourcePath);
        SearchResult result = this.findSourceLocation(pluginBase, relativePath);
        return result == null ? null : result.loc.getPath().append(relativePath);
    }

    private IPath getRelativePath(IPluginBase pluginBase, IPath sourcePath) {
        String pluginDir;
        block4: {
            try {
                pluginDir = pluginBase.getId();
                if (pluginDir != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        String version = pluginBase.getVersion();
        if (version != null) {
            Version vid = new Version(version);
            pluginDir = String.valueOf(pluginDir) + "_" + vid.toString();
        }
        return new Path(pluginDir).append(sourcePath);
    }

    public SearchResult findSourceLocation(IPluginBase pluginBase, IPath relativePath) {
        if (relativePath == null) {
            return null;
        }
        SearchResult result = this.findSearchResult(this.getUserLocations(), relativePath);
        return result != null ? result : this.findSearchResult(this.getExtensionLocations(), relativePath);
    }

    private SearchResult findSearchResult(SourceLocation[] locations, IPath sourcePath) {
        int i = 0;
        while (i < locations.length) {
            IPath fullPath = locations[i].getPath().append(sourcePath);
            File file = fullPath.toFile();
            if (file.exists()) {
                return new SearchResult(locations[i], file);
            }
            ++i;
        }
        return null;
    }

    private SourceLocation parseSourceLocation(String text) {
        String path;
        try {
            text = text.trim();
            int commaIndex = text.lastIndexOf(44);
            if (commaIndex == -1) {
                return new SourceLocation((IPath)new Path(text));
            }
            int atLoc = text.indexOf(64);
            path = atLoc == -1 ? text.substring(0, commaIndex) : text.substring(atLoc + 1, commaIndex);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return new SourceLocation((IPath)new Path(path));
    }

    private void parseSavedSourceLocations(String text, ArrayList entries) {
        text = text.replace(File.pathSeparatorChar, ';');
        StringTokenizer stok = new StringTokenizer(text, ";");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            SourceLocation location = this.parseSourceLocation(token);
            if (location == null) continue;
            entries.add(location);
        }
    }

    public static SourceLocation[] computeSourceLocations(IPluginModelBase[] models) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < models.length) {
            SourceLocationManager.processExtensions(models[i], result);
            ++i;
        }
        return result.toArray(new SourceLocation[result.size()]);
    }

    private static void processExtensions(IPluginModelBase model, ArrayList result) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int j = 0;
        while (j < extensions.length) {
            IPluginExtension extension = extensions[j];
            if ((String.valueOf(PDECore.getPluginId()) + ".source").equals(extension.getPoint())) {
                SourceLocationManager.processExtension(extension, result);
            }
            ++j;
        }
    }

    private static void processExtension(IPluginExtension extension, ArrayList result) {
        IPluginObject[] children = extension.getChildren();
        int j = 0;
        while (j < children.length) {
            if (children[j].getName().equals("location")) {
                IPluginElement element = (IPluginElement)children[j];
                String pathValue = element.getAttribute("path").getValue();
                ISharedPluginModel model = extension.getModel();
                IPath path = new Path(model.getInstallLocation()).append(pathValue);
                if (path.toFile().exists()) {
                    SourceLocation location = new SourceLocation(path);
                    location.setUserDefined(false);
                    if (!result.contains(location)) {
                        result.add(location);
                    }
                }
            }
            ++j;
        }
    }

    class SearchResult {
        SourceLocation loc;
        File file;

        SearchResult(SourceLocation loc, File file) {
            this.loc = loc;
            this.file = file;
        }
    }
}

