/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class KeyStores {
    private static final String JAVA_POLICY_URL = "policy.url.";
    private static final String DEFAULT_KEYSTORE_TYPE = "keystore.type";
    private List keyStores;

    public KeyStores() {
        this.initializeDefaultKeyStores();
    }

    private void processKeyStore(String urlSpec, String type, URL rootURL) {
        block21: {
            InputStream in;
            block20: {
                if (type == null) {
                    type = KeyStore.getDefaultType();
                }
                in = null;
                try {
                    try {
                        URL url;
                        try {
                            url = new URL(urlSpec);
                        }
                        catch (MalformedURLException malformedURLException) {
                            url = new URL(rootURL, urlSpec);
                        }
                        KeyStore ks = KeyStore.getInstance(type);
                        try {
                            in = url.openStream();
                        }
                        catch (IOException iOException) {}
                        if (in != null) {
                            ks.load(in, null);
                            this.keyStores.add(ks);
                        }
                    }
                    catch (Exception e) {
                        SignedBundleHook.log(e.getMessage(), 2, e);
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                break block21;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void initializeDefaultKeyStores() {
        this.keyStores = new ArrayList(5);
        String defaultType = Security.getProperty(DEFAULT_KEYSTORE_TYPE);
        String urlSpec = "file:" + FrameworkProperties.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        this.processKeyStore(urlSpec, defaultType, null);
        urlSpec = "file:" + FrameworkProperties.getProperty("user.home") + File.separator + ".keystore";
        this.processKeyStore(urlSpec, defaultType, null);
        urlSpec = FrameworkProperties.getProperty("osgi.framework.keystore");
        if (urlSpec != null) {
            this.processKeyStore(urlSpec, defaultType, null);
        }
        int index = 1;
        String java_policy = Security.getProperty(JAVA_POLICY_URL + index);
        while (java_policy != null) {
            this.processKeystoreFromLocation(java_policy);
            java_policy = Security.getProperty(JAVA_POLICY_URL + ++index);
        }
    }

    /*
     * Loose catch block
     */
    private void processKeystoreFromLocation(String location) {
        block21: {
            InputStream in;
            block20: {
                block18: {
                    block19: {
                        String content;
                        int indexOfKeystore;
                        in = null;
                        char[] buff = new char[4096];
                        int indexOf$ = location.indexOf("${");
                        int indexOfCurly = location.indexOf(125, indexOf$);
                        if (indexOf$ != -1 && indexOfCurly != -1) {
                            String prop = FrameworkProperties.getProperty(location.substring(indexOf$ + 2, indexOfCurly));
                            String location2 = location.substring(0, indexOf$);
                            location2 = String.valueOf(location2) + prop;
                            location = location2 = String.valueOf(location2) + location.substring(indexOfCurly + 1);
                        }
                        URL url = new URL(location);
                        in = url.openStream();
                        InputStreamReader reader = new InputStreamReader(in);
                        int result = reader.read(buff);
                        StringBuffer contentBuff = new StringBuffer();
                        while (result != -1) {
                            contentBuff.append(buff, 0, result);
                            result = reader.read(buff);
                        }
                        if (contentBuff.length() <= 0 || (indexOfKeystore = (content = new String(contentBuff.toString())).indexOf("keystore")) == -1) break block18;
                        int indexOfSemiColumn = content.indexOf(59, indexOfKeystore);
                        this.processKeystoreFromString(content.substring(indexOfKeystore, indexOfSemiColumn), url);
                        if (in == null) break block19;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                    {
                        catch (MalformedURLException e) {
                            SignedBundleHook.log(e.getMessage(), 2, e);
                            break block20;
                        }
                        catch (IOException iOException) {
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                break block21;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processKeystoreFromString(String content, URL rootURL) {
        String keyStoreType = null;
        int indexOfSpace = content.indexOf(32);
        if (indexOfSpace == -1) {
            return;
        }
        int secondSpace = content.lastIndexOf(44);
        if (secondSpace == -1) {
            secondSpace = content.length();
        } else {
            keyStoreType = content.substring(secondSpace + 1, content.length()).trim();
        }
        this.processKeyStore(content.substring(indexOfSpace, secondSpace), keyStoreType, rootURL);
    }

    public boolean isTrusted(Certificate cert) {
        for (KeyStore ks : this.keyStores) {
            try {
                if (ks.getCertificateAlias(cert) == null) continue;
                return true;
            }
            catch (KeyStoreException e) {
                SignedBundleHook.log(e.getMessage(), 2, e);
            }
        }
        return false;
    }
}

