/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.message;

import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.message.FaultCode;
import com.sun.xml.internal.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.internal.ws.encoding.soap.message.FaultReason;
import com.sun.xml.internal.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.internal.ws.encoding.soap.message.FaultSubcode;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Node;

public class SOAP12FaultInfo
extends SOAPFaultInfo {
    private FaultCode code;
    private FaultReason reason;
    private String node;
    private String role;
    private Object detail;

    public SOAP12FaultInfo(FaultCode faultCode, FaultReason faultReason, String string, String string2, Object object) {
        this.code = faultCode;
        this.reason = faultReason;
        this.node = string;
        this.role = string2;
        this.detail = object;
        this.soapFault = SOAPUtil.createSOAPFault("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        this.setFaultCode();
        this.setFaultReason();
        this.setFaultNode();
        this.setFaultRole();
        if (object != null && object instanceof Detail) {
            Node node = this.soapFault.getOwnerDocument().importNode((Detail)object, true);
            this.soapFault.appendChild(node);
        } else {
            this.faultBean = object != null ? (JAXBBridgeInfo)object : null;
        }
    }

    public SOAP12FaultInfo(SOAPFault sOAPFault) {
        this.soapFault = sOAPFault;
        QName qName = this.soapFault.getFaultCodeAsQName();
        Iterator iterator = this.soapFault.getFaultSubcodes();
        this.code = new FaultCode(FaultCodeEnum.get(qName), iterator);
        try {
            ArrayList<FaultReasonText> arrayList = new ArrayList<FaultReasonText>();
            iterator = this.soapFault.getFaultReasonLocales();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                String string = this.soapFault.getFaultReasonText(locale);
                arrayList.add(new FaultReasonText(string, locale));
            }
            this.reason = new FaultReason(arrayList);
            this.node = this.soapFault.getFaultNode();
            this.role = this.soapFault.getFaultRole();
            this.detail = this.soapFault.getDetail();
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
        }
    }

    public FaultCode getFaultCode() {
        return this.code;
    }

    public FaultReason getReasons() {
        return this.reason;
    }

    public String getNode() {
        return this.node;
    }

    public String getRole() {
        return this.role;
    }

    private void setFaultRole() {
        if (this.soapFault == null || this.role == null) {
            return;
        }
        try {
            this.soapFault.setFaultRole(this.role);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    private void setFaultNode() {
        if (this.soapFault == null || this.node == null) {
            return;
        }
        try {
            this.soapFault.setFaultNode(this.node);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    private void setFaultReason() {
        if (this.soapFault == null || this.reason == null) {
            return;
        }
        List<FaultReasonText> list = this.reason.getFaultReasonTexts();
        for (FaultReasonText faultReasonText : list) {
            try {
                this.soapFault.addFaultReasonText(faultReasonText.getValue(), faultReasonText.getLanguage());
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }
    }

    private void setFaultCode() {
        if (this.soapFault == null || this.code == null) {
            return;
        }
        try {
            this.soapFault.setFaultCode(this.code.getValue().value());
            for (FaultSubcode faultSubcode = this.code.getSubcode(); faultSubcode != null; faultSubcode = faultSubcode.getSubcode()) {
                this.soapFault.appendFaultSubcode(faultSubcode.getValue());
            }
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    public void write(XMLStreamWriter xMLStreamWriter, MessageInfo messageInfo) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", SOAP12Constants.QNAME_SOAP_FAULT.getLocalPart(), SOAP12Constants.QNAME_SOAP_FAULT.getNamespaceURI());
            xMLStreamWriter.writeNamespace("soapenv", SOAP12Constants.QNAME_SOAP_FAULT.getNamespaceURI());
            this.code.write(xMLStreamWriter);
            this.reason.write(xMLStreamWriter);
            if (this.node != null) {
                xMLStreamWriter.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_NODE.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
                xMLStreamWriter.writeCharacters(this.node);
                xMLStreamWriter.writeEndElement();
            }
            if (this.role != null) {
                xMLStreamWriter.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_ROLE.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
                xMLStreamWriter.writeCharacters(this.role);
                xMLStreamWriter.writeEndElement();
            }
            if (this.detail != null) {
                if (this.detail instanceof Detail) {
                    SOAPEncoder.serializeReader(new DOMStreamReader((Detail)this.detail), xMLStreamWriter);
                } else if (this.detail instanceof JAXBBridgeInfo) {
                    this.startDetailElement(xMLStreamWriter);
                    RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
                    BridgeContext bridgeContext = runtimeContext.getBridgeContext();
                    ((JAXBBridgeInfo)this.detail).serialize(bridgeContext, xMLStreamWriter);
                    xMLStreamWriter.writeEndElement();
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException(xMLStreamException);
        }
    }

    private void startDetailElement(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_DETAIL.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
    }
}

