/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.xml.client;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.AsyncHandlerService;
import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.client.ContextMap;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.WSFuture;
import com.sun.xml.internal.ws.client.dispatch.DispatchContext;
import com.sun.xml.internal.ws.client.dispatch.ResponseImpl;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.client.SOAP12XMLEncoder;
import com.sun.xml.internal.ws.encoding.soap.client.SOAPXMLEncoder;
import com.sun.xml.internal.ws.encoding.soap.internal.MessageInfoBase;
import com.sun.xml.internal.ws.encoding.xml.XMLEncoder;
import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.handler.HandlerChainCaller;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.handler.XMLHandlerContext;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.pept.ept.EPTFactory;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.spi.runtime.ClientTransportFactory;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.transport.http.client.HttpClientTransportFactory;
import com.sun.xml.internal.ws.util.Base64Util;
import com.sun.xml.internal.ws.util.XMLConnectionUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMessageDispatcher
implements MessageDispatcher {
    protected static final int MAX_THREAD_POOL_SIZE = 3;
    protected static final long AWAIT_TERMINATION_TIME = 10L;
    protected ExecutorService executorService = null;

    @Override
    public void send(MessageInfo messageInfo) {
        if (this.isAsync(messageInfo)) {
            this.doSendAsync(messageInfo);
        } else {
            this.doSend(messageInfo);
        }
    }

    protected XMLMessage doSend(MessageInfo messageInfo) {
        EPTFactory ePTFactory = messageInfo.getEPTFactory();
        XMLEncoder xMLEncoder = (XMLEncoder)ePTFactory.getEncoder(messageInfo);
        boolean bl = true;
        boolean bl2 = messageInfo.getMEP() == 1;
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
        if (!this.isHTTPMessageType(dispatchContext)) {
            throw new WebServiceException("Mode not allowed with HTTP Binding. Must use other Service.mode");
        }
        XMLMessage xMLMessage = this.makeXMLMessage(messageInfo);
        try {
            Object object;
            HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(messageInfo);
            if (handlerChainCaller.hasHandlers()) {
                object = new XMLHandlerContext(messageInfo, null, xMLMessage);
                this.updateMessageContext(messageInfo, (XMLHandlerContext)object);
                bl = this.callHandlersOnRequest((XMLHandlerContext)object);
                this.updateXMLMessage((XMLHandlerContext)object);
                xMLMessage = ((XMLHandlerContext)object).getXMLMessage();
                if (xMLMessage == null) {
                    xMLMessage = xMLEncoder.toXMLMessage(((HandlerContext)object).getInternalMessage(), messageInfo);
                }
                if (bl2 && !bl) {
                    return xMLMessage;
                }
            }
            object = this.processMetadata(messageInfo, xMLMessage);
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            Object object2 = xMLMessage.getMimeHeaders().getAllHeaders();
            while (object2.hasNext()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                MimeHeader mimeHeader = (MimeHeader)object2.next();
                arrayList.clear();
                arrayList.add(mimeHeader.getValue());
                hashMap.put(mimeHeader.getName(), arrayList);
            }
            this.setConnection(messageInfo, (Map<String, Object>)object);
            messageInfo.getConnection().setHeaders(hashMap);
            if (!this.isAsync(messageInfo)) {
                object2 = messageInfo.getConnection();
                XMLConnectionUtil.sendResponse((WSConnection)object2, xMLMessage);
            }
            if (bl2 && bl) {
                this.receive(messageInfo);
                this.postReceiveHook(messageInfo);
            }
        }
        catch (Throwable throwable) {
            this.setResponseType(throwable, messageInfo);
            messageInfo.setResponse(throwable);
        }
        return xMLMessage;
    }

    protected Map<String, Object> processMetadata(MessageInfo messageInfo, XMLMessage xMLMessage) {
        JavaMethod javaMethod;
        Object object;
        Object object2;
        String string;
        Object object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        ContextMap contextMap = (ContextMap)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
        if (this.isHTTPMessageType(dispatchContext)) {
            this.setHTTPContext(hashMap, dispatchContext, contextMap);
        }
        if (messageInfo.getMEP() == 2) {
            hashMap.put("com.sun.xml.internal.ws.server.OneWayOperation", "true");
        }
        if (contextMap != null) {
            object3 = contextMap.getPropertyNames();
            while (object3.hasNext()) {
                string = (String)object3.next();
                if (string.equals(ClientTransportFactory.class.getName())) {
                    hashMap.put("com.sun.xml.internal.ws.client.ClientTransportFactory", (ClientTransportFactory)contextMap.get(string));
                    continue;
                }
                if (string.equals("javax.xml.ws.security.auth.username")) {
                    object2 = (String)contextMap.get("javax.xml.ws.security.auth.username");
                    if (object2 == null) continue;
                    object2 = (String)object2 + ":";
                    object = (String)contextMap.get("javax.xml.ws.security.auth.password");
                    if (object != null) {
                        object2 = (String)object2 + (String)object;
                    }
                    try {
                        object2 = Base64Util.encode(((String)object2).getBytes());
                    }
                    catch (Exception exception) {
                        throw new WebServiceException(exception);
                    }
                    xMLMessage.getMimeHeaders().addHeader("Authorization", "Basic " + (String)object2);
                    continue;
                }
                if (string.equals("javax.xml.ws.session.maintain")) {
                    object2 = contextMap.get("javax.xml.ws.session.maintain");
                    if (object2 == null || !object2.equals(Boolean.TRUE) || (object = contextMap.get("com.sun.xml.internal.ws.client.http.CookieJar")) == null) continue;
                    hashMap.put("com.sun.xml.internal.ws.client.http.CookieJar", object);
                    continue;
                }
                hashMap.put(string, contextMap.get(string));
            }
        }
        object3 = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        string = this.getBindingId(messageInfo);
        if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            xMLMessage.getMimeHeaders().addHeader("Accept", object3 != "none" ? "application/soap+fastinfoset, application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        } else {
            xMLMessage.getMimeHeaders().addHeader("Accept", object3 != "none" ? "application/fastinfoset, text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        object2 = (Map)contextMap.get("javax.xml.ws.http.request.headers");
        this.setMimeHeaders((Map<String, List<String>>)object2, xMLMessage);
        hashMap.put("com.sun.xml.internal.ws.binding", string);
        object = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (object != null && (javaMethod = ((RuntimeContext)object).getModel().getJavaMethod(messageInfo.getMethod())) != null) {
            String string2 = ((SOAPBinding)javaMethod.getBinding()).getSOAPAction();
            arrayList.clear();
            if (string2 == null) {
                xMLMessage.getMimeHeaders().addHeader("SOAPAction", "\"\"");
            } else {
                xMLMessage.getMimeHeaders().addHeader("SOAPAction", string2);
            }
        }
        return hashMap;
    }

    protected void setConnection(MessageInfo messageInfo, Map<String, Object> map) {
        ClientTransportFactory clientTransportFactory = (ClientTransportFactory)map.get("com.sun.xml.internal.ws.client.ClientTransportFactory");
        WSConnection wSConnection = null;
        if (clientTransportFactory == null) {
            clientTransportFactory = new HttpClientTransportFactory();
        }
        wSConnection = clientTransportFactory.create(map);
        messageInfo.setConnection(wSConnection);
    }

    protected void setResponseType(Throwable throwable, MessageInfo messageInfo) {
        if (throwable instanceof RuntimeException) {
            messageInfo.setResponseType(2);
            if (throwable instanceof ClientTransportException) {
                Throwable throwable2 = throwable;
                throwable = new WebServiceException(throwable2.getMessage(), throwable2);
            }
        } else {
            messageInfo.setResponseType(1);
        }
        messageInfo.setResponse(throwable);
    }

    @Override
    public void receive(MessageInfo messageInfo) {
        Object object;
        EPTFactory ePTFactory = messageInfo.getEPTFactory();
        XMLMessage xMLMessage = this.getXMLMessage(messageInfo);
        String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (string == "pessimistic") {
            try {
                if (xMLMessage.isFastInfoset()) {
                    object = (Map)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
                    object.put("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        object = this.getInboundHandlerContext(messageInfo, xMLMessage);
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(messageInfo);
        if (handlerChainCaller.hasHandlers()) {
            this.callHandlersOnResponse((XMLHandlerContext)object);
            xMLMessage = ((XMLHandlerContext)object).getXMLMessage();
        }
        this.setResponse(messageInfo, xMLMessage, (HandlerContext)object);
    }

    private void setResponse(MessageInfo messageInfo, XMLMessage xMLMessage, HandlerContext handlerContext) {
        block8: {
            block7: {
                Map<String, DataHandler> map = this.getAttachments(handlerContext, xMLMessage);
                this.updateResponseContext(messageInfo, (XMLHandlerContext)handlerContext, map);
                DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
                DispatchContext.MessageType messageType = (DispatchContext.MessageType)((Object)dispatchContext.getProperty("com.sun.xml.internal.ws.rt.client.dispatch.messagetype"));
                if (messageType == null) break block7;
                switch (messageType) {
                    case HTTP_SOURCE_MESSAGE: {
                        messageInfo.setResponse(xMLMessage.getSource());
                        break block8;
                    }
                    case HTTP_SOURCE_PAYLOAD: {
                        messageInfo.setResponse(xMLMessage.getSource());
                        break block8;
                    }
                    case HTTP_JAXB_PAYLOAD: {
                        messageInfo.setResponse(xMLMessage.getPayload(this.getJAXBContext(messageInfo)));
                        break block8;
                    }
                    case HTTP_DATASOURCE_MESSAGE: {
                        if (xMLMessage.getDataSource() != null) {
                            messageInfo.setResponse(xMLMessage.getDataSource());
                        }
                        break block8;
                    }
                    default: {
                        throw new WebServiceException("Unknown invocation return object ");
                    }
                }
            }
            throw new WebServiceException("Unknown invocation return object");
        }
    }

    private Map<String, DataHandler> getAttachments(HandlerContext handlerContext, XMLMessage xMLMessage) {
        Map map = (Map)handlerContext.getMessageContext().get("javax.xml.ws.binding.attachments.inbound");
        Map<String, DataHandler> map2 = xMLMessage.getAttachments();
        HashMap<String, DataHandler> hashMap = new HashMap<String, DataHandler>();
        if (map2 != null && map != null) {
            hashMap.putAll(map2);
            hashMap.putAll(map);
        } else if (map2 != null) {
            hashMap.putAll(map2);
        } else if (map != null) {
            hashMap.putAll(map);
        } else {
            hashMap = null;
            return null;
        }
        return hashMap;
    }

    private XMLHandlerContext getInboundHandlerContext(MessageInfo messageInfo, XMLMessage xMLMessage) {
        XMLHandlerContext xMLHandlerContext = (XMLHandlerContext)messageInfo.getMetaData("com.sun.xml.internal.ws.handler.context");
        if (xMLHandlerContext != null) {
            xMLHandlerContext.setXMLMessage(xMLMessage);
            xMLHandlerContext.setInternalMessage(null);
        } else {
            xMLHandlerContext = new XMLHandlerContext(messageInfo, null, xMLMessage);
        }
        return xMLHandlerContext;
    }

    protected void doSendAsync(MessageInfo messageInfo) {
        try {
            this.preSendHook(messageInfo);
            XMLMessage xMLMessage = this.doSend(messageInfo);
            this.postSendHook(messageInfo);
            Response<Object> response = this.sendAsyncReceive(MessageInfoBase.copy(messageInfo), xMLMessage);
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
            }
            AsyncHandlerService asyncHandlerService = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.asynchandler");
            WSFuture<Object> wSFuture = null;
            if (asyncHandlerService != null) {
                wSFuture = asyncHandlerService.setupAsyncCallback(response);
                ((ResponseImpl)response).setUID(asyncHandlerService.getUID());
                ((ResponseImpl)response).setHandlerService(asyncHandlerService);
            }
            this.executorService.execute((FutureTask)((Object)response));
            if (asyncHandlerService == null) {
                messageInfo.setResponse(response);
            } else {
                messageInfo.setResponse(wSFuture);
            }
        }
        catch (Throwable throwable) {
            messageInfo.setResponse(throwable);
        }
    }

    protected Response<Object> sendAsyncReceive(final MessageInfo messageInfo, final XMLMessage xMLMessage) {
        boolean bl;
        AsyncHandlerService asyncHandlerService = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.asynchandler");
        boolean bl2 = bl = messageInfo.getMEP() == 4;
        if (bl && asyncHandlerService == null) {
            throw new WebServiceException("Asynchronous callback invocation, but no handler - AsyncHandler required");
        }
        ResponseImpl<Object> responseImpl = new ResponseImpl<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    WSConnection wSConnection = messageInfo.getConnection();
                    XMLConnectionUtil.sendResponse(wSConnection, xMLMessage);
                }
                catch (Throwable throwable) {
                    messageInfo.setResponse(throwable);
                    messageInfo.setResponseType(2);
                }
                XMLMessageDispatcher.this.preReceiveHook(messageInfo);
                try {
                    XMLMessageDispatcher.this.receive(messageInfo);
                }
                catch (Exception exception) {
                    messageInfo.setResponse(exception);
                }
                XMLMessageDispatcher.this.postReceiveHook(messageInfo);
                if (messageInfo.getResponse() instanceof Exception) {
                    throw (Exception)messageInfo.getResponse();
                }
                return messageInfo.getResponse();
            }
        });
        messageInfo.setMetaData("com.sun.xml.internal.ws.client.dispatch.async.response.context", responseImpl);
        return responseImpl;
    }

    protected boolean callHandlersOnRequest(XMLHandlerContext xMLHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(xMLHandlerContext.getMessageInfo());
        boolean bl = xMLHandlerContext.getMessageInfo().getMEP() != 2;
        try {
            return handlerChainCaller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, xMLHandlerContext, bl);
        }
        catch (ProtocolException protocolException) {
            if (MessageContextUtil.ignoreFaultInMessage(xMLHandlerContext.getMessageContext())) {
                throw protocolException;
            }
            return false;
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }

    protected boolean callHandlersOnResponse(XMLHandlerContext xMLHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(xMLHandlerContext.getMessageInfo());
        try {
            return handlerChainCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, xMLHandlerContext, false);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }

    protected Binding getBinding(MessageInfo messageInfo) {
        ContextMap contextMap = (ContextMap)((MessageInfoBase)messageInfo).getMetaData("com.sun.xml.internal.ws.context.request");
        BindingProvider bindingProvider = (BindingProvider)contextMap.get("com.sun.xml.internal.ws.client.handle");
        return bindingProvider.getBinding();
    }

    protected HandlerChainCaller getHandlerChainCaller(MessageInfo messageInfo) {
        BindingImpl bindingImpl = (BindingImpl)this.getBinding(messageInfo);
        return bindingImpl.getHandlerChainCaller();
    }

    protected void updateMessageContext(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        MessageContext messageContext = xMLHandlerContext.getMessageContext();
        messageInfo.setMetaData("com.sun.xml.internal.ws.handler.context", xMLHandlerContext);
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        Iterator<String> iterator = requestContext.copy().getPropertyNames();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Object object = requestContext.get(string);
            messageContext.put(string, object);
        }
    }

    protected void updateResponseContext(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext, Map<String, DataHandler> map) {
        Object object;
        Object object2;
        Object object32;
        MessageContext messageContext = xMLHandlerContext.getMessageContext();
        BindingProvider bindingProvider = (BindingProvider)messageContext.get("com.sun.xml.internal.ws.client.handle");
        ResponseContext responseContext = new ResponseContext(bindingProvider);
        for (Object object32 : messageContext.keySet()) {
            object2 = messageContext.getScope((String)object32);
            if (MessageContext.Scope.APPLICATION != object2) continue;
            object = messageContext.get(object32);
            responseContext.put((String)object32, object);
        }
        MessageContext messageContext2 = xMLHandlerContext.getMessageContext();
        object32 = messageInfo.getConnection();
        object2 = object32.getHeaders();
        responseContext.put("javax.xml.ws.http.response.headers", object2);
        responseContext.put("javax.xml.ws.http.response.code", (Object)object32.getStatus());
        if (map != null) {
            responseContext.put("javax.xml.ws.binding.attachments.inbound", (Object)map);
        }
        if ((object = (ResponseImpl)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.async.response.context")) != null) {
            ((ResponseImpl)object).setResponseContext(responseContext.copy());
        } else {
            messageInfo.setMetaData("com.sun.xml.internal.ws.context.response", responseContext.copy());
        }
    }

    protected boolean isAsync(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 3 || messageInfo.getMEP() == 4;
    }

    private void preSendHook(MessageInfo messageInfo) {
    }

    private void preReceiveHook(MessageInfo messageInfo) {
    }

    private void postSendHook(MessageInfo messageInfo) {
        if (messageInfo.getResponseType() != 0) {
            this.postReceiveHook(messageInfo);
            throw (WebServiceException)messageInfo.getResponse();
        }
    }

    private void postReceiveAndDecodeHook(MessageInfo messageInfo) {
    }

    private void postReceiveHook(MessageInfo messageInfo) {
        InputStream inputStream;
        if (messageInfo.getMEP() == 2) {
            return;
        }
        Object object = messageInfo.getResponse();
        if (object instanceof StreamSource) {
            inputStream = ((StreamSource)object).getInputStream();
            Transformer transformer = XmlUtil.newTransformer();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
                if (byteArrayOutputStream.size() > 0) {
                    transformer.transform((StreamSource)object, new StreamResult(byteArrayOutputStream));
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    if (new String(byArray).indexOf("HTTPException") > -1) {
                        throw new HTTPException(500);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    messageInfo.setResponse(new StreamSource(byteArrayInputStream));
                }
            }
            catch (TransformerException transformerException) {
                throw new WebServiceException(transformerException);
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
        }
        switch (messageInfo.getResponseType()) {
            case 0: {
                return;
            }
            case 1: {
                if (object instanceof Exception) {
                    throw new HTTPException(500);
                }
                return;
            }
            case 2: {
                if (object instanceof ProtocolException) {
                    throw new HTTPException(500);
                }
                inputStream = null;
                if (object instanceof Exception) {
                    throw new WebServiceException((Exception)object);
                }
                messageInfo.setResponse(object);
                return;
            }
        }
        messageInfo.setResponse(object);
    }

    private void closeAllHandlers(XMLHandlerContext xMLHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(xMLHandlerContext.getMessageInfo());
        if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
            handlerChainCaller.forceCloseHandlersOnClient(xMLHandlerContext);
        }
    }

    protected String getBindingId(MessageInfo messageInfo) {
        SOAPEncoder sOAPEncoder = (SOAPEncoder)messageInfo.getEncoder();
        if (sOAPEncoder instanceof SOAPXMLEncoder) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (sOAPEncoder instanceof SOAP12XMLEncoder) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return "http://www.w3.org/2004/08/wsdl/http";
    }

    protected void logRequestMessage(XMLMessage xMLMessage, MessageInfo messageInfo) throws IOException, MessagingException, TransformerException {
        OutputStream outputStream = messageInfo.getConnection().getDebug();
        if (outputStream != null) {
            String string = "******************\nRequest\n";
            outputStream.write(string.getBytes());
            Iterator iterator = xMLMessage.getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                string = mimeHeader.getName() + ": " + mimeHeader.getValue() + "\n";
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
            xMLMessage.writeTo(outputStream);
            string = "\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
    }

    protected void logResponseMessage(XMLMessage xMLMessage, MessageInfo messageInfo) throws IOException, MessagingException, TransformerException {
        OutputStream outputStream = messageInfo.getConnection().getDebug();
        if (outputStream != null) {
            String string = "Response\n";
            outputStream.write(string.getBytes());
            string = "Http Status Code: " + messageInfo.getConnection().getStatus() + "\n\n";
            outputStream.write(string.getBytes());
            Iterator iterator = xMLMessage.getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                string = mimeHeader.getName() + ": " + mimeHeader.getValue() + "\n";
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
            xMLMessage.writeTo(outputStream);
            string = "******************\n\n";
            outputStream.write(string.getBytes());
        }
    }

    private XMLMessage getXMLMessage(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        return XMLConnectionUtil.getXMLMessage(wSConnection, messageInfo);
    }

    protected JAXBContext getJAXBContext(MessageInfo messageInfo) {
        JAXBContext jAXBContext = null;
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        if (requestContext != null) {
            jAXBContext = (JAXBContext)requestContext.get("com.sun.xml.internal.ws.jaxbcontext");
        }
        return jAXBContext;
    }

    public void setHTTPContext(Map<String, Object> map, DispatchContext dispatchContext, Map map2) {
        if (map2.get("javax.xml.ws.http.request.method") != null) {
            map.put("javax.xml.ws.http.request.method", map2.get("javax.xml.ws.http.request.method"));
        }
        if (map2.get("javax.xml.ws.http.request.headers") != null) {
            map.put("javax.xml.ws.http.request.headers", map2.get("javax.xml.ws.http.request.headers"));
        }
        String string = (String)map2.get("javax.xml.ws.service.endpoint.address");
        String string2 = null;
        String string3 = null;
        if (map2.get("javax.xml.ws.http.request.pathinfo") != null) {
            string2 = (String)map2.get("javax.xml.ws.http.request.pathinfo");
        }
        if (map2.get("javax.xml.ws.http.request.querystring") != null) {
            string3 = (String)map2.get("javax.xml.ws.http.request.querystring");
        }
        String string4 = null;
        if (string2 != null || string3 != null) {
            string2 = this.checkPath(string2);
            string3 = this.checkQuery(string3);
            if (string != null) {
                try {
                    URI uRI = new URI(string);
                    string4 = this.resolveURI(uRI, string2, string3);
                }
                catch (URISyntaxException uRISyntaxException) {
                    string4 = string;
                }
            }
            map2.put("javax.xml.ws.service.endpoint.address", string4);
            map.put("javax.xml.ws.service.endpoint.address", string4);
        }
    }

    protected String resolveURI(URI uRI, String string, String string2) {
        Object object;
        String string3 = null;
        String string4 = null;
        if (string2 != null) {
            object = uRI.resolve(string2);
            string3 = ((URI)object).getQuery();
            string4 = ((URI)object).getFragment();
        }
        object = string != null ? string : uRI.getPath();
        try {
            URI uRI2 = new URI(null, null, (String)object, string3, string4);
            return uRI.resolve(uRI2).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return uRI.toString();
        }
    }

    private String checkPath(String string) {
        return string == null || string.startsWith("/") ? string : "/" + string;
    }

    private String checkQuery(String string) {
        return string == null || string.startsWith("?") ? string : "?" + string;
    }

    protected boolean isHTTPMessageType(DispatchContext dispatchContext) {
        DispatchContext.MessageType messageType = (DispatchContext.MessageType)((Object)dispatchContext.getProperty("com.sun.xml.internal.ws.rt.client.dispatch.messagetype"));
        return messageType == DispatchContext.MessageType.HTTP_DATASOURCE_MESSAGE || messageType == DispatchContext.MessageType.HTTP_SOURCE_MESSAGE || messageType == DispatchContext.MessageType.HTTP_SOURCE_PAYLOAD || messageType == DispatchContext.MessageType.HTTP_JAXB_PAYLOAD;
    }

    protected XMLMessage makeXMLMessage(MessageInfo messageInfo) {
        XMLMessage xMLMessage = null;
        Class clazz = (Class)messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.messageclass");
        Map map = (Map)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        Map map2 = map != null ? (Map)map.get("javax.xml.ws.binding.attachments.outbound") : null;
        boolean bl = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic";
        Object object = messageInfo.getData()[0];
        xMLMessage = clazz != null && clazz.isAssignableFrom(Source.class) ? new XMLMessage((Source)object, map2, bl) : (clazz != null && clazz.isAssignableFrom(DataSource.class) ? new XMLMessage((DataSource)object, bl) : new XMLMessage(object, this.getJAXBContext(messageInfo), map2, bl));
        return xMLMessage;
    }

    private void setMimeHeaders(Map<String, List<String>> map, XMLMessage xMLMessage) {
        if (map != null && !map.isEmpty()) {
            Set<Map.Entry<String, List<String>>> set = map.entrySet();
            for (Map.Entry<String, List<String>> entry : set) {
                MimeHeaders mimeHeaders = xMLMessage.getMimeHeaders();
                String[] stringArray = entry.getValue().toArray(new String[entry.getValue().size()]);
                StringBuffer stringBuffer = new StringBuffer(250);
                if (stringArray.length <= 0) break;
                stringBuffer.append(stringArray[0]);
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    stringBuffer.append(stringArray[i]);
                }
                mimeHeaders.addHeader(entry.getKey(), stringBuffer.toString());
            }
        }
    }

    private XMLMessage updateXMLMessage(XMLHandlerContext xMLHandlerContext) {
        XMLMessage xMLMessage;
        MessageContext messageContext = xMLHandlerContext.getMessageContext();
        Map map = (Map)messageContext.get("javax.xml.ws.binding.attachments.outbound");
        if (map != null && (xMLMessage = xMLHandlerContext.getXMLMessage()) != null) {
            Map map2 = xMLMessage.getAttachments();
            if (map2 != null) {
                map2.putAll(map);
            } else {
                map2 = map;
            }
            xMLHandlerContext.setXMLMessage(new XMLMessage(xMLMessage.getSource(), map2, xMLMessage.isFastInfoset()));
        }
        return xMLHandlerContext.getXMLMessage();
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(Boolean.TRUE);
            return thread;
        }
    }
}

