/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteArrayBuffer
extends OutputStream {
    private byte[] buf;
    private int count;

    public ByteArrayBuffer() {
        this(32);
    }

    public ByteArrayBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
    }

    public ByteArrayBuffer(byte[] byArray) {
        this.buf = byArray;
    }

    public void write(InputStream inputStream) throws IOException {
        int n;
        int n2;
        while ((n2 = inputStream.read(this.buf, this.count, n = this.buf.length - this.count)) >= 0) {
            this.count += n2;
            if (n != n2) continue;
            this.ensureCapacity(this.buf.length * 2);
        }
        return;
    }

    public void write(int n) {
        int n2 = this.count + 1;
        this.ensureCapacity(n2);
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        this.ensureCapacity(n3);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    private void ensureCapacity(int n) {
        if (n > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public void close() {
    }

    public InputStream newInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public InputStream newInputStream(int n, int n2) {
        return new ByteArrayInputStream(this.buf, n, n2);
    }
}

