/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import sun.misc.SharedSecrets;
import sun.reflect.ConstructorAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.scope.ConstructorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class<T> clazz;
    private int slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient ConstructorRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private volatile Class securityCheckCache;
    private static final int LANGUAGE_MODIFIERS = 7;
    private volatile ConstructorAccessor constructorAccessor;
    private Constructor<T> root;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private transient Map<Class, Annotation> declaredAnnotations;

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ConstructorScope.make(this));
    }

    private ConstructorRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = ConstructorRepository.make(this.getSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Constructor(Class<T> clazz, Class[] classArray, Class[] classArray2, int n, int n2, String string, byte[] byArray, byte[] byArray2) {
        this.clazz = clazz;
        this.parameterTypes = classArray;
        this.exceptionTypes = classArray2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string;
        this.annotations = byArray;
        this.parameterAnnotations = byArray2;
    }

    Constructor<T> copy() {
        Constructor<T> constructor = new Constructor<T>(this.clazz, this.parameterTypes, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations);
        constructor.root = this;
        constructor.constructorAccessor = this.constructorAccessor;
        return constructor;
    }

    public Class<T> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        if (this.getSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Type[] getGenericParameterTypes() {
        if (this.getSignature() != null) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.getSignature() != null && (typeArray = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Constructor) {
            Class[] classArray;
            Class[] classArray2;
            Constructor constructor = (Constructor)object;
            if (this.getDeclaringClass() == constructor.getDeclaringClass() && (classArray2 = this.parameterTypes).length == (classArray = constructor.parameterTypes).length) {
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i] == classArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers() & 7;
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuffer.append("(");
            Class[] classArray = this.parameterTypes;
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public String toGenericString() {
        try {
            int n;
            TypeVariable<Constructor<T>>[] typeVariableArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.getModifiers() & 7;
            if (n2 != 0) {
                stringBuilder.append(Modifier.toString(n2) + " ");
            }
            if ((typeVariableArray = this.getTypeParameters()).length > 0) {
                boolean bl = true;
                stringBuilder.append("<");
                TypeVariable<Constructor<T>>[] typeVariableArray2 = typeVariableArray;
                n = typeVariableArray2.length;
                for (int i = 0; i < n; ++i) {
                    TypeVariable<Constructor<T>> typeVariable = typeVariableArray2[i];
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(typeVariable.toString());
                    bl = false;
                }
                stringBuilder.append("> ");
            }
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuilder.append("(");
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                String string;
                String string2 = string = typeArray[i] instanceof Class ? Field.getTypeName((Class)typeArray[i]) : typeArray[i].toString();
                if (this.isVarArgs() && i == typeArray.length - 1) {
                    string = string.replaceFirst("\\[\\]$", "...");
                }
                stringBuilder.append(string);
                if (i >= typeArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (n = 0; n < typeArray2.length; ++n) {
                    stringBuilder.append(typeArray2[n] instanceof Class ? ((Class)typeArray2[n]).getName() : typeArray2[n].toString());
                    if (n >= typeArray2.length - 1) continue;
                    stringBuilder.append(",");
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public T newInstance(Object ... objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class clazz;
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers) && this.securityCheckCache != (clazz = Reflection.getCallerClass(2))) {
            Reflection.ensureMemberAccess(clazz, this.clazz, null, this.modifiers);
            this.securityCheckCache = clazz;
        }
        if ((this.clazz.getModifiers() & 0x4000) != 0) {
            throw new IllegalArgumentException("Cannot reflectively create enum objects");
        }
        if (this.constructorAccessor == null) {
            this.acquireConstructorAccessor();
        }
        return (T)this.constructorAccessor.newInstance(objectArray);
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    private void acquireConstructorAccessor() {
        ConstructorAccessor constructorAccessor = null;
        if (this.root != null) {
            constructorAccessor = this.root.getConstructorAccessor();
        }
        if (constructorAccessor != null) {
            this.constructorAccessor = constructorAccessor;
            return;
        }
        constructorAccessor = reflectionFactory.newConstructorAccessor(this);
        this.setConstructorAccessor(constructorAccessor);
    }

    ConstructorAccessor getConstructorAccessor() {
        return this.constructorAccessor;
    }

    void setConstructorAccessor(ConstructorAccessor constructorAccessor) {
        this.constructorAccessor = constructorAccessor;
        if (this.root != null) {
            this.root.setConstructorAccessor(constructorAccessor);
        }
    }

    int getSlot() {
        return this.slot;
    }

    String getSignature() {
        return this.signature;
    }

    byte[] getRawAnnotations() {
        return this.annotations;
    }

    byte[] getRawParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations().values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    private synchronized Map<Class, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    public Annotation[][] getParameterAnnotations() {
        Class<T> clazz;
        int n = this.parameterTypes.length;
        if (this.parameterAnnotations == null) {
            return new Annotation[n][0];
        }
        Annotation[][] annotationArray = AnnotationParser.parseParameterAnnotations(this.parameterAnnotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (!(annotationArray.length == n || (clazz = this.getDeclaringClass()).isEnum() || clazz.isAnonymousClass() || clazz.isLocalClass() || clazz.isMemberClass() && (!clazz.isMemberClass() || (clazz.getModifiers() & 8) != 0 || annotationArray.length + 1 == n))) {
            throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
        }
        return annotationArray;
    }
}

