/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Base64;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.prefs.XmlSupport;
import sun.security.action.GetPropertyAction;

class FileSystemPreferences
extends AbstractPreferences {
    private static final int SYNC_INTERVAL = Math.max(1, Integer.parseInt(AccessController.doPrivileged(new GetPropertyAction("java.util.prefs.syncInterval", "30"))));
    private static File systemRootDir;
    private static boolean isSystemRootWritable;
    private static File userRootDir;
    private static boolean isUserRootWritable;
    static Preferences userRoot;
    static Preferences systemRoot;
    private static final int USER_READ_WRITE = 384;
    private static final int USER_RW_ALL_READ = 420;
    private static final int USER_RWX_ALL_RX = 493;
    private static final int USER_RWX = 448;
    static File userLockFile;
    static File systemLockFile;
    private static int userRootLockHandle;
    private static int systemRootLockHandle;
    private final File dir;
    private final File prefsFile;
    private final File tmpFile;
    private static File userRootModFile;
    private static boolean isUserRootModified;
    private static long userRootModTime;
    private static File systemRootModFile;
    private static boolean isSystemRootModified;
    private static long systemRootModTime;
    private Map<String, String> prefsCache = null;
    private long lastSyncTime = 0L;
    private static final int EAGAIN = 11;
    private static final int EACCES = 13;
    private static final int LOCK_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    final List<Change> changeLog = new ArrayList<Change>();
    NodeCreate nodeCreate = null;
    private static Timer syncTimer;
    private final boolean isUserNode;
    private static final String[] EMPTY_STRING_ARRAY;
    private static int INIT_SLEEP_TIME;
    private static int MAX_ATTEMPTS;

    private static Logger getLogger() {
        return Logger.getLogger("java.util.prefs");
    }

    static synchronized Preferences getUserRoot() {
        if (userRoot == null) {
            FileSystemPreferences.setupUserRoot();
            userRoot = new FileSystemPreferences(true);
        }
        return userRoot;
    }

    private static void setupUserRoot() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                userRootDir = new File(System.getProperty("java.util.prefs.userRoot", System.getProperty("user.home")), ".java/.userPrefs");
                if (!userRootDir.exists()) {
                    if (userRootDir.mkdirs()) {
                        try {
                            FileSystemPreferences.chmod(userRootDir.getCanonicalPath(), 448);
                        }
                        catch (IOException iOException) {
                            FileSystemPreferences.getLogger().warning("Could not change permissions on userRoot directory. ");
                        }
                        FileSystemPreferences.getLogger().info("Created user preferences directory.");
                    } else {
                        FileSystemPreferences.getLogger().warning("Couldn't create user preferences directory. User preferences are unusable.");
                    }
                }
                isUserRootWritable = userRootDir.canWrite();
                String string = System.getProperty("user.name");
                userLockFile = new File(userRootDir, ".user.lock." + string);
                userRootModFile = new File(userRootDir, ".userRootModFile." + string);
                if (!userRootModFile.exists()) {
                    try {
                        userRootModFile.createNewFile();
                        int n = FileSystemPreferences.chmod(userRootModFile.getCanonicalPath(), 384);
                        if (n != 0) {
                            FileSystemPreferences.getLogger().warning("Problem creating userRoot mod file. Chmod failed on " + userRootModFile.getCanonicalPath() + " Unix error code " + n);
                        }
                    }
                    catch (IOException iOException) {
                        FileSystemPreferences.getLogger().warning(iOException.toString());
                    }
                }
                userRootModTime = userRootModFile.lastModified();
                return null;
            }
        });
    }

    static synchronized Preferences getSystemRoot() {
        if (systemRoot == null) {
            FileSystemPreferences.setupSystemRoot();
            systemRoot = new FileSystemPreferences(false);
        }
        return systemRoot;
    }

    private static void setupSystemRoot() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String string = System.getProperty("java.util.prefs.systemRoot", "/etc/.java");
                systemRootDir = new File(string, ".systemPrefs");
                if (!systemRootDir.exists()) {
                    systemRootDir = new File(System.getProperty("java.home"), ".systemPrefs");
                    if (!systemRootDir.exists()) {
                        if (systemRootDir.mkdirs()) {
                            FileSystemPreferences.getLogger().info("Created system preferences directory in java.home.");
                            try {
                                FileSystemPreferences.chmod(systemRootDir.getCanonicalPath(), 493);
                            }
                            catch (IOException iOException) {}
                        } else {
                            FileSystemPreferences.getLogger().warning("Could not create system preferences directory. System preferences are unusable.");
                        }
                    }
                }
                isSystemRootWritable = systemRootDir.canWrite();
                systemLockFile = new File(systemRootDir, ".system.lock");
                systemRootModFile = new File(systemRootDir, ".systemRootModFile");
                if (!systemRootModFile.exists() && isSystemRootWritable) {
                    try {
                        systemRootModFile.createNewFile();
                        int n = FileSystemPreferences.chmod(systemRootModFile.getCanonicalPath(), 420);
                        if (n != 0) {
                            FileSystemPreferences.getLogger().warning("Chmod failed on " + systemRootModFile.getCanonicalPath() + " Unix error code " + n);
                        }
                    }
                    catch (IOException iOException) {
                        FileSystemPreferences.getLogger().warning(iOException.toString());
                    }
                }
                systemRootModTime = systemRootModFile.lastModified();
                return null;
            }
        });
    }

    private void replayChanges() {
        int n = this.changeLog.size();
        for (int i = 0; i < n; ++i) {
            this.changeLog.get(i).replay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncWorld() {
        Class<FileSystemPreferences> clazz = FileSystemPreferences.class;
        synchronized (FileSystemPreferences.class) {
            Preferences preferences = userRoot;
            Preferences preferences2 = systemRoot;
            // ** MonitorExit[var2] (shouldn't be in output)
            try {
                if (preferences != null) {
                    preferences.flush();
                }
            }
            catch (BackingStoreException backingStoreException) {
                FileSystemPreferences.getLogger().warning("Couldn't flush user prefs: " + backingStoreException);
            }
            try {
                if (preferences2 != null) {
                    preferences2.flush();
                }
            }
            catch (BackingStoreException backingStoreException) {
                FileSystemPreferences.getLogger().warning("Couldn't flush system prefs: " + backingStoreException);
            }
            return;
        }
    }

    private FileSystemPreferences(boolean bl) {
        super(null, "");
        this.isUserNode = bl;
        this.dir = bl ? userRootDir : systemRootDir;
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
    }

    private FileSystemPreferences(FileSystemPreferences fileSystemPreferences, String string) {
        super(fileSystemPreferences, string);
        this.isUserNode = fileSystemPreferences.isUserNode;
        this.dir = new File(fileSystemPreferences.dir, FileSystemPreferences.dirName(string));
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileSystemPreferences.this.newNode = !FileSystemPreferences.this.dir.exists();
                return null;
            }
        });
        if (this.newNode) {
            this.prefsCache = new TreeMap<String, String>();
            this.nodeCreate = new NodeCreate();
            this.changeLog.add(this.nodeCreate);
        }
    }

    public boolean isUserNode() {
        return this.isUserNode;
    }

    protected void putSpi(String string, String string2) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Put(string, string2));
        this.prefsCache.put(string, string2);
    }

    protected String getSpi(String string) {
        this.initCacheIfNecessary();
        return this.prefsCache.get(string);
    }

    protected void removeSpi(String string) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Remove(string));
        this.prefsCache.remove(string);
    }

    private void initCacheIfNecessary() {
        if (this.prefsCache != null) {
            return;
        }
        try {
            this.loadCache();
        }
        catch (Exception exception) {
            this.prefsCache = new TreeMap<String, String>();
        }
    }

    private void loadCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackingStoreException {
                    TreeMap treeMap = new TreeMap();
                    long l = 0L;
                    try {
                        l = FileSystemPreferences.this.prefsFile.lastModified();
                        FileInputStream fileInputStream = new FileInputStream(FileSystemPreferences.this.prefsFile);
                        XmlSupport.importMap(fileInputStream, treeMap);
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        if (exception instanceof InvalidPreferencesFormatException) {
                            FileSystemPreferences.getLogger().warning("Invalid preferences format in " + FileSystemPreferences.this.prefsFile.getPath());
                            FileSystemPreferences.this.prefsFile.renameTo(new File(FileSystemPreferences.this.prefsFile.getParentFile(), "IncorrectFormatPrefs.xml"));
                            treeMap = new TreeMap();
                        }
                        if (exception instanceof FileNotFoundException) {
                            FileSystemPreferences.getLogger().warning("Prefs file removed in background " + FileSystemPreferences.this.prefsFile.getPath());
                        }
                        throw new BackingStoreException(exception);
                    }
                    FileSystemPreferences.this.prefsCache = treeMap;
                    FileSystemPreferences.this.lastSyncTime = l;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    private void writeBackCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackingStoreException {
                    try {
                        if (!FileSystemPreferences.this.dir.exists() && !FileSystemPreferences.this.dir.mkdirs()) {
                            throw new BackingStoreException(FileSystemPreferences.this.dir + " create failed.");
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(FileSystemPreferences.this.tmpFile);
                        XmlSupport.exportMap(fileOutputStream, FileSystemPreferences.this.prefsCache);
                        fileOutputStream.close();
                        if (!FileSystemPreferences.this.tmpFile.renameTo(FileSystemPreferences.this.prefsFile)) {
                            throw new BackingStoreException("Can't rename " + FileSystemPreferences.this.tmpFile + " to " + FileSystemPreferences.this.prefsFile);
                        }
                    }
                    catch (Exception exception) {
                        if (exception instanceof BackingStoreException) {
                            throw (BackingStoreException)exception;
                        }
                        throw new BackingStoreException(exception);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    protected String[] keysSpi() {
        this.initCacheIfNecessary();
        return this.prefsCache.keySet().toArray(new String[this.prefsCache.size()]);
    }

    protected String[] childrenNamesSpi() {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                ArrayList<String> arrayList = new ArrayList<String>();
                File[] fileArray = FileSystemPreferences.this.dir.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (!fileArray[i].isDirectory()) continue;
                        arrayList.add(FileSystemPreferences.nodeName(fileArray[i].getName()));
                    }
                }
                return arrayList.toArray(EMPTY_STRING_ARRAY);
            }
        });
    }

    protected AbstractPreferences childSpi(String string) {
        return new FileSystemPreferences(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        synchronized (file) {
            if (!this.lockFile(false)) {
                throw new BackingStoreException("Couldn't get file lock.");
            }
            try {
                super.removeNode();
                Object var3_2 = null;
                this.unlockFile();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.unlockFile();
                throw throwable;
            }
        }
    }

    protected void removeNodeSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackingStoreException {
                    if (FileSystemPreferences.this.changeLog.contains(FileSystemPreferences.this.nodeCreate)) {
                        FileSystemPreferences.this.changeLog.remove(FileSystemPreferences.this.nodeCreate);
                        FileSystemPreferences.this.nodeCreate = null;
                        return null;
                    }
                    if (!FileSystemPreferences.this.dir.exists()) {
                        return null;
                    }
                    FileSystemPreferences.this.prefsFile.delete();
                    FileSystemPreferences.this.tmpFile.delete();
                    File[] fileArray = FileSystemPreferences.this.dir.listFiles();
                    if (fileArray.length != 0) {
                        FileSystemPreferences.getLogger().warning("Found extraneous files when removing node: " + Arrays.asList(fileArray));
                        for (int i = 0; i < fileArray.length; ++i) {
                            fileArray[i].delete();
                        }
                    }
                    if (!FileSystemPreferences.this.dir.delete()) {
                        throw new BackingStoreException("Couldn't delete dir: " + FileSystemPreferences.this.dir);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sync() throws BackingStoreException {
        boolean bl = this.isUserNode();
        boolean bl2 = bl ? false : !isSystemRootWritable;
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        synchronized (file) {
            if (!this.lockFile(bl2)) {
                throw new BackingStoreException("Couldn't get file lock.");
            }
            final Long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    long l;
                    if (FileSystemPreferences.this.isUserNode()) {
                        l = userRootModFile.lastModified();
                        isUserRootModified = userRootModTime == l;
                    } else {
                        l = systemRootModFile.lastModified();
                        isSystemRootModified = systemRootModTime == l;
                    }
                    return new Long(l);
                }
            });
            try {
                super.sync();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        if (FileSystemPreferences.this.isUserNode()) {
                            userRootModTime = l + 1000L;
                            userRootModFile.setLastModified(userRootModTime);
                        } else {
                            systemRootModTime = l + 1000L;
                            systemRootModFile.setLastModified(systemRootModTime);
                        }
                        return null;
                    }
                });
                Object var6_5 = null;
                this.unlockFile();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.unlockFile();
                throw throwable;
            }
        }
    }

    protected void syncSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackingStoreException {
                    FileSystemPreferences.this.syncSpiPrivileged();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    private void syncSpiPrivileged() throws BackingStoreException {
        long l;
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        if (this.prefsCache == null) {
            return;
        }
        if (this.isUserNode() ? isUserRootModified : isSystemRootModified) {
            l = this.prefsFile.lastModified();
            if (l != this.lastSyncTime) {
                this.loadCache();
                this.replayChanges();
                this.lastSyncTime = l;
            }
        } else if (this.lastSyncTime != 0L && !this.dir.exists()) {
            this.prefsCache = new TreeMap<String, String>();
            this.replayChanges();
        }
        if (!this.changeLog.isEmpty()) {
            this.writeBackCache();
            l = this.prefsFile.lastModified();
            if (this.lastSyncTime <= l) {
                this.lastSyncTime = l + 1000L;
                this.prefsFile.setLastModified(this.lastSyncTime);
            }
            this.changeLog.clear();
        }
    }

    public void flush() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        this.sync();
    }

    protected void flushSpi() throws BackingStoreException {
    }

    private static boolean isDirChar(char c) {
        return c > '\u001f' && c < '\u007f' && c != '/' && c != '.' && c != '_';
    }

    private static String dirName(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (FileSystemPreferences.isDirChar(string.charAt(i))) continue;
            return "_" + Base64.byteArrayToAltBase64(FileSystemPreferences.byteArray(string));
        }
        return string;
    }

    private static byte[] byteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[n2++] = (byte)(c >> 8);
            byArray[n2++] = (byte)c;
        }
        return byArray;
    }

    private static String nodeName(String string) {
        if (string.charAt(0) != '_') {
            return string;
        }
        byte[] byArray = Base64.altBase64ToByteArray(string.substring(1));
        StringBuffer stringBuffer = new StringBuffer(byArray.length / 2);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            stringBuffer.append((char)(n2 << 8 | n3));
        }
        return stringBuffer.toString();
    }

    private boolean lockFile(boolean bl) throws SecurityException {
        boolean bl2 = this.isUserNode();
        int n = 0;
        File file = bl2 ? userLockFile : systemLockFile;
        long l = INIT_SLEEP_TIME;
        for (int i = 0; i < MAX_ATTEMPTS; ++i) {
            try {
                int n2 = bl2 ? 384 : 420;
                int[] nArray = FileSystemPreferences.lockFile0(file.getCanonicalPath(), n2, bl);
                n = nArray[1];
                if (nArray[0] != 0) {
                    if (bl2) {
                        userRootLockHandle = nArray[0];
                    } else {
                        systemRootLockHandle = nArray[0];
                    }
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                this.checkLockFile0ErrorCode(n);
                return false;
            }
            l *= 2L;
        }
        this.checkLockFile0ErrorCode(n);
        return false;
    }

    private void checkLockFile0ErrorCode(int n) throws SecurityException {
        if (n == 13) {
            throw new SecurityException("Could not lock " + (this.isUserNode() ? "User prefs." : "System prefs.") + " Lock file access denied.");
        }
        if (n != 11) {
            FileSystemPreferences.getLogger().warning("Could not lock " + (this.isUserNode() ? "User prefs. " : "System prefs.") + " Unix error code " + n + ".");
        }
    }

    private static native int[] lockFile0(String var0, int var1, boolean var2);

    private static native int unlockFile0(int var0);

    private static native int chmod(String var0, int var1);

    private void unlockFile() {
        int n;
        boolean bl = this.isUserNode();
        File file = bl ? userLockFile : systemLockFile;
        int n2 = n = bl ? userRootLockHandle : systemRootLockHandle;
        if (n == 0) {
            FileSystemPreferences.getLogger().warning("Unlock: zero lockHandle for " + (bl ? "user" : "system") + " preferences.)");
            return;
        }
        int n3 = FileSystemPreferences.unlockFile0(n);
        if (n3 != 0) {
            FileSystemPreferences.getLogger().warning("Could not drop file-lock on " + (this.isUserNode() ? "user" : "system") + " preferences." + " Unix error code " + n3 + ".");
            if (n3 == 13) {
                throw new SecurityException("Could not unlock" + (this.isUserNode() ? "User prefs." : "System prefs.") + " Lock file access denied.");
            }
        }
        if (this.isUserNode()) {
            userRootLockHandle = 0;
        } else {
            systemRootLockHandle = 0;
        }
    }

    static {
        userRoot = null;
        userRootLockHandle = 0;
        systemRootLockHandle = 0;
        isUserRootModified = false;
        isSystemRootModified = false;
        syncTimer = new Timer(true);
        syncTimer.schedule(new TimerTask(){

            public void run() {
                FileSystemPreferences.syncWorld();
            }
        }, SYNC_INTERVAL * 1000, (long)(SYNC_INTERVAL * 1000));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        syncTimer.cancel();
                        FileSystemPreferences.syncWorld();
                    }
                });
                return null;
            }
        });
        EMPTY_STRING_ARRAY = new String[0];
        INIT_SLEEP_TIME = 50;
        MAX_ATTEMPTS = 5;
    }

    private class NodeCreate
    extends Change {
        private NodeCreate() {
        }

        void replay() {
        }
    }

    private class Remove
    extends Change {
        String key;

        Remove(String string) {
            this.key = string;
        }

        void replay() {
            FileSystemPreferences.this.prefsCache.remove(this.key);
        }
    }

    private class Put
    extends Change {
        String key;
        String value;

        Put(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        void replay() {
            FileSystemPreferences.this.prefsCache.put(this.key, this.value);
        }
    }

    private abstract class Change {
        private Change() {
        }

        abstract void replay();
    }
}

