/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import javax.management.loading.MLet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MLetObjectInputStream
extends ObjectInputStream {
    private MLet loader;

    public MLetObjectInputStream(InputStream inputStream, MLet mLet) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (mLet == null) {
            throw new IllegalArgumentException("Illegal null argument to MLetObjectInputStream");
        }
        this.loader = mLet;
    }

    private Class<?> primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class<?> clazz;
            int n = 1;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                clazz = this.loader.loadClass(string.substring(n + 1, string.length() - 1));
            } else {
                if (string.length() != n + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n));
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 0;
            }
            return Array.newInstance(clazz, nArray).getClass();
        }
        return this.loader.loadClass(string);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

