/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Introspector;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private String observedAttribute;
    private long granularityPeriod = 10000L;
    private boolean isActive = false;
    private final AtomicLong sequenceNumber = new AtomicLong();
    private boolean isComplexTypeAttribute = false;
    private String firstAttribute;
    private final List<String> remainingAttributes = new CopyOnWriteArrayList<String>();
    private AccessControlContext acc;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("Scheduler"));
    private static final int maximumPoolSize;
    private static final ThreadPoolExecutor executor;
    private final MonitorTask monitorTask = new MonitorTask();
    private Future<?> monitorFuture;
    private final SchedulerTask schedulerTask = new SchedulerTask(this.monitorTask);
    private ScheduledFuture<?> schedulerFuture;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    @Deprecated
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    @Deprecated
    protected String dbgTag = Monitor.class.getName();
    final List<ObservedObject> observedObjects = new CopyOnWriteArrayList<ObservedObject>();
    static final int THRESHOLD_ERROR_NOTIFIED = 16;
    static final Integer INTEGER_ZERO;

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "preRegister(MBeanServer, ObjectName)", "initialize the reference on the MBean server");
        this.server = mBeanServer;
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "preDeregister()", "stop the monitor");
        this.stop();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();

    @Override
    @Deprecated
    public synchronized ObjectName getObservedObject() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return this.observedObjects.get(0).getObservedObject();
    }

    @Override
    @Deprecated
    public synchronized void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.observedObjects.size() == 1 && this.containsObservedObject(objectName)) {
            return;
        }
        this.observedObjects.clear();
        this.addObservedObject(objectName);
    }

    @Override
    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.containsObservedObject(objectName)) {
            return;
        }
        ObservedObject observedObject = this.createObservedObject(objectName);
        observedObject.setAlreadyNotified(0);
        observedObject.setDerivedGauge(INTEGER_ZERO);
        observedObject.setDerivedGaugeTimeStamp(System.currentTimeMillis());
        this.observedObjects.add(observedObject);
        this.createAlreadyNotified();
    }

    @Override
    public synchronized void removeObservedObject(ObjectName objectName) {
        if (objectName == null) {
            return;
        }
        ObservedObject observedObject = this.getObservedObject(objectName);
        if (observedObject != null) {
            this.observedObjects.remove(observedObject);
            this.createAlreadyNotified();
        }
    }

    @Override
    public synchronized boolean containsObservedObject(ObjectName objectName) {
        return this.getObservedObject(objectName) != null;
    }

    @Override
    public synchronized ObjectName[] getObservedObjects() {
        ObjectName[] objectNameArray = new ObjectName[this.observedObjects.size()];
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray[i] = this.observedObjects.get(i).getObservedObject();
        }
        return objectNameArray;
    }

    @Override
    public synchronized String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObservedAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null observed attribute");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedAttribute != null && this.observedAttribute.equals(string)) {
                return;
            }
            this.observedAttribute = string;
            this.cleanupIsComplexTypeAttribute();
            int n = 0;
            for (ObservedObject observedObject : this.observedObjects) {
                this.resetAlreadyNotified(observedObject, n++, 6);
            }
        }
    }

    @Override
    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    @Override
    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("Nonpositive granularity period");
        }
        if (this.granularityPeriod == l) {
            return;
        }
        this.granularityPeriod = l;
        if (this.isActive()) {
            this.cleanupFutures();
            this.schedulerFuture = scheduler.schedule(this.schedulerTask, l, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStart() {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStart()", "start the monitor");
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.isActive()) {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStart()", "the monitor is already active");
                return;
            }
            this.isActive = true;
            this.cleanupIsComplexTypeAttribute();
            this.acc = AccessController.getContext();
            this.cleanupFutures();
            this.schedulerFuture = scheduler.schedule(this.schedulerTask, this.getGranularityPeriod(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStop()", "stop the monitor");
        Monitor monitor = this;
        synchronized (monitor) {
            if (!this.isActive()) {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStop()", "the monitor is not active");
                return;
            }
            this.isActive = false;
            this.cleanupFutures();
            this.acc = null;
            this.cleanupIsComplexTypeAttribute();
        }
    }

    synchronized Object getDerivedGauge(ObjectName objectName) {
        ObservedObject observedObject = this.getObservedObject(objectName);
        return observedObject == null ? null : observedObject.getDerivedGauge();
    }

    synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        ObservedObject observedObject = this.getObservedObject(objectName);
        return observedObject == null ? 0L : observedObject.getDerivedGaugeTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAttribute(MBeanServerConnection mBeanServerConnection, ObjectName objectName, String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String string2;
        boolean bl;
        Object object = this;
        synchronized (object) {
            if (!this.isActive()) {
                throw new IllegalArgumentException("The monitor has been stopped");
            }
            if (!string.equals(this.getObservedAttribute())) {
                throw new IllegalArgumentException("The observed attribute has been changed");
            }
            bl = this.firstAttribute == null && string.indexOf(46) != -1;
        }
        if (bl) {
            try {
                object = mBeanServerConnection.getMBeanInfo(objectName);
            }
            catch (IntrospectionException introspectionException) {
                throw new IllegalArgumentException(introspectionException);
            }
        } else {
            object = null;
        }
        Monitor monitor = this;
        synchronized (monitor) {
            if (!this.isActive()) {
                throw new IllegalArgumentException("The monitor has been stopped");
            }
            if (!string.equals(this.getObservedAttribute())) {
                throw new IllegalArgumentException("The observed attribute has been changed");
            }
            if (this.firstAttribute == null) {
                if (string.indexOf(46) != -1) {
                    MBeanAttributeInfo[] mBeanAttributeInfoArray = ((MBeanInfo)object).getAttributes();
                    for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                        if (!string.equals(mBeanAttributeInfo.getName())) continue;
                        this.firstAttribute = string;
                        break;
                    }
                    if (this.firstAttribute == null) {
                        Object[] objectArray = string.split("\\.", -1);
                        this.firstAttribute = objectArray[0];
                        for (int i = 1; i < objectArray.length; ++i) {
                            this.remainingAttributes.add((String)objectArray[i]);
                        }
                        this.isComplexTypeAttribute = true;
                    }
                } else {
                    this.firstAttribute = string;
                }
            }
            string2 = this.firstAttribute;
        }
        return mBeanServerConnection.getAttribute(objectName, string2);
    }

    Comparable<?> getComparableFromAttribute(ObjectName objectName, String string, Object object) throws AttributeNotFoundException {
        if (this.isComplexTypeAttribute) {
            Object object2 = object;
            for (String string2 : this.remainingAttributes) {
                object2 = Introspector.elementFromComplex(object2, string2);
            }
            return (Comparable)object2;
        }
        return (Comparable)object;
    }

    boolean isComparableTypeValid(ObjectName objectName, String string, Comparable<?> comparable) {
        return true;
    }

    String buildErrorNotification(ObjectName objectName, String string, Comparable<?> comparable) {
        return null;
    }

    void onErrorNotification(MonitorNotification monitorNotification) {
    }

    Comparable<?> getDerivedGaugeFromComparable(ObjectName objectName, String string, Comparable<?> comparable) {
        return comparable;
    }

    MonitorNotification buildAlarmNotification(ObjectName objectName, String string, Comparable<?> comparable) {
        return null;
    }

    boolean isThresholdTypeValid(ObjectName objectName, String string, Comparable<?> comparable) {
        return true;
    }

    static Class<? extends Number> classForType(NumericalType numericalType) {
        switch (numericalType) {
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        throw new IllegalArgumentException("Unsupported numerical type");
    }

    static boolean isValidForType(Object object, Class<? extends Number> clazz) {
        return object == INTEGER_ZERO || clazz.isInstance(object);
    }

    synchronized ObservedObject getObservedObject(ObjectName objectName) {
        for (ObservedObject observedObject : this.observedObjects) {
            if (!observedObject.getObservedObject().equals(objectName)) continue;
            return observedObject;
        }
        return null;
    }

    ObservedObject createObservedObject(ObjectName objectName) {
        return new ObservedObject(objectName);
    }

    synchronized void createAlreadyNotified() {
        this.elementCount = this.observedObjects.size();
        this.alreadyNotifieds = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            this.alreadyNotifieds[i] = this.observedObjects.get(i).getAlreadyNotified();
        }
        this.updateDeprecatedAlreadyNotified();
    }

    synchronized void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    synchronized void updateAlreadyNotified(ObservedObject observedObject, int n) {
        this.alreadyNotifieds[n] = observedObject.getAlreadyNotified();
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized boolean isAlreadyNotified(ObservedObject observedObject, int n) {
        return (observedObject.getAlreadyNotified() & n) != 0;
    }

    synchronized void setAlreadyNotified(ObservedObject observedObject, int n, int n2, int[] nArray) {
        int n3 = this.computeAlreadyNotifiedIndex(observedObject, n, nArray);
        if (n3 == -1) {
            return;
        }
        observedObject.setAlreadyNotified(observedObject.getAlreadyNotified() | n2);
        this.updateAlreadyNotified(observedObject, n3);
    }

    synchronized void resetAlreadyNotified(ObservedObject observedObject, int n, int n2) {
        observedObject.setAlreadyNotified(observedObject.getAlreadyNotified() & ~n2);
        this.updateAlreadyNotified(observedObject, n);
    }

    synchronized void resetAllAlreadyNotified(ObservedObject observedObject, int n, int[] nArray) {
        int n2 = this.computeAlreadyNotifiedIndex(observedObject, n, nArray);
        if (n2 == -1) {
            return;
        }
        observedObject.setAlreadyNotified(0);
        this.updateAlreadyNotified(observedObject, n);
    }

    synchronized int computeAlreadyNotifiedIndex(ObservedObject observedObject, int n, int[] nArray) {
        if (nArray == this.alreadyNotifieds) {
            return n;
        }
        return this.observedObjects.indexOf(observedObject);
    }

    private void sendNotification(String string, long l, String string2, Object object, Object object2, ObjectName objectName, boolean bl) {
        if (!this.isActive()) {
            return;
        }
        if (JmxProperties.MONITOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "sendNotification", "send notification: \n\tNotification observed object = " + objectName + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + object);
        }
        long l2 = this.sequenceNumber.getAndIncrement();
        MonitorNotification monitorNotification = new MonitorNotification(string, this, l2, l, string2, objectName, this.observedAttribute, object, object2);
        if (bl) {
            this.onErrorNotification(monitorNotification);
        }
        this.sendNotification(monitorNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor(ObservedObject observedObject, int n, int[] nArray) {
        String string;
        ObjectName objectName;
        String string2 = null;
        String string3 = null;
        Comparable<?> comparable = null;
        Object var8_7 = null;
        Comparable<?> comparable2 = null;
        Notification notification = null;
        if (!this.isActive()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            objectName = observedObject.getObservedObject();
            string = this.getObservedAttribute();
            if (objectName == null || string == null) {
                return;
            }
        }
        object = null;
        try {
            object = this.getAttribute(this.server, objectName, string);
            if (object == null) {
                if (this.isAlreadyNotified(observedObject, 4)) {
                    return;
                }
                string2 = "jmx.monitor.error.type";
                this.setAlreadyNotified(observedObject, n, 4, nArray);
                string3 = "The observed attribute value is null.";
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.isAlreadyNotified(observedObject, 8)) {
                return;
            }
            string2 = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(observedObject, n, 8, nArray);
            string3 = "The monitor must be registered in the MBean server or an MBeanServerConnection must be explicitly supplied.";
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", nullPointerException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (this.isAlreadyNotified(observedObject, 1)) {
                return;
            }
            string2 = "jmx.monitor.error.mbean";
            this.setAlreadyNotified(observedObject, n, 1, nArray);
            string3 = "The observed object must be accessible in the MBeanServerConnection.";
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", instanceNotFoundException.toString());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            if (this.isAlreadyNotified(observedObject, 2)) {
                return;
            }
            string2 = "jmx.monitor.error.attribute";
            this.setAlreadyNotified(observedObject, n, 2, nArray);
            string3 = "The observed attribute must be accessible in the observed object.";
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", attributeNotFoundException.toString());
        }
        catch (MBeanException mBeanException) {
            if (this.isAlreadyNotified(observedObject, 8)) {
                return;
            }
            string2 = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(observedObject, n, 8, nArray);
            string3 = mBeanException.getMessage() == null ? "" : mBeanException.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", mBeanException.toString());
        }
        catch (ReflectionException reflectionException) {
            if (this.isAlreadyNotified(observedObject, 8)) {
                return;
            }
            string2 = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(observedObject, n, 8, nArray);
            string3 = reflectionException.getMessage() == null ? "" : reflectionException.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", reflectionException.toString());
        }
        catch (IOException iOException) {
            if (this.isAlreadyNotified(observedObject, 8)) {
                return;
            }
            string2 = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(observedObject, n, 8, nArray);
            string3 = iOException.getMessage() == null ? "" : iOException.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", iOException.toString());
        }
        catch (RuntimeException runtimeException) {
            if (this.isAlreadyNotified(observedObject, 8)) {
                return;
            }
            string2 = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(observedObject, n, 8, nArray);
            string3 = runtimeException.getMessage() == null ? "" : runtimeException.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", runtimeException.toString());
        }
        Monitor monitor = this;
        synchronized (monitor) {
            if (!this.isActive()) {
                return;
            }
            if (!string.equals(this.getObservedAttribute())) {
                return;
            }
            if (string3 == null) {
                try {
                    comparable2 = this.getComparableFromAttribute(objectName, string, object);
                }
                catch (ClassCastException classCastException) {
                    if (this.isAlreadyNotified(observedObject, 4)) {
                        return;
                    }
                    string2 = "jmx.monitor.error.type";
                    this.setAlreadyNotified(observedObject, n, 4, nArray);
                    string3 = "The observed attribute value does not implement the Comparable interface.";
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", classCastException.toString());
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if (this.isAlreadyNotified(observedObject, 2)) {
                        return;
                    }
                    string2 = "jmx.monitor.error.attribute";
                    this.setAlreadyNotified(observedObject, n, 2, nArray);
                    string3 = "The observed attribute must be accessible in the observed object.";
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", attributeNotFoundException.toString());
                }
                catch (RuntimeException runtimeException) {
                    if (this.isAlreadyNotified(observedObject, 8)) {
                        return;
                    }
                    string2 = "jmx.monitor.error.runtime";
                    this.setAlreadyNotified(observedObject, n, 8, nArray);
                    string3 = runtimeException.getMessage() == null ? "" : runtimeException.getMessage();
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", runtimeException.toString());
                }
            }
            if (string3 == null && !this.isComparableTypeValid(objectName, string, comparable2)) {
                if (this.isAlreadyNotified(observedObject, 4)) {
                    return;
                }
                string2 = "jmx.monitor.error.type";
                this.setAlreadyNotified(observedObject, n, 4, nArray);
                string3 = "The observed attribute type is not valid.";
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            }
            if (string3 == null && !this.isThresholdTypeValid(objectName, string, comparable2)) {
                if (this.isAlreadyNotified(observedObject, 16)) {
                    return;
                }
                string2 = "jmx.monitor.error.threshold";
                this.setAlreadyNotified(observedObject, n, 16, nArray);
                string3 = "The threshold type is not valid.";
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            }
            if (string3 == null && (string3 = this.buildErrorNotification(objectName, string, comparable2)) != null) {
                if (this.isAlreadyNotified(observedObject, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(observedObject, n, 8, nArray);
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", string3);
            }
            if (string3 == null) {
                this.resetAllAlreadyNotified(observedObject, n, nArray);
                comparable = this.getDerivedGaugeFromComparable(objectName, string, comparable2);
                observedObject.setDerivedGauge(comparable);
                observedObject.setDerivedGaugeTimeStamp(System.currentTimeMillis());
                notification = this.buildAlarmNotification(objectName, string, comparable);
            }
        }
        if (string3 != null) {
            this.sendNotification(string2, System.currentTimeMillis(), string3, comparable, var8_7, objectName, true);
        }
        if (notification != null && notification.getType() != null) {
            this.sendNotification(notification.getType(), System.currentTimeMillis(), notification.getMessage(), comparable, ((MonitorNotification)notification).getTrigger(), objectName, false);
        }
    }

    private synchronized void cleanupFutures() {
        if (this.schedulerFuture != null) {
            this.schedulerFuture.cancel(false);
            this.schedulerFuture = null;
        }
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(false);
            this.monitorFuture = null;
        }
    }

    private synchronized void cleanupIsComplexTypeAttribute() {
        this.firstAttribute = null;
        this.remainingAttributes.clear();
        this.isComplexTypeAttribute = false;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jmx.x.monitor.maximum.pool.size"));
        if (string == null || string.trim().length() == 0) {
            maximumPoolSize = 10;
        } else {
            int n = 10;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (JmxProperties.MONITOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "<static initializer>", "Wrong value for jmx.x.monitor.maximum.pool.size system property", numberFormatException);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "<static initializer>", "jmx.x.monitor.maximum.pool.size defaults to 10");
                }
                n = 10;
            }
            maximumPoolSize = n < 1 ? 1 : n;
        }
        executor = new ThreadPoolExecutor(maximumPoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Executor"));
        executor.allowCoreThreadTimeOut(true);
        INTEGER_ZERO = 0;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        static final String nameSuffix = "]";

        public DaemonThreadFactory(String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "JMX Monitor " + string + " Pool [Thread-";
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement() + nameSuffix, 0L);
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private class MonitorTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ScheduledFuture scheduledFuture;
            Monitor monitor = Monitor.this;
            synchronized (monitor) {
                scheduledFuture = Monitor.this.schedulerFuture;
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (Monitor.this.isActive()) {
                        int[] nArray = Monitor.this.alreadyNotifieds;
                        int n = 0;
                        for (ObservedObject observedObject : Monitor.this.observedObjects) {
                            if (!Monitor.this.isActive()) continue;
                            Monitor.this.monitor(observedObject, n++, nArray);
                        }
                    }
                    return null;
                }
            }, Monitor.this.acc);
            monitor = Monitor.this;
            synchronized (monitor) {
                if (Monitor.this.isActive() && Monitor.this.schedulerFuture == scheduledFuture) {
                    Monitor.this.monitorFuture = null;
                    Monitor.this.schedulerFuture = scheduler.schedule(Monitor.this.schedulerTask, Monitor.this.getGranularityPeriod(), TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private class SchedulerTask
    implements Runnable {
        private Runnable task = null;

        public SchedulerTask(Runnable runnable) {
            this.task = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Monitor monitor = Monitor.this;
            synchronized (monitor) {
                Monitor.this.monitorFuture = executor.submit(this.task);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NumericalType {
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE;

    }

    static class ObservedObject {
        private final ObjectName observedObject;
        private int alreadyNotified;
        private Object derivedGauge;
        private long derivedGaugeTimeStamp;

        public ObservedObject(ObjectName objectName) {
            this.observedObject = objectName;
        }

        public final ObjectName getObservedObject() {
            return this.observedObject;
        }

        public final synchronized int getAlreadyNotified() {
            return this.alreadyNotified;
        }

        public final synchronized void setAlreadyNotified(int n) {
            this.alreadyNotified = n;
        }

        public final synchronized Object getDerivedGauge() {
            return this.derivedGauge;
        }

        public final synchronized void setDerivedGauge(Object object) {
            this.derivedGauge = object;
        }

        public final synchronized long getDerivedGaugeTimeStamp() {
            return this.derivedGaugeTimeStamp;
        }

        public final synchronized void setDerivedGaugeTimeStamp(long l) {
            this.derivedGaugeTimeStamp = l;
        }
    }
}

