/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class OverlayLayout
implements LayoutManager2,
Serializable {
    private Container target;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;

    @ConstructorProperties(value={"target"})
    public OverlayLayout(Container container) {
        this.target = container;
    }

    public final Container getTarget() {
        return this.target;
    }

    public void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    public void addLayoutComponent(String string, Component component) {
        this.invalidateLayout(component.getParent());
    }

    public void removeLayoutComponent(Component component) {
        this.invalidateLayout(component.getParent());
    }

    public void addLayoutComponent(Component component, Object object) {
        this.invalidateLayout(component.getParent());
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension maximumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    public void layoutContainer(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        int n = container.getComponentCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2);
        SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            component.setBounds(insets.left + nArray[i], insets.top + nArray3[i], nArray2[i], nArray4[i]);
        }
    }

    void checkContainer(Container container) {
        if (this.target != container) {
            throw new AWTError("OverlayLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                Component component = this.target.getComponent(i);
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component.getMaximumSize();
                this.xChildren[i] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, component.getAlignmentX());
                this.yChildren[i] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, component.getAlignmentY());
            }
            this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
    }
}

