/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XMBeanNotifications;
import sun.tools.jconsole.inspector.XMBeanOperations;
import sun.tools.jconsole.inspector.XNodeInfo;
import sun.tools.jconsole.inspector.XTree;

public class XSheet
extends JPanel
implements ActionListener,
NotificationListener {
    private JPanel mainPanel;
    private JPanel southPanel;
    private volatile DefaultMutableTreeNode currentNode;
    private volatile XMBean mbean;
    private XMBeanAttributes mbeanAttributes;
    private XMBeanOperations mbeanOperations;
    private XMBeanNotifications mbeanNotifications;
    private XMBeanInfo mbeanInfo;
    private JButton refreshButton;
    private JButton clearButton;
    private JButton subscribeButton;
    private JButton unsubscribeButton;
    private MBeansTab mbeansTab;

    public XSheet(MBeansTab mBeansTab) {
        this.mbeansTab = mBeansTab;
        this.setupScreen();
    }

    public void dispose() {
        this.clear();
        XDataViewer.dispose(this.mbeansTab);
        this.mbeanNotifications.dispose();
    }

    private void setupScreen() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.southPanel = new JPanel();
        this.add((Component)this.southPanel, "South");
        String string = "MBeansTab.refreshAttributesButton";
        this.refreshButton = new JButton(Resources.getText(string, new Object[0]));
        this.refreshButton.setMnemonic(Resources.getMnemonicInt(string));
        this.refreshButton.setToolTipText(Resources.getText(string + ".toolTip", new Object[0]));
        this.refreshButton.addActionListener(this);
        String string2 = "MBeansTab.clearNotificationsButton";
        this.clearButton = new JButton(Resources.getText(string2, new Object[0]));
        this.clearButton.setMnemonic(Resources.getMnemonicInt(string2));
        this.clearButton.setToolTipText(Resources.getText(string2 + ".toolTip", new Object[0]));
        this.clearButton.addActionListener(this);
        String string3 = "MBeansTab.subscribeNotificationsButton";
        this.subscribeButton = new JButton(Resources.getText(string3, new Object[0]));
        this.subscribeButton.setMnemonic(Resources.getMnemonicInt(string3));
        this.subscribeButton.setToolTipText(Resources.getText(string3 + ".toolTip", new Object[0]));
        this.subscribeButton.addActionListener(this);
        String string4 = "MBeansTab.unsubscribeNotificationsButton";
        this.unsubscribeButton = new JButton(Resources.getText(string4, new Object[0]));
        this.unsubscribeButton.setMnemonic(Resources.getMnemonicInt(string4));
        this.unsubscribeButton.setToolTipText(Resources.getText(string4 + ".toolTip", new Object[0]));
        this.unsubscribeButton.addActionListener(this);
        this.mbeanAttributes = new XMBeanAttributes(this.mbeansTab);
        this.mbeanOperations = new XMBeanOperations(this.mbeansTab);
        this.mbeanOperations.addOperationsListener(this);
        this.mbeanNotifications = new XMBeanNotifications();
        this.mbeanNotifications.addNotificationsListener(this);
        this.mbeanInfo = new XMBeanInfo();
    }

    private boolean isSelectedNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        return defaultMutableTreeNode2 == defaultMutableTreeNode;
    }

    private void showErrorDialog(Object object, String string) {
        new ThreadDialog(this, object, string, 0).run();
    }

    public boolean isMBeanNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof XNodeInfo) {
            XNodeInfo xNodeInfo = (XNodeInfo)object;
            return xNodeInfo.getType().equals((Object)XNodeInfo.Type.MBEAN);
        }
        return false;
    }

    public synchronized void displayNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.clear();
        this.displayEmptyNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.currentNode = defaultMutableTreeNode;
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof XNodeInfo) {
            XNodeInfo xNodeInfo = (XNodeInfo)object;
            switch (xNodeInfo.getType()) {
                case MBEAN: {
                    this.displayMBeanNode(defaultMutableTreeNode);
                    break;
                }
                case NONMBEAN: {
                    this.displayEmptyNode();
                    break;
                }
                case ATTRIBUTES: {
                    this.displayMBeanAttributesNode(defaultMutableTreeNode);
                    break;
                }
                case OPERATIONS: {
                    this.displayMBeanOperationsNode(defaultMutableTreeNode);
                    break;
                }
                case NOTIFICATIONS: {
                    this.displayMBeanNotificationsNode(defaultMutableTreeNode);
                    break;
                }
                case ATTRIBUTE: 
                case OPERATION: 
                case NOTIFICATION: {
                    this.displayMetadataNode(defaultMutableTreeNode);
                    break;
                }
                default: {
                    this.displayEmptyNode();
                    break;
                }
            }
        } else {
            this.displayEmptyNode();
        }
    }

    private void displayMBeanNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            return;
        }
        this.mbean = (XMBean)xNodeInfo.getData();
        SwingWorker<MBeanInfo, Void> swingWorker = new SwingWorker<MBeanInfo, Void>(){

            @Override
            public MBeanInfo doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                return XSheet.this.mbean.getMBeanInfo();
            }

            @Override
            protected void done() {
                try {
                    MBeanInfo mBeanInfo = (MBeanInfo)this.get();
                    if (mBeanInfo != null) {
                        if (!XSheet.this.isSelectedNode(defaultMutableTreeNode, XSheet.this.currentNode)) {
                            return;
                        }
                        XSheet.this.mbeanInfo.addMBeanInfo(XSheet.this.mbean, mBeanInfo);
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        XSheet.this.mainPanel.add((Component)XSheet.this.mbeanInfo, "Center");
                        XSheet.this.southPanel.setVisible(false);
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = Utils.getActualException(exception);
                    if (JConsole.isDebug()) {
                        System.err.println("Couldn't get MBeanInfo for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                        throwable.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(throwable.toString(), Resources.getText("Problem displaying MBean", new Object[0]));
                }
            }
        };
        swingWorker.execute();
    }

    private void displayMetadataNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        final XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        final XMBeanInfo xMBeanInfo = this.mbeanInfo;
        switch (xNodeInfo.getType()) {
            case ATTRIBUTE: {
                SwingWorker<MBeanAttributeInfo, Void> swingWorker = new SwingWorker<MBeanAttributeInfo, Void>(){

                    @Override
                    public MBeanAttributeInfo doInBackground() {
                        Object object = xNodeInfo.getData();
                        XSheet.this.mbean = (XMBean)((Object[])object)[0];
                        MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)((Object[])object)[1];
                        XSheet.this.mbeanAttributes.loadAttributes(XSheet.this.mbean, new MBeanInfo(null, null, new MBeanAttributeInfo[]{mBeanAttributeInfo}, null, null, null));
                        return mBeanAttributeInfo;
                    }

                    @Override
                    protected void done() {
                        try {
                            MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)this.get();
                            if (!XSheet.this.isSelectedNode(defaultMutableTreeNode, XSheet.this.currentNode)) {
                                return;
                            }
                            XSheet.this.invalidate();
                            XSheet.this.mainPanel.removeAll();
                            JPanel jPanel = new JPanel(new BorderLayout());
                            JPanel jPanel2 = new JPanel(new BorderLayout());
                            jPanel2.setBorder(BorderFactory.createTitledBorder(Resources.getText("Attribute value", new Object[0])));
                            JPanel jPanel3 = new JPanel(new BorderLayout());
                            jPanel3.setBorder(LineBorder.createGrayLineBorder());
                            jPanel3.add((Component)XSheet.this.mbeanAttributes.getTableHeader(), "First");
                            jPanel3.add((Component)XSheet.this.mbeanAttributes, "Center");
                            jPanel2.add((Component)jPanel3, "Center");
                            JPanel jPanel4 = new JPanel();
                            jPanel4.add(XSheet.this.refreshButton);
                            jPanel2.add((Component)jPanel4, "South");
                            XSheet.this.refreshButton.setEnabled(true);
                            jPanel.add((Component)jPanel2, "North");
                            xMBeanInfo.addMBeanAttributeInfo(mBeanAttributeInfo);
                            jPanel.add((Component)xMBeanInfo, "Center");
                            XSheet.this.mainPanel.add((Component)jPanel, "Center");
                            XSheet.this.southPanel.setVisible(false);
                            XSheet.this.southPanel.removeAll();
                            XSheet.this.validate();
                            XSheet.this.repaint();
                        }
                        catch (Exception exception) {
                            Throwable throwable = Utils.getActualException(exception);
                            if (JConsole.isDebug()) {
                                System.err.println("Problem displaying MBean attribute for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                                throwable.printStackTrace();
                            }
                            XSheet.this.showErrorDialog(throwable.toString(), Resources.getText("Problem displaying MBean", new Object[0]));
                        }
                    }
                };
                swingWorker.execute();
                break;
            }
            case OPERATION: {
                Object object = xNodeInfo.getData();
                this.mbean = (XMBean)((Object[])object)[0];
                MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)((Object[])object)[1];
                this.mbeanOperations.loadOperations(this.mbean, new MBeanInfo(null, null, null, null, new MBeanOperationInfo[]{mBeanOperationInfo}, null));
                this.invalidate();
                this.mainPanel.removeAll();
                JPanel jPanel = new JPanel(new BorderLayout());
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.setBorder(BorderFactory.createTitledBorder(Resources.getText("Operation invocation", new Object[0])));
                jPanel2.add(new JScrollPane(this.mbeanOperations));
                jPanel.add((Component)jPanel2, "North");
                xMBeanInfo.addMBeanOperationInfo(mBeanOperationInfo);
                jPanel.add((Component)xMBeanInfo, "Center");
                this.mainPanel.add((Component)jPanel, "Center");
                this.southPanel.setVisible(false);
                this.southPanel.removeAll();
                this.validate();
                this.repaint();
                break;
            }
            case NOTIFICATION: {
                Object object = xNodeInfo.getData();
                this.invalidate();
                this.mainPanel.removeAll();
                xMBeanInfo.addMBeanNotificationInfo((MBeanNotificationInfo)object);
                this.mainPanel.add((Component)xMBeanInfo, "Center");
                this.southPanel.setVisible(false);
                this.southPanel.removeAll();
                this.validate();
                this.repaint();
            }
        }
    }

    private void displayMBeanAttributesNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.ATTRIBUTES)) {
            return;
        }
        final XMBean xMBean = this.mbean = (XMBean)xNodeInfo.getData();
        SwingWorker<MBeanInfo, Void> swingWorker = new SwingWorker<MBeanInfo, Void>(){

            @Override
            public MBeanInfo doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                MBeanInfo mBeanInfo = xMBean.getMBeanInfo();
                return mBeanInfo;
            }

            @Override
            protected void done() {
                try {
                    MBeanInfo mBeanInfo = (MBeanInfo)this.get();
                    if (mBeanInfo != null && mBeanInfo.getAttributes() != null && mBeanInfo.getAttributes().length > 0) {
                        XSheet.this.mbeanAttributes.loadAttributes(xMBean, mBeanInfo);
                        if (!XSheet.this.isSelectedNode(defaultMutableTreeNode, XSheet.this.currentNode)) {
                            return;
                        }
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel jPanel = new JPanel(new BorderLayout());
                        jPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Attribute values", new Object[0])));
                        jPanel.add(new JScrollPane(XSheet.this.mbeanAttributes));
                        XSheet.this.mainPanel.add((Component)jPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)XSheet.this.refreshButton, "South");
                        XSheet.this.southPanel.setVisible(true);
                        XSheet.this.refreshButton.setEnabled(true);
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = Utils.getActualException(exception);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem displaying MBean attributes for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                        throwable.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(throwable.toString(), Resources.getText("Problem displaying MBean", new Object[0]));
                }
            }
        };
        swingWorker.execute();
    }

    private void displayMBeanOperationsNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.OPERATIONS)) {
            return;
        }
        this.mbean = (XMBean)xNodeInfo.getData();
        SwingWorker<MBeanInfo, Void> swingWorker = new SwingWorker<MBeanInfo, Void>(){

            @Override
            public MBeanInfo doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                return XSheet.this.mbean.getMBeanInfo();
            }

            @Override
            protected void done() {
                try {
                    MBeanInfo mBeanInfo = (MBeanInfo)this.get();
                    if (mBeanInfo != null) {
                        if (!XSheet.this.isSelectedNode(defaultMutableTreeNode, XSheet.this.currentNode)) {
                            return;
                        }
                        XSheet.this.mbeanOperations.loadOperations(XSheet.this.mbean, mBeanInfo);
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel jPanel = new JPanel(new BorderLayout());
                        jPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Operation invocation", new Object[0])));
                        jPanel.add(new JScrollPane(XSheet.this.mbeanOperations));
                        XSheet.this.mainPanel.add((Component)jPanel, "Center");
                        XSheet.this.southPanel.setVisible(false);
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = Utils.getActualException(exception);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem displaying MBean operations for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                        throwable.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(throwable.toString(), Resources.getText("Problem displaying MBean", new Object[0]));
                }
            }
        };
        swingWorker.execute();
    }

    private void displayMBeanNotificationsNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.NOTIFICATIONS)) {
            return;
        }
        this.mbean = (XMBean)xNodeInfo.getData();
        this.mbeanNotifications.loadNotifications(this.mbean);
        this.updateNotifications();
        this.invalidate();
        this.mainPanel.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Notification buffer", new Object[0])));
        jPanel.add(new JScrollPane(this.mbeanNotifications));
        this.mainPanel.add((Component)jPanel, "Center");
        this.southPanel.removeAll();
        this.southPanel.add((Component)this.subscribeButton, "West");
        this.southPanel.add((Component)this.unsubscribeButton, "Center");
        this.southPanel.add((Component)this.clearButton, "East");
        this.southPanel.setVisible(true);
        this.subscribeButton.setEnabled(true);
        this.unsubscribeButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.validate();
        this.repaint();
    }

    private void displayEmptyNode() {
        this.invalidate();
        this.mainPanel.removeAll();
        this.southPanel.removeAll();
        this.validate();
        this.repaint();
    }

    private void registerListener() {
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws InstanceNotFoundException, IOException {
                XSheet.this.mbeanNotifications.registerListener(XSheet.this.currentNode);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    XSheet.this.updateNotifications();
                    XSheet.this.validate();
                }
                catch (Exception exception) {
                    Throwable throwable = Utils.getActualException(exception);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem adding listener");
                        throwable.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(throwable.getMessage(), Resources.getText("Problem adding listener", new Object[0]));
                }
            }
        }.execute();
    }

    private void unregisterListener() {
        new SwingWorker<Boolean, Void>(){

            @Override
            public Boolean doInBackground() {
                return XSheet.this.mbeanNotifications.unregisterListener(XSheet.this.currentNode);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        XSheet.this.updateNotifications();
                        XSheet.this.validate();
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = Utils.getActualException(exception);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem removing listener");
                        throwable.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(throwable.getMessage(), Resources.getText("Problem removing listener", new Object[0]));
                }
            }
        }.execute();
    }

    private void refreshAttributes() {
        this.mbeanAttributes.refreshAttributes();
    }

    private void updateNotifications() {
        if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
            long l = this.mbeanNotifications.getReceivedNotifications(this.mbean);
            this.updateReceivedNotifications(this.currentNode, l, false);
        } else {
            this.clearNotifications();
        }
    }

    private void updateReceivedNotifications(DefaultMutableTreeNode defaultMutableTreeNode, long l, boolean bl) {
        String string = Resources.getText("Notifications", new Object[0]) + "[" + l + "]";
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.mbeansTab.getTree().getLastSelectedPathComponent();
        if (bl && defaultMutableTreeNode != defaultMutableTreeNode2) {
            string = "<html><b>" + string + "</b></html>";
        }
        this.updateNotificationsNodeLabel(defaultMutableTreeNode, string);
    }

    private void clearNotifications() {
        this.updateNotificationsNodeLabel(this.currentNode, Resources.getText("Notifications", new Object[0]));
    }

    private void clearNotifications0() {
        this.updateNotificationsNodeLabel(this.currentNode, Resources.getText("Notifications", new Object[0]) + "[0]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationsNodeLabel(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        XTree xTree = this.mbeansTab.getTree();
        synchronized (xTree) {
            this.invalidate();
            XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
            XNodeInfo xNodeInfo2 = new XNodeInfo(xNodeInfo.getType(), xNodeInfo.getData(), string, xNodeInfo.getToolTipText());
            defaultMutableTreeNode.setUserObject(xNodeInfo2);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mbeansTab.getTree().getModel();
            defaultTreeModel.nodeChanged(defaultMutableTreeNode);
            this.validate();
            this.repaint();
        }
    }

    private void clearCurrentNotifications() {
        this.mbeanNotifications.clearCurrentNotifications();
        if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
            this.clearNotifications0();
        } else {
            this.clearNotifications();
        }
    }

    private void clear() {
        this.mbeanAttributes.stopCellEditing();
        this.mbeanAttributes.emptyTable();
        this.mbeanAttributes.removeAttributes();
        this.mbeanOperations.removeOperations();
        this.mbeanNotifications.stopCellEditing();
        this.mbeanNotifications.emptyTable();
        this.mbeanNotifications.disableNotifications();
        this.mbean = null;
        this.currentNode = null;
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("jam.xoperations.invoke.result")) {
            Component component;
            if (object == null) {
                JTextArea jTextArea = new JTextArea("null");
                jTextArea.setEditable(false);
                jTextArea.setEnabled(true);
                jTextArea.setRows(jTextArea.getLineCount());
                component = jTextArea;
            } else {
                Component component2 = this.mbeansTab.getDataViewer().createOperationViewer(object, this.mbean);
                if (component2 == null) {
                    JTextArea jTextArea = new JTextArea(object.toString());
                    jTextArea.setEditable(false);
                    jTextArea.setEnabled(true);
                    jTextArea.setRows(jTextArea.getLineCount());
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    Dimension dimension = jScrollPane.getPreferredSize();
                    if (dimension.getWidth() > 400.0 || dimension.getHeight() > 250.0) {
                        jScrollPane.setPreferredSize(new Dimension(400, 250));
                    }
                    component = jScrollPane;
                } else {
                    Dimension dimension;
                    if (!(component2 instanceof JScrollPane)) {
                        component2 = new JScrollPane(component2);
                    }
                    if ((dimension = component2.getPreferredSize()).getWidth() > 400.0 || dimension.getHeight() > 250.0) {
                        component2.setPreferredSize(new Dimension(400, 250));
                    }
                    component = component2;
                }
            }
            new ThreadDialog((Component)notification.getSource(), component, Resources.getText("Operation return value", new Object[0]), 1).run();
        } else if (notification.getType().equals("jconsole.xnotification.received")) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Long l = (Long)notification.getUserData();
            this.updateReceivedNotifications(defaultMutableTreeNode, l, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.refreshButton) {
                this.refreshAttributes();
                return;
            }
            if (jButton == this.clearButton) {
                this.clearCurrentNotifications();
                return;
            }
            if (jButton == this.subscribeButton) {
                this.registerListener();
                return;
            }
            if (jButton == this.unsubscribeButton) {
                this.unregisterListener();
                return;
            }
        }
    }
}

