/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JGenerable;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JMods
implements JGenerable {
    private static int VAR = 8;
    private static int FIELD = 799;
    private static int METHOD = 255;
    private static int CLASS = 63;
    private static int INTERFACE = 1;
    private int mods;

    private JMods(int n) {
        this.mods = n;
    }

    public int getValue() {
        return this.mods;
    }

    private static void check(int n, int n2, String string) {
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Illegal modifiers for " + string + ": " + new JMods(n).toString());
        }
    }

    static JMods forVar(int n) {
        JMods.check(n, VAR, "variable");
        return new JMods(n);
    }

    static JMods forField(int n) {
        JMods.check(n, FIELD, "field");
        return new JMods(n);
    }

    static JMods forMethod(int n) {
        JMods.check(n, METHOD, "method");
        return new JMods(n);
    }

    static JMods forClass(int n) {
        JMods.check(n, CLASS, "class");
        return new JMods(n);
    }

    static JMods forInterface(int n) {
        JMods.check(n, INTERFACE, "class");
        return new JMods(n);
    }

    public boolean isAbstract() {
        return (this.mods & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.mods & 0x40) != 0;
    }

    public boolean isSynchronized() {
        return (this.mods & 0x80) != 0;
    }

    public void setSynchronized(boolean bl) {
        this.setFlag(128, bl);
    }

    private void setFlag(int n, boolean bl) {
        this.mods = this.mods & ~n | (bl ? n : 0);
    }

    public void generate(JFormatter jFormatter) {
        if ((this.mods & 1) != 0) {
            jFormatter.p("public");
        }
        if ((this.mods & 2) != 0) {
            jFormatter.p("protected");
        }
        if ((this.mods & 4) != 0) {
            jFormatter.p("private");
        }
        if ((this.mods & 8) != 0) {
            jFormatter.p("final");
        }
        if ((this.mods & 0x10) != 0) {
            jFormatter.p("static");
        }
        if ((this.mods & 0x20) != 0) {
            jFormatter.p("abstract");
        }
        if ((this.mods & 0x40) != 0) {
            jFormatter.p("native");
        }
        if ((this.mods & 0x80) != 0) {
            jFormatter.p("synchronized");
        }
        if ((this.mods & 0x100) != 0) {
            jFormatter.p("transient");
        }
        if ((this.mods & 0x200) != 0) {
            jFormatter.p("volatile");
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JFormatter jFormatter = new JFormatter(new PrintWriter(stringWriter));
        this.generate(jFormatter);
        return stringWriter.toString();
    }
}

