/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.FieldWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private FieldWriter writer;
    private List<ProgramElementDoc> fields;
    private int currentFieldIndex;

    private FieldBuilder(Configuration configuration) {
        super(configuration);
    }

    public static FieldBuilder getInstance(Configuration configuration, ClassDoc classDoc, FieldWriter fieldWriter) {
        FieldBuilder fieldBuilder = new FieldBuilder(configuration);
        fieldBuilder.classDoc = classDoc;
        fieldBuilder.writer = fieldWriter;
        fieldBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 2, configuration.nodeprecated);
        fieldBuilder.fields = new ArrayList<ProgramElementDoc>(fieldBuilder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(fieldBuilder.fields, configuration.getMemberComparator());
        }
        return fieldBuilder;
    }

    public String getName() {
        return "FieldDetails";
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildFieldDoc(List list) {
        if (this.writer == null) {
            return;
        }
        this.currentFieldIndex = 0;
        while (this.currentFieldIndex < this.fields.size()) {
            this.build(list);
            ++this.currentFieldIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Field_Detail"));
    }

    public void buildFieldHeader() {
        this.writer.writeFieldHeader((FieldDoc)this.fields.get(this.currentFieldIndex), this.currentFieldIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((FieldDoc)this.fields.get(this.currentFieldIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((FieldDoc)this.fields.get(this.currentFieldIndex));
    }

    public void buildFieldComments() {
        if (!this.configuration.nocomment) {
            this.writer.writeComments((FieldDoc)this.fields.get(this.currentFieldIndex));
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((FieldDoc)this.fields.get(this.currentFieldIndex));
    }

    public void buildFieldFooter() {
        this.writer.writeFieldFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }

    public FieldWriter getWriter() {
        return this.writer;
    }
}

