/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ThreadGroupReference;
import com.sun.tools.example.debug.tty.Env;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadGroupIterator
implements Iterator<ThreadGroupReference> {
    private final Stack<Iterator<ThreadGroupReference>> stack = new Stack();

    ThreadGroupIterator(List<ThreadGroupReference> list) {
        this.push(list);
    }

    ThreadGroupIterator(ThreadGroupReference threadGroupReference) {
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>();
        arrayList.add(threadGroupReference);
        this.push(arrayList);
    }

    ThreadGroupIterator() {
        this(Env.vm().topLevelThreadGroups());
    }

    private Iterator<ThreadGroupReference> top() {
        return this.stack.peek();
    }

    private void push(List<ThreadGroupReference> list) {
        this.stack.push(list.iterator());
        while (!this.stack.isEmpty() && !this.top().hasNext()) {
            this.stack.pop();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public ThreadGroupReference next() {
        return this.nextThreadGroup();
    }

    public ThreadGroupReference nextThreadGroup() {
        ThreadGroupReference threadGroupReference = this.top().next();
        this.push(threadGroupReference.threadGroups());
        return threadGroupReference;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static ThreadGroupReference find(String string) {
        ThreadGroupIterator threadGroupIterator = new ThreadGroupIterator();
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            if (!threadGroupReference.name().equals(string)) continue;
            return threadGroupReference;
        }
        return null;
    }
}

