/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.oql;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.oql.OQLException;
import com.sun.tools.hat.internal.oql.OQLQuery;
import com.sun.tools.hat.internal.oql.ObjectVisitor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class OQLEngine {
    private Object engine;
    private Method evalMethod;
    private Method invokeMethod;
    private Snapshot snapshot;
    private static boolean debug;
    private static boolean oqlSupported;

    public static boolean isOQLSupported() {
        return oqlSupported;
    }

    public OQLEngine(Snapshot snapshot) {
        if (!OQLEngine.isOQLSupported()) {
            throw new UnsupportedOperationException("OQL not supported");
        }
        this.init(snapshot);
    }

    public synchronized void executeQuery(String string, ObjectVisitor objectVisitor) throws OQLException {
        String string2;
        String string3;
        OQLEngine.debugPrint("query : " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (!string3.equals("select")) {
                try {
                    Object object = this.evalScript(string);
                    objectVisitor.visit(object);
                }
                catch (Exception exception) {
                    throw new OQLException(exception);
                }
                return;
            }
        } else {
            throw new OQLException("query syntax error: no 'select' clause");
        }
        string3 = "";
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("from")) {
                bl = true;
                break;
            }
            string3 = string3 + " " + string2;
        }
        if (string3.equals("")) {
            throw new OQLException("query syntax error: 'select' expression can not be empty");
        }
        string2 = null;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        if (bl) {
            String string6;
            if (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
                if (string6.equals("instanceof")) {
                    bl2 = true;
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new OQLException("no class name after 'instanceof'");
                    }
                    string2 = stringTokenizer.nextToken();
                } else {
                    string2 = string6;
                }
            } else {
                throw new OQLException("query syntax error: class name must follow 'from'");
            }
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                if (string5.equals("where")) {
                    throw new OQLException("query syntax error: identifier should follow class name");
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                    if (!string6.equals("where")) {
                        throw new OQLException("query syntax error: 'where' clause expected after 'from' clause");
                    }
                    string4 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = string4 + " " + stringTokenizer.nextToken();
                    }
                    if (string4.equals("")) {
                        throw new OQLException("query syntax error: 'where' clause cannot have empty expression");
                    }
                }
            } else {
                throw new OQLException("query syntax error: identifier should follow class name");
            }
        }
        this.executeQuery(new OQLQuery(string3, bl2, string2, string5, string4), objectVisitor);
    }

    private void executeQuery(OQLQuery oQLQuery, ObjectVisitor objectVisitor) throws OQLException {
        JavaClass javaClass = null;
        if (oQLQuery.className != null && (javaClass = this.snapshot.findClass(oQLQuery.className)) == null) {
            throw new OQLException(oQLQuery.className + " is not found!");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("function __select__(");
        if (oQLQuery.identifier != null) {
            stringBuffer.append(oQLQuery.identifier);
        }
        stringBuffer.append(") { return ");
        stringBuffer.append(oQLQuery.selectExpr.replace('\n', ' '));
        stringBuffer.append("; }");
        String string = stringBuffer.toString();
        OQLEngine.debugPrint(string);
        String string2 = null;
        if (oQLQuery.whereExpr != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("function __where__(");
            stringBuffer.append(oQLQuery.identifier);
            stringBuffer.append(") { return ");
            stringBuffer.append(oQLQuery.whereExpr.replace('\n', ' '));
            stringBuffer.append("; }");
            string2 = stringBuffer.toString();
        }
        OQLEngine.debugPrint(string2);
        try {
            this.evalMethod.invoke(this.engine, string);
            if (string2 != null) {
                this.evalMethod.invoke(this.engine, string2);
            }
            if (oQLQuery.className != null) {
                Enumeration enumeration = javaClass.getInstances(oQLQuery.isInstanceOf);
                while (enumeration.hasMoreElements()) {
                    Object object;
                    boolean bl;
                    JavaHeapObject javaHeapObject = (JavaHeapObject)enumeration.nextElement();
                    Object[] objectArray = new Object[]{this.wrapJavaObject(javaHeapObject)};
                    boolean bl2 = bl = string2 == null;
                    if (!bl) {
                        object = this.call("__where__", objectArray);
                        if (object instanceof Boolean) {
                            bl = (Boolean)object;
                        } else if (object instanceof Number) {
                            bl = ((Number)object).intValue() != 0;
                        } else {
                            boolean bl3 = bl = object != null;
                        }
                    }
                    if (!bl || !objectVisitor.visit(object = this.call("__select__", objectArray))) continue;
                    return;
                }
            } else {
                Object object = this.call("__select__", new Object[0]);
                objectVisitor.visit(object);
            }
        }
        catch (Exception exception) {
            throw new OQLException(exception);
        }
    }

    public Object evalScript(String string) throws Exception {
        return this.evalMethod.invoke(this.engine, string);
    }

    public Object wrapJavaObject(JavaHeapObject javaHeapObject) throws Exception {
        return this.call("wrapJavaObject", new Object[]{javaHeapObject});
    }

    public Object toHtml(Object object) throws Exception {
        return this.call("toHtml", new Object[]{object});
    }

    public Object call(String string, Object[] objectArray) throws Exception {
        return this.invokeMethod.invoke(this.engine, string, objectArray);
    }

    private static void debugPrint(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    private void init(Snapshot snapshot) throws RuntimeException {
        this.snapshot = snapshot;
        try {
            Class<?> clazz = Class.forName("javax.script.ScriptEngineManager");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getEngineByName", String.class);
            this.engine = method.invoke(obj, "js");
            InputStream inputStream = this.getInitStream();
            Class<?> clazz2 = Class.forName("javax.script.ScriptEngine");
            this.evalMethod = clazz2.getMethod("eval", Reader.class);
            this.evalMethod.invoke(this.engine, new InputStreamReader(inputStream));
            Class<?> clazz3 = Class.forName("javax.script.Invocable");
            this.evalMethod = clazz2.getMethod("eval", String.class);
            this.invokeMethod = clazz3.getMethod("invokeFunction", String.class, Object[].class);
            Method method2 = clazz2.getMethod("put", String.class, Object.class);
            method2.invoke(this.engine, "heap", this.call("wrapHeapSnapshot", new Object[]{snapshot}));
        }
        catch (Exception exception) {
            if (debug) {
                exception.printStackTrace();
            }
            throw new RuntimeException(exception);
        }
    }

    private InputStream getInitStream() {
        return this.getClass().getResourceAsStream("/com/sun/tools/hat/resources/hat.js");
    }

    static {
        try {
            Class<?> clazz = Class.forName("javax.script.ScriptEngineManager");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getEngineByName", String.class);
            Object object = method.invoke(obj, "js");
            oqlSupported = object != null;
        }
        catch (Exception exception) {
            oqlSupported = false;
        }
        debug = false;
    }
}

