/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.tools.internal.jxc.ConfigReader;
import com.sun.tools.internal.jxc.apt.ErrorReceiverImpl;
import com.sun.tools.internal.jxc.apt.Messages;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.api.J2SJAXBModel;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.tools.internal.xjc.api.XJC;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationParser
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;
    private ErrorReceiver errorListener;

    public AnnotationProcessorEnvironment getEnv() {
        return this.env;
    }

    AnnotationParser(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.env = annotationProcessorEnvironment;
        this.errorListener = new ErrorReceiverImpl(annotationProcessorEnvironment.getMessager(), annotationProcessorEnvironment.getOptions().containsKey("-Ajaxb.debug"));
    }

    @Override
    public void process() {
        for (Map.Entry<String, String> entry : this.env.getOptions().entrySet()) {
            String string = entry.getKey();
            if (!string.startsWith("-Ajaxb.config=")) continue;
            String string2 = string.substring("-Ajaxb.config".length() + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            if (!stringTokenizer.hasMoreTokens()) {
                this.errorListener.error(null, Messages.NO_FILE_SPECIFIED.format(new Object[0]));
                continue;
            }
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                if (!file.exists()) {
                    this.errorListener.error(null, Messages.NON_EXISTENT_FILE.format(new Object[0]));
                    continue;
                }
                try {
                    ConfigReader configReader = new ConfigReader(this.env, this.env.getTypeDeclarations(), file, this.errorListener);
                    Collection<Reference> collection = configReader.getClassesToBeIncluded();
                    J2SJAXBModel j2SJAXBModel = XJC.createJavaCompiler().bind(collection, Collections.<QName, Reference>emptyMap(), null, this.env);
                    SchemaOutputResolver schemaOutputResolver = configReader.getSchemaOutputResolver();
                    j2SJAXBModel.generateSchema(schemaOutputResolver, this.errorListener);
                }
                catch (IOException iOException) {
                    this.errorListener.error(iOException.getMessage(), iOException);
                }
                catch (SAXException sAXException) {}
            }
        }
    }
}

