/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.tools.internal.ws.processor.generator.GeneratorConstants;
import com.sun.tools.internal.ws.processor.generator.GeneratorException;
import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.processor.model.java.JavaStructureMember;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBProperty;
import com.sun.tools.internal.ws.processor.util.DirectoryUtil;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.ws.util.ClassNameInfo;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.ws.streaming.PrefixFactory;
import com.sun.xml.internal.ws.streaming.PrefixFactoryImpl;
import com.sun.xml.internal.ws.util.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class Names
implements GeneratorConstants {
    protected String serializerNameInfix = null;
    protected PrefixFactory prefixFactory = new PrefixFactoryImpl("ns");
    protected static Map reservedWords = new HashMap();

    public String stubFor(Port port, String string) {
        String string2 = (String)port.getProperty("com.sun.xml.internal.ws.processor.model.StubClassName");
        if (string2 == null) {
            string2 = this.makeDerivedClassName(port.getJavaInterface(), "_Stub", string);
        }
        return string2;
    }

    public String tieFor(Port port, String string) {
        String string2 = (String)port.getProperty("com.sun.xml.internal.ws.processor.model.TieClassName");
        if (string2 == null) {
            string2 = this.makeDerivedClassName(port.getJavaInterface(), "_Tie", string);
        }
        return string2;
    }

    public String makeDerivedClassName(JavaInterface javaInterface, String string, String string2) {
        String string3 = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return string3 + (string2 == null ? "" : "_" + string2) + string;
    }

    public static String getPortName(Port port) {
        String string = (String)port.getProperty("com.sun.xml.internal.ws.processor.model.JavaPortName");
        if (string != null) {
            return string;
        }
        QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        String string2 = Names.stripQualifier(port.getJavaInterface().getName());
        return ClassNameInfo.replaceInnerClassSym(string2);
    }

    public static String stripQualifier(Class clazz) {
        String string = clazz.getName();
        return Names.stripQualifier(string);
    }

    public static String stripQualifier(String string) {
        return ClassNameInfo.getName(string);
    }

    public static String getPackageName(String string) {
        String string2 = ClassNameInfo.getQualifier(string);
        return string2 != null ? string2 : "";
    }

    public static String getUnqualifiedClassName(String string) {
        return ClassNameInfo.getName(string).replace('$', '.');
    }

    public File sourceFileForClass(String string, String string2, File file, ProcessorEnvironment processorEnvironment) throws GeneratorException {
        File file2 = DirectoryUtil.getOutputDirectoryFor(string, file, processorEnvironment);
        String string3 = Names.stripQualifier(string2);
        String string4 = string3 + ".java";
        return new File(file2, string4);
    }

    public static String getPackageName(Service service) {
        String string = Names.getPackageName(service.getJavaInterface().getName());
        return string;
    }

    public String customJavaTypeClassName(JavaInterface javaInterface) {
        String string = javaInterface.getName();
        return string;
    }

    public String customExceptionClassName(Fault fault) {
        String string = fault.getJavaException().getName();
        return string;
    }

    public String getExceptionClassMemberName() {
        return "faultInfo";
    }

    public String getQNameName(QName qName) {
        String string = this.getPrefix(qName) + "_" + qName.getLocalPart() + "_QNAME";
        return this.validInternalJavaIdentifier(string);
    }

    public String getBlockQNameName(Operation operation, Block block) {
        QName qName = block.getName();
        String string = this.getPrefix(qName);
        if (operation != null) {
            string = string + "_" + operation.getUniqueName();
        }
        string = string + "_" + qName.getLocalPart() + "_QNAME";
        return this.validInternalJavaIdentifier(string);
    }

    public String getTypeQName(QName qName) {
        String string = this.getPrefix(qName) + "_" + qName.getLocalPart() + "_TYPE_QNAME";
        return this.validInternalJavaIdentifier(string);
    }

    public String validJavaClassName(String string) {
        return JAXBRIContext.mangleNameToClassName((String)string);
    }

    public String validJavaMemberName(String string) {
        return JAXBRIContext.mangleNameToVariableName((String)string);
    }

    public String validInternalJavaIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append("_$");
                stringBuffer.append(Integer.toHexString(c));
                stringBuffer.append("$");
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("$");
            stringBuffer.append(Integer.toHexString(c));
            stringBuffer.append("$");
        }
        String string2 = stringBuffer.toString();
        String string3 = (String)reservedWords.get(string2);
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public String validExternalJavaIdentifier(String string) {
        return this.validInternalJavaIdentifier(string).replace('$', '_');
    }

    public String validJavaName(String string) {
        string = this.wordBreakString(string);
        String string2 = (String)reservedWords.get(string = this.removeWhiteSpace(string));
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public boolean isJavaReservedWord(String string) {
        return reservedWords.get(string) != null;
    }

    public String getJavaMemberReadMethod(JavaStructureMember javaStructureMember) {
        String string = null;
        string = javaStructureMember.getType().getRealName() == "boolean" ? "is" + StringUtils.capitalize((String)javaStructureMember.getName()) : "get" + StringUtils.capitalize((String)javaStructureMember.getName());
        return string;
    }

    public String getJavaMemberWriteMethod(JavaStructureMember javaStructureMember) {
        return "set" + StringUtils.capitalize((String)javaStructureMember.getName());
    }

    public static String getResponseName(String string) {
        return string + "Response";
    }

    public String getJavaReadMethod(JAXBProperty jAXBProperty) {
        if (jAXBProperty.getType().getName().equals("boolean")) {
            return "is" + StringUtils.capitalize((String)jAXBProperty.getName());
        }
        return this.getJavaReadMethod(jAXBProperty.getName());
    }

    public String getJavaWriteMethod(JAXBProperty jAXBProperty) {
        return this.getJavaWriteMethod(jAXBProperty.getName());
    }

    public String getJavaReadMethod(String string) {
        return "get" + StringUtils.capitalize((String)string);
    }

    public String getJavaWriteMethod(String string) {
        return "set" + StringUtils.capitalize((String)string);
    }

    public String removeWhiteSpace(String string) {
        String string2 = this.removeCharacter(32, string);
        return string2;
    }

    public String wordBreakString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isDigit(c)) {
                if (i + 1 >= stringBuffer.length() || Character.isDigit(stringBuffer.charAt(i + 1))) continue;
                stringBuffer.insert(1 + i++, ' ');
                continue;
            }
            if (Character.isSpaceChar(c) || c == '_') continue;
            if (!Character.isJavaIdentifierPart(c)) {
                stringBuffer.setCharAt(i, ' ');
                continue;
            }
            if (Character.isLetter(c)) continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }

    public String removeCharacter(int n, String string) {
        int n2 = string.indexOf(n);
        while (n2 >= 0) {
            string = string.substring(0, n2) + StringUtils.capitalize((String)string.substring(n2 + 1).trim());
            n2 = string.indexOf(32);
        }
        return string;
    }

    public String getPrefix(QName qName) {
        return this.getPrefix(qName.getNamespaceURI());
    }

    public String getPrefix(String string) {
        return this.prefixFactory.getPrefix(string);
    }

    public void resetPrefixFactory() {
        this.prefixFactory = new PrefixFactoryImpl("ns");
    }

    public void setSerializerNameInfix(String string) {
        if (string != null && string.length() > 0) {
            this.serializerNameInfix = "_" + string;
        }
    }

    public String getSerializerNameInfix() {
        String string = this.serializerNameInfix;
        if (this.serializerNameInfix != null && this.serializerNameInfix.charAt(0) == '_') {
            string = this.serializerNameInfix.substring(1);
        }
        return string;
    }

    static {
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("enum", "_enum");
    }
}

